package com.digiwin.athena.semc.service.sso;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.erpsso.AddSsoInfoReq;
import com.digiwin.athena.semc.dto.erpsso.QueryDisplayReq;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author zhangtuo
 * @since 2022-10-28
 */
public interface IErpSsoInfoService extends IService<ErpSsoInfo> {

    /**
     * 查询稳态配置列表 默认带tenantId
     *
     * @param tenantId 租户id
     * @return
     */
    public List<ErpSsoInfo> querySsoList(String tenantId, Integer protocolType);

    /**
     * 查询code、name、appToken已存在
     *
     * @param id       应用主键id
     * @param appCode  应用code
     * @param appName  应用名称
     * @param appToken 应用token
     * @return 返回
     */
    public List<ErpSsoInfo> existByNameOrAppToken(Long id, String appCode, String appName, String appToken);

    /**
     * 新增或修改稳态配置信息
     *
     * @param addSsoInfoReq 新增实体类
     * @return
     */
    public Long saveOrUpdateSsoInfo(AddSsoInfoReq addSsoInfoReq);

    /**
     * 查询稳态配置信息 默认带tenantId
     *
     * @param ssoId 稳态配置id
     * @return
     */
    public ErpSsoInfo querySsoInfo(Long ssoId);

    /**
     * 修改生效状态 默认带tenantId
     *
     * @param ssoInfoId 配置id
     * @param status    状态
     * @return
     */
    public int updateSsoStatus(Long ssoInfoId, Integer status);

    /**
     * 更新应用的归户模式
     *
     * @param ssoIdList    应用id列表
     * @param userBindFlag 归户模式
     * @return
     */
    public void updateBindFlag(List<Long> ssoIdList, Integer userBindFlag);

    /**
     * 删除配置参数 默认带tenantId
     *
     * @param ssoId 配置id
     */
    public void deleteErpSsoParams(Long ssoId);

    /**
     * 获取所有稳态配置列表后台拼接参数
     *
     * @return
     */
    public List<ErpSsoInfo> erpSsoInfoWithParams();

    /**
     * 获取稳态配置列表后台拼接参数
     *
     * @return
     */
    ErpSsoInfo erpSsoInfoWithParams(AuthoredUser user, QueryDisplayReq req);

    /**
     * 查询稳态的应用列表
     *
     * @param querySsoListReq 请求实体
     * @return
     */
    List<ErpSsoInfo> querySsoListByScope(QuerySsoListReq querySsoListReq);

    /**
     * 根据appId查询租户
     *
     * @param appId 应用id
     * @return 返回
     */
    List<String> queryTenantIdByAppId(String appId);


    /**
     * 根据id查询稳态信息
     * @param csIdList
     * @return
     */
    Map<Long, ErpSsoInfo> getErpInfoMap(List<String> csIdList);
}
