package com.digiwin.athena.semc.service.sso;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.entity.sso.MobileSsoInfo;

import java.util.List;

/**
 * 移动端SSO应用配置
 *
 * @author sungq
 * @since 2024-10-24
 */
public interface IMobileSsoInfoService extends IService<MobileSsoInfo> {

    /**
     * 校验应用是否存在
     *
     * @param mobileSsoInfo 请求实体
     * @return 返回
     */
     List<MobileSsoInfo> existMobileApp(MobileSsoInfo mobileSsoInfo);

    /**
     * 保存应用配置
     *
     * @param mobileSsoInfoReq 请求入参
     * @return 返回
     */
    Long saveMobileSso(MobileSsoInfo mobileSsoInfoReq);

    /**
     * 查询应用配置
     *
     * @param id 主键id
     * @return 返回
     */
    MobileSsoInfo queryMobileSsoInfo(Long id);

    /**
     * 构建移动端应用SSO链接
     *
     * @param id 主键id
     * @return 返回
     */
    List<MobileSsoInfo> queryMobileLinkSsoList(Long id);
}
