package com.digiwin.athena.semc.service.sso;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.dto.erpsso.RegisterDTO;
import com.digiwin.athena.semc.dto.erpsso.ThirdSsoInfoDto;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author sungq
 * @since 2022-11-28
 */
public interface IThirdSsoInfoService extends IService<ThirdSsoInfo> {
    /**
     * 查询敏态配置列表 默认带tenantId
     *
     * @return
     */
    List<ThirdSsoInfoDto> erpSsoInfoWithParams();

    /**
     * 查询code、name、appToken已存在
     *
     * @param id       应用主键id
     * @param appCode  应用code
     * @param appName  应用名称
     * @param appToken 应用token
     * @return 返回
     */
    public List<ThirdSsoInfo> existThirdSso(Long id, String appCode, String appName, String appToken);

    /**
     * 新增或修改配置信息
     *
     * @param thirdSsoInfo 实体类
     * @return
     */
    public Long saveOrUpdateThirdSso(ThirdSsoInfo thirdSsoInfo);

    /**
     * 查询配置信息 默认带tenantId
     *
     * @param ssoId 配置id
     * @return
     */
    public ThirdSsoInfo queryThirdSsoInfo(Long ssoId);

    /**
     * 修改生效状态 默认带tenantId
     *
     * @param ssoInfoId 配置id
     * @param status 状态
     * @return
     */
    public int updateThirdSsoStatus(Long ssoInfoId, Integer status);

    /**
     * 更新应用的归户模式
     *
     * @param ssoIdList 应用id列表
     * @param userBindFlag 归户模式
     * @return
     */
    public void updateBindFlag(List<Long> ssoIdList, Integer userBindFlag);

    /**
     * 注册应用
     *
     * @param registerDTO 请求体
     * @return
     */
    public RegisterDTO registerApp(RegisterDTO registerDTO) throws Exception;

    /**
     * 查询敏态的应用列表
     *
     * @param querySsoListReq 请求实体
     * @return
     */
    List<ThirdSsoInfo> queryThirdListByScope(QuerySsoListReq querySsoListReq);


    /**
     * 查询敏态信息转Map
     * @param bsIdList
     * @return
     */
    Map<Long, ThirdSsoInfo> getSsoInfoMap(List<String> bsIdList);
}
