package com.digiwin.athena.semc.service.temp;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateBenchImport;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.temp.TemplateBenchExportVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchImportVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchVO;

import java.util.List;

public interface TemplateBenchService extends IService<TemplateBench> {


    /**
     * 作业工作台模版保存接口
     * @param req
     * @return
     */
    TemplateBenchVO saveBenchTemp(TemplateBenchVO req);

    /**
     * 查询模版下作业工作台接口
     * @param req
     * @return
     */
    TemplateBenchVO queryBenchByTemp(TemplateBenchVO req);


    /**
     * 获取全部租户和部分租户可见的作业工作台模版
     * @return
     */
    List<TemplateBench> queryTempBenchList();


    /**
     * 导入作业工作台--读取excel数据
     * @param fileId
     * @return
     */
    List<TemplateBenchImportVo> readExcel(String fileId);

    /**
     * 导入作业工作台
     * @param jobBenchImportVoList
     * @return
     */
    ImportExcelResp importReport(List<TemplateBenchImportVo> jobBenchImportVoList);

    /**
     * 查询作业工作台记录
     * @param queryImportRecordReq
     * @return
     */
    PageInfoResp<TemplateBenchImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq);


    /**
     * 导出作业工作台
     * @return
     */
    List<TemplateBenchExportVo> exportReport();


}