package com.digiwin.athena.semc.service.temp;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.dto.portal.UsePortalInfoDto;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.entity.temp.TemplateInfoTenant;
import com.digiwin.athena.semc.vo.portal.QueryTempAppListVo;
import org.springframework.http.ResponseEntity;

import java.util.List;

public interface TemplateInfoService extends IService<TemplateInfo> {

    /**
     * 分页查询模版配置列表
     * @param req
     * @return
     */
    ResultPageBean pageQuery(TemplateQueryReq req);

    /**
     * 保存模版配置信息
     * @param req
     * @return
     */
    Long saveTemp(TemplateInfo req);


    /**
     * 条件查询
     * @param req
     * @return
     */
    List<TemplateInfo> queryByParam(TemplateInfo req);

    /**
     * 批量删除
     * @param idList
     * @return
     */
    ResponseEntity<?> batDel(List<Long> idList);

    /**
     * 发布和停用
     * @param idList
     * @return
     */
    ResponseEntity<?>   updateStatus(List<Long> idList,Integer status);


    /**
     * 批量发布模版到租户接口
     * @param req
     * @return
     */
    Integer batTempToTenant(TemplateInfo req);

    /**
     * 组装部分租户时分组和租户的数据
     * @param req
     * @param tempId
     * @return
     */
    List<TemplateInfoTenant> addTempTeanntList(TemplateInfo req, Long tempId);

    /**
     * 查询模版下SSO应用
     * @return
     */
    List<QueryTempAppListVo> queryTempAppList(TemplateInfo req);

    /**
     * 校验租户该模版中源应用涉及的雅典娜应用，是否具备雅典娜应用应用权限
     * @param portId
     * @return
     */
    ResponseEntity<?>  checkUserTemplate(Long portId);



    /**
     * 租户雅典娜涉及组件权限同步
     * @param portId
     * @return
     */
    ResponseEntity<?> confimTenTemplate(Long portId);

    /**
     * 立即使用ISV门户模版
     * @param req
     * @return
     */
    PortalInfo usePortalInfo(UsePortalInfoDto req);

    /**
     * 查询作业工作台中源应用权限
     * 校验租户该模版中源应用涉及的雅典娜应用，是否具备雅典娜应用应用权限
     * @return
     */
    ResponseEntity<?>  checkBenchTemplate(List<Long> benchIdList);

    /**
     * 雅典娜涉及组件权限同步【作业工作台】
     * @return
     */
    ResponseEntity<?> confimBenchTemplate(List<Long> benchIdList);

    /**
     * 立即使用ISV门户模版【作业工作台】
     * @param req
     * @return
     */
    ResponseEntity<?>  useBenchTemp(UsePortalInfoDto req);

    /**
     * 根据模版ID获取模版的部分分组和租户信息
     * @param tempId
     * @return
     */
    TemplateInfo  getTempGroupVO(Long tempId);


    /**
     * 查询租户可见的模版信息
     * @param templateType
     * @return
     */
    List<TemplateBench> queryVisibleTempList(Integer templateType);
}