package com.digiwin.athena.semc.service.temp;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustomImport;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.SystemCustomExportVo;
import com.digiwin.athena.semc.vo.portal.SystemCustomImportVo;
import org.springframework.http.ResponseEntity;

import java.util.List;


public interface TemplateSystemCustomService extends IService<TemplateSystemCustom> {

    /**
     * 查询自定义组件列表
     * @param labelSystemCustomQueryReq
     * @return
     */
    ResultPageBean pageQuery(LabelSystemCustomQueryReq labelSystemCustomQueryReq);


    /**
     * 保存自定义组件
     * @param labelSystemCustomSaveReq
     * @return
     */
    ResponseEntity<?> save(LabelSystemCustomSaveReq labelSystemCustomSaveReq);

    /**
     * 删除自定义组件
     * @param idList
     * @return
     */
    ResponseEntity<?> delete(List<Long> idList);

    /**
     * 查询所有自定义组件
     * @param req
     * @return
     */
    List<TemplateSystemCustom> queryCustomSystem(LabelSystemAllVo req);


    /**
     * 导入自定义组件--读取excel数据
     * @param fileId
     * @return
     */
    List<SystemCustomImportVo> readExcel(String fileId);


    /**
     * 导入自定义组件
     * @param customImportVoList
     * @return
     */
    ImportExcelResp importReport(List<SystemCustomImportVo> customImportVoList);

    /**
     * 查询组件导入记录
     * @param queryImportRecordReq
     * @return
     */
    PageInfoResp<TemplateSystemCustomImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq);


    /**
     * 导出自定义组件
     * @return
     */
    List<SystemCustomExportVo> exportReport();

    /**
     * 条件查询自定义组件
     * @param req
     * @return
     */
    List<TemplateSystemCustom> queryCustomList(LabelSystemAllVo req);
}