package com.digiwin.athena.semc.service.temp;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemDataImport;
import com.digiwin.athena.semc.vo.portal.*;
import org.springframework.http.ResponseEntity;

import java.util.List;


public interface TemplateSystemDataService extends IService<TemplateSystemData> {


    /**
     * 条件查询数据源信息
     * @param req
     * @return
     */
    PageInfoResp<TemplateSystemData> queryDataList(QueryLabelSystemReq req);

    /**
     *启用停用数据源
     * @param req
     * @return
     */
    ResponseEntity<?> updateValidStatus(QueryLabelSystemReq req);


    /**
     *删除数据源
     * @param req
     * @return
     */
    ResponseEntity<?> delData(QueryLabelSystemReq req);


    /**
     *保存数据源
     * @param req
     * @return
     */
    ResponseEntity<?> saveData(TemplateSystemData req);


    /**
     * 根据ID批量查询数据源信息
     * @param
     * @return
     */
    List<TemplateSystemData> queryByIds(List<Long> ids);


    /**
     * 获取SSO中应用被数据源引用的数据源名称集合
     * @return
     */
    List<String>  getDataNameList(Integer dataType, String appCode);


    /**
     * 根据ID批量查询数据源信息
     * @param ids 数据源iD
     * @return
     */
    List<TemplateSystemData> queryDataInfoBy(List<Long> ids);


    /**
     * 获取数据源和sso信息
     * @param id
     * @return
     */
    LabelSystemDataDto getSystemDataSso(Long id);


    /**
     * 获取数据源涉及的源应用map
     * @return
     */
    LabelSystemDataAppVo getSsoAppMap(List<TemplateSystemData> systemDataTempList);



    /**
     * 获取数据源涉及的源应用map---忽略租户
     * @return
     */
    LabelSystemDataAppVo getSsoAppMapTemp(List<TemplateSystemData> systemDataTempList);


    /**
     * 导入数据源--读取excel数据
     * @param fileId
     * @return
     */
    List<SystemDataImportVo> readExcel(String fileId);


    /**
     * 导入数据源
     * @param dataImportVoList
     * @return
     */
    ImportExcelResp importReport(List<SystemDataImportVo> dataImportVoList);

    /**
     * 查询数据源导入记录
     * @param queryImportRecordReq
     * @return
     */
    PageInfoResp<TemplateSystemDataImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq);


    /**
     * 导出数据源
     * @return
     */
    List<SystemDataExportVo> exportReport();

    /**
     * 查询自定义组件涉及数据源
     * @param systemID
     * @return
     */
    List<Long>  selectBySystemId(Long systemID);
}