package com.digiwin.athena.semc.service.temp;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataSourceUpdateReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateSystemPre;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import org.springframework.http.ResponseEntity;

import java.util.List;


public interface TemplateSystemPreService extends IService<TemplateSystemPre> {

    /**
     * 查询预设组件列表
     * @param labelSystemPreQueryReq
     * @return
     */
    ResultPageBean pageQuery(LabelSystemPreQueryReq labelSystemPreQueryReq);

    /**
     *  更新组件数据源
     * @param labelSystemUpdateReq
     * @return
     */
    ResponseEntity<?> updateDataSource(LabelSystemDataSourceUpdateReq labelSystemUpdateReq);


    /**
     * 更新启用停用状态
     * @param id
     * @param validStatus
     * @param componentSource
     * @return
     */
    ResponseEntity<?> updateValidStatus(Long id, Integer validStatus, Integer componentSource);


    /**
     * 根据租户初始化租户的预设组件
     * @return
     */
    List<TemplateSystemPre> initPreData();


    /**
     *
     * @param dataType 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、
     *                 5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     * @return
     */
    TemplateSystemPre getPreSystemID(Integer dataType);


    /**
     * 查询预设组件和自定义组件列表
     * @param req
     * @return
     */
    LabelSystemPreCustomVo queryAllSystem(LabelSystemAllVo req);

    /**
     * 初始化默认布局涉及的组件
     * @return
     */
    List<TemplateSystemPre> initDefPortal(List<Integer> dataCategoryList);
}