package com.digiwin.athena.semc.service.temp;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;

import java.util.List;


public interface TemplateTenantGroupService extends IService<TemplateTenantGroup> {


    /**
     * 保存分组信息
     * @param req
     * @return
     */
    Long saveTenantGroup(TemplateTenantGroup req);


    /**
     * 保存分组下租户信息
     * @param req
     * @return
     */
    Integer saveGroupTenant(TemplateTenantGroup req);

    /**
     * 查询分组下所有的租户
     * @param groupId
     * @return
     */
    List<TemplateTenantGroupItem> queryGroupTenant(Long groupId);

    /**
     * 查询所有分组
     * @param req
     * @return
     */
    List<TemplateTenantGroup> selTenantGroup(TemplateTenantGroup req);

    /**
     * 分页查询分组下租户列表
     * @param req
     * @return
     */
    ResultPageBean pageQueryGroupTenant(TemplateQueryReq req);

    /**
     * 批量启用停用分组
     * @param req
     * @return
     */
    Integer updateStatus(TemplateQueryReq req);

    /**
     * 批量启用停用分组
     * @param req
     * @return
     */
    Integer delGroup(TemplateQueryReq req);

    /**
     * 批量删除分组下租户
     * @param idList
     * @return
     */
    Integer delGroupTenant(List<Long> idList);

    /**
     * 条件查询分组
     * @param req
     * @return
     */
    List<TemplateTenantGroup> selGroupBy(TemplateTenantGroup req);

}
