package com.digiwin.athena.semc.service.temp;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateUserMapping;
import com.digiwin.athena.semc.entity.temp.TemplateUserTenant;

import java.util.List;


public interface TemplateUserMappingService extends IService<TemplateUserMapping> {


    /**
     * 获取租户下所有已关联的账号列表
     * @return
     */
    List<TemplateUserMapping> selAllMappingUser(String subUserNameId);


    /**
     * 分页查询账号关联租户列表
     * @param req
     * @return
     */
    ResultPageBean pageQueryUserTenant(TemplateQueryReq req);

    /**
     * 分页查询登录用户账号的租户列表
     * @param req
     * @return
     */
    ResultPageBean pageLongUserTenant(TemplateQueryReq req);

    /**
     * 查询当前登录用户全量租户列表
     * @return
     */
    List<TemplateUserTenant> getLongUserTenant();

    /**
     * 查询账号关联的全量租户
     * @param id
     * @return
     */
    List<TemplateUserTenant> queryUserAllTenant(Long id);

    /**
     * 批量保存账号关联租户信息
     * @param req
     * @return
     */
    Integer saveUserTenant(List<TemplateUserMapping> req);


    /**
     * 删除账号
     * @param id 关联关系ID
     * @return
     */
    Integer delUserMapping(Long id);

    /**
     * 批量删除账号下租户
     * @param idList 关联关系租户表ID
     * @return
     */
    Integer delUserTenant(List<Long> idList);

}