package com.digiwin.athena.semc.service.temp.impl;

import com.google.common.collect.Lists;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.bench.JobBench;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateBenchCustom;
import com.digiwin.athena.semc.entity.temp.TemplateBenchImport;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.entity.temp.TemplateInfoTenant;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchImportMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.temp.TemplateBenchService;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.service.temp.TemplateSystemCustomService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.bench.JobBenchImportVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchExportVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchImportVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchVO;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import io.github.linpeilie.Converter;

@Service
public class TemplateBenchServiceImpl extends ServiceImpl<TemplateBenchMapper, TemplateBench> implements TemplateBenchService {

    @Resource
    TemplateInfoMapper templateInfoMapper;

    @Resource
    TemplateInfoTenantMapper templateInfoTenantMapper;

    @Resource
    TemplateBenchMapper templateBenchMapper;

    @Resource
    TemplateBenchCustomMapper templateBenchCustomMapper;

    @Resource
    TemplateInfoService templateInfoService;

    @Resource
    TemplateSystemCustomService templateSystemCustomService;

    @Resource
    private IImportRecordService importRecordService;

    @Resource
    TemplateBenchImportMapper templateBenchImportMapper;

    @Resource
    private EnvProperties envProperties;

    @Autowired
    MdcService mdcService;

    @Resource
    private Converter converter;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public TemplateBenchVO saveBenchTemp(TemplateBenchVO req) {
        //先保存模版信息
        TemplateInfo templateInfo = packageTemplateInfo(req);
        Long tempId = templateInfoService.saveTemp(templateInfo);
        //工作台ID不为空，先删除工作台和泳道以及作业
        if(null !=req.getId()){
            //删除工作台
            templateBenchMapper.deleteById(req.getId());
            List<TemplateBench>  laneList=templateBenchMapper.selectChildByTemp(req.getId());
            if(CollectionUtils.isNotEmpty(laneList)){
                List<Long> laneIdList = laneList.stream().map(TemplateBench::getId).collect(Collectors.toList());
                //删除泳道
                templateBenchMapper.deleteBatchIds(laneIdList);
                //删除作业
                templateBenchCustomMapper.delBenchJob(laneIdList);
            }
        }
        req.setTemplateId(tempId);
        //保存工作台和泳道数据
        TemplateBench bench = packageTemplateBench(req.getTemplateName(), tempId, 0L, 0);
        templateBenchMapper.insert(bench);
        req.setId(bench.getId());
        //保存工作台作业数据
        saveBenchCustom(tempId, req, bench.getId());
        //如果发布的租户非部分租户，则结束
        if(null ==req.getSubType() || !req.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())){
            return null;
        }
        //删除模版中的租户
        List<Long> templateIdList=new ArrayList<>();
        templateIdList.add(tempId);
        templateInfoTenantMapper.delByTemp(templateIdList);
        //保存发布到租户的数据
        TemplateInfo tenantReq=new TemplateInfo();
        tenantReq.setSubTenantList(req.getSubTenantList());
        tenantReq.setGroupList(req.getGroupList());
        List<TemplateInfoTenant> tenantGroupList=templateInfoService.addTempTeanntList(tenantReq,tempId);
        if(CollectionUtils.isNotEmpty(tenantGroupList)){
            templateInfoTenantMapper.batchInsertTenant(tenantGroupList,Utils.getUserId(),DateUtils.getNowTime(""));
        }
        return null;
    }


    /**
     * 保存泳道/作业信息
     * @param tempId
     * @param req
     * @param benchId
     */
    public void saveBenchCustom(Long tempId,TemplateBenchVO req,Long benchId) {
        if(CollectionUtils.isEmpty(req.getLaneList())){
            return;
        }
        //保存泳道
        for (int i = 0; i < req.getLaneList().size(); i++) {
            TemplateBench bench = packageTemplateBench(req.getLaneList().get(i).getName(), tempId, benchId, i);
            templateBenchMapper.insert(bench);
            List<Long> systemIdList=req.getLaneList().get(i).getSystemIdList();
            if(CollectionUtils.isEmpty(systemIdList)){
                continue;
            }
            List<TemplateBenchCustom> templateBenchCustoms=new ArrayList<>();
            //保存泳道下作业
            for (int m = 0; m < systemIdList.size(); m++) {
                TemplateBenchCustom customTemp = packageBenchCustom(bench.getId(),systemIdList.get(m),m);
                templateBenchCustoms.add(customTemp);
            }
            if(CollectionUtils.isNotEmpty(templateBenchCustoms)){
                templateBenchCustomMapper.insertBatch(templateBenchCustoms);
            }
        }
    }


    /**
     * 组装泳道下作业数据
     * @param benchId 泳道ID
     * @param systemId 作业ID
     * @param labelIndex 位置下标
     * @return
     */
    public TemplateBenchCustom  packageBenchCustom(Long benchId,Long systemId,Integer labelIndex) {
        TemplateBenchCustom customTemp = new TemplateBenchCustom();
        customTemp.setBenchId(benchId);
        customTemp.setSystemId(systemId);
        customTemp.setLabelIndex(labelIndex);
        customTemp.setTenantId(Utils.getTenantId());
        customTemp.setCreateTime(DateUtils.getNowTime(""));
        customTemp.setCreateUserId(Utils.getUserId());
        return customTemp;
    }
    /**
     * 组装工作台数据
     * @param name 工作台/泳道名称
     * @param tempId 模版ID
     * @param parentId 上级ID
     * @param labelIndex 位置下标
     * @return
     */
    public TemplateBench  packageTemplateBench(String name,Long tempId,Long parentId,Integer labelIndex){
        TemplateBench benchTemp=new TemplateBench();
        benchTemp.setName(name);
        benchTemp.setParentId(parentId);
        benchTemp.setTemplateId(tempId);
        benchTemp.setLabelIndex(labelIndex);
        benchTemp.setTenantId(Utils.getTenantId());
        benchTemp.setCreateTime(DateUtils.getNowTime(""));
        benchTemp.setCreateUserId(Utils.getUserId());
        return benchTemp;
    }
    /**
     * 组装模版数据
     * @param req
     * @return
     */
    public TemplateInfo packageTemplateInfo(TemplateBenchVO req) {
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setId(req.getTemplateId());
        templateInfo.setTemplateName(req.getTemplateName());
        templateInfo.setTemplateDesc(req.getTemplateDesc());
        templateInfo.setSubType(req.getSubType());
        templateInfo.setTemplateType(Constants.TemplateTypeEnum.JOB_BENCH.getVal());
        templateInfo.setStatus(req.getStatus());
        return templateInfo;
    }


    @Override
    public TemplateBenchVO queryBenchByTemp(TemplateBenchVO req) {
        TemplateBenchVO benchVO = new TemplateBenchVO();
        TemplateInfo templateInfo = templateInfoMapper.selectById(req.getTemplateId());
        if (null == templateInfo) {
            return benchVO;
        }
        converter.convert(templateInfo,benchVO);
        benchVO.setTemplateId(templateInfo.getId());
        benchVO.setId(null);
        //查询工作台信息
        List<TemplateBench> benchList=templateBenchMapper.selectBenchList(null,0L,req.getTemplateId());
        if(CollectionUtils.isEmpty(benchList)){
            return benchVO;
        }
        benchVO.setId(benchList.get(0).getId());
        //查询泳道
        List<TemplateBench> laneList=templateBenchMapper.selectBenchList(null,benchList.get(0).getId(),req.getTemplateId());
        if(CollectionUtils.isEmpty(laneList)){
            return benchVO;
        }
        for(TemplateBench lane:laneList){
            //查询泳道下作业
            List<TemplateBenchCustom> benchCustomList=templateBenchCustomMapper.selectBenchJob(null,lane.getId());
            lane.setJobList(benchCustomList);
        }
        benchVO.setLaneList(laneList);
        //不是部分租户方式，跳过
        if (null==templateInfo.getSubType() ||  !templateInfo.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
            return benchVO;
        }
        //部分租户方式，取出模版中部分租户的数据（包括分组和租户）
        TemplateInfo templateGroup=templateInfoService.getTempGroupVO(templateInfo.getId());
        benchVO.setSubTenantList(templateGroup.getSubTenantList());
        benchVO.setGroupList(templateGroup.getGroupList());
        return benchVO;
    }

    @Override
    public List<TemplateBench> queryTempBenchList() {
        //获取全部租户和部分租户可见的作业工作台模版
        List<TemplateBench> benchList =templateInfoService.queryVisibleTempList(Constants.TemplateTypeEnum.JOB_BENCH.getVal());
        return benchList;
    }

    @Override
    public List<TemplateBenchImportVo> readExcel(String fileId) {
        DMC dmcInstance = mdcService.buildDmc();
        List<TemplateBenchImportVo> excelVoList;
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            // 读取sheet
            ExcelReader excelReader = EasyExcelFactory.read(input).build();
            excelReader.read(EasyExcelFactory.readSheet(0).head(TemplateBenchImportVo.class).headRowNumber(2).registerReadListener(excelListener).build());
            // 这里千万别忘记关闭，读的
            excelReader.finish();
            excelVoList = mdcService.doReadSync(excelListener);
        } catch (Exception e) {
            log.error("JobBenchImport read excel occur error", e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ImportExcelResp importReport(List<TemplateBenchImportVo> jobBenchImportVoList) {
        ImportExcelResp excelResp = new ImportExcelResp();
        //自定义组件map,key:名称,val:自定义组件
        Map<String, TemplateSystemCustom> systemCustomTempMap = new HashMap<>();
        //excel中工作台和泳道/作业信息map,key:工作台名称+工作台下泳道名称,val:作业名称
        Map<String, List<String>> jobNameMap = new HashMap<>();
        //excel中已经插入的工作台信息map,key:工作台名称,val:工作台ID
        Map<String, Long> benchNameIdMap = new HashMap<>();
        //excel中已经插入的泳道信息map,key:工作台名称+泳道名称,val:泳道ID
        Map<String, Long> laneIdMap = new HashMap<>();
        //工作台信息和模版信息关系map,key:工作台ID，val:模版ID
        Map<Long, Long> benchTempIdMap=new HashMap<>();
        //查询自定义组件-作业 和自定义组件-应用 分类的自定义组件
        LabelSystemAllVo req = new LabelSystemAllVo();
        List<Integer> dataCategoryList = new ArrayList<>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List<TemplateSystemCustom> systemCustomTempList = templateSystemCustomService.queryCustomList(req);
        if (CollectionUtils.isNotEmpty(systemCustomTempList)) {
            systemCustomTempMap = systemCustomTempList.stream().collect(Collectors.toMap(TemplateSystemCustom::getNameZh, Function.identity(), (a, b) -> a));
        }
        List<String> benchNameList = new ArrayList<>();
        //工作台位置下标
        Integer benchIndex = 0;
        //查询工作台信息
        List<TemplateBench> jobBenchTempList = templateBenchMapper.selectBenchList(new ArrayList<Long>(), 0L, null);
        if (CollectionUtils.isNotEmpty(jobBenchTempList)) {
            benchIndex = jobBenchTempList.get(jobBenchTempList.size() - 1).getLabelIndex() + 1;
            benchNameList = jobBenchTempList.stream().map(TemplateBench::getName).collect(Collectors.toList());
        }
        int successNum = 0;
        int failNum = 0;
        //泳道位置下标
        Integer laneIndex = 0;
        //作业位置下标
        Integer jobIndex = 0;
        for (TemplateBenchImportVo jobBenchImportVo : jobBenchImportVoList) {
            // 基础校验
            StringBuilder errorSb = validateData(jobBenchImportVo, benchNameList, systemCustomTempMap, jobNameMap);
            if (StringUtils.isNotBlank(errorSb.toString())) {
                failNum++;
                jobBenchImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            List<String> jobNameList = jobNameMap.get(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName());
            if (CollectionUtils.isEmpty(jobNameList)) {
                jobNameList = new ArrayList<>();
            }
            jobNameList.add(jobBenchImportVo.getJobName());
            jobNameMap.put(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName(), jobNameList);
            jobBenchImportVo.setFailDesc(errorSb.toString());
            //插入作业工作台和泳道
            initJobBench(jobBenchImportVo, systemCustomTempMap, benchNameIdMap, benchIndex, laneIndex, jobIndex, laneIdMap,benchTempIdMap);
            successNum++;
        }
        String nowTime = DateUtils.getNowTime(DateUtils.DATE_TIME_FORMATTER);
        String pathName = "作业工作台导入记录_" + nowTime + ".xlsx";
        //生成失败的excel文件
        ShareInfo shareInfo = importRecordService.uploadExcel(write(jobBenchImportVoList, pathName));
        //初始化导入记录
        initDataImport(shareInfo.getFileId(), successNum, failNum, nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        // 构建返回信息
        String resultCode;
        if (successNum > 0 && failNum == 0) {
            resultCode = "2001";
        } else if (successNum > 0 && failNum > 0) {
            resultCode = "2002";
        } else if (successNum == 0 && failNum > 0) {
            resultCode = "2003";
        } else {
            resultCode = "2003";
        }
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(failNum);
        excelResp.setSuccessCount(successNum);
        return excelResp;
    }


    /**
     * 初始化作业工作台导入记录
     *
     * @param fileId
     * @param successCount
     * @param failCount
     * @return
     */
    public TemplateBenchImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        TemplateBenchImport importRecord = new TemplateBenchImport();
        importRecord.setFileId(fileId);
        importRecord.setSuccessCount(successCount);
        importRecord.setFailCount(failCount);
        importRecord.setCreateUserName(Utils.getUserName());
        importRecord.setCreateUserId(Utils.getUserId());
        importRecord.setCreateTime(DateUtils.getDateFormat(nowTime, DateUtils.DATE_TIME_FORMATTER, DateUtils.DATE_TIME_NORMAL_FORMATTER));
        importRecord.setModifyTime(DateUtils.getDateFormat(nowTime, DateUtils.DATE_TIME_FORMATTER, DateUtils.DATE_TIME_NORMAL_FORMATTER));
        importRecord.setModifyUserId(Utils.getUserId());
        importRecord.setTenantId(Utils.getTenantId());
        templateBenchImportMapper.insert(importRecord);
        return importRecord;
    }

    /**
     * 写入excel文件
     *
     * @param list 报表数据
     * @return
     */
    public File write(List<TemplateBenchImportVo> list, String pathName) {
        File file = new File(pathName);
        EasyExcel.write(file, JobBenchImportVo.class)
                .registerWriteHandler(Utils.initHorizontalCell())
                .relativeHeadRowIndex(1).registerWriteHandler(new TemplateBenchWriteHandler()).sheet("ISV作业工作台").doWrite(list);
        return file;
    }

    /**
     * 新增工作台、泳道、作业和泳道关系
     *
     * @param jobBenchImportVo excel 中工作台、泳道信息
     * @param systemCustomTempMap  数据库中租户下自定义组件信息map
     * @param benchNameIdMap   工作台名称和ID的关系map
     * @param benchIndex       工作台位置下标
     * @param laneIndex        泳道位置下标
     * @param jobIndex         作业组件位置下标
     * @param laneNameIdMap    泳道信息map
     * @param benchTempIdMap   工作台信息和模版信息关系map
     */
    public void initJobBench(TemplateBenchImportVo jobBenchImportVo, Map<String, TemplateSystemCustom> systemCustomTempMap,
                             Map<String, Long> benchNameIdMap, int benchIndex, int laneIndex, int jobIndex,
                             Map<String, Long> laneNameIdMap,Map<Long, Long> benchTempIdMap) {
        //先从map中获取工作台信息
        Long benchId = benchNameIdMap.get(jobBenchImportVo.getBenchName());
        //该工作台为空，则初始化工作台信息
        if (null == benchId) {
            //保存工作台模版
            TemplateBenchVO req=new TemplateBenchVO();
            req.setTemplateName(jobBenchImportVo.getBenchName());
            req.setStatus(Constants.VALID_STATUS_UNUSABLE);
            TemplateInfo templateInfo = packageTemplateInfo(req);
            Long tempId = templateInfoService.saveTemp(templateInfo);
            //保存工作台数据
            TemplateBench templateBench = new TemplateBench();
            templateBench.setTemplateId(tempId);
            templateBench.setName(jobBenchImportVo.getBenchName());
            templateBench.setLabelIndex(benchIndex);
            templateBench.setParentId(0L);
            templateBench.setCreateUserId(Utils.getUserId());
            templateBench.setCreateTime(DateUtils.getNowTime(""));
            templateBench.setModifyTime(DateUtils.getNowTime(""));
            templateBench.setModifyUserId(Utils.getUserId());
            templateBench.setTenantId(Utils.getTenantId());
            templateBenchMapper.insert(templateBench);
            benchNameIdMap.put(jobBenchImportVo.getBenchName(), templateBench.getId());
            benchId = templateBench.getId();
            benchIndex = benchIndex + 1;
            benchTempIdMap.put(benchId,tempId);
        }
        //新增泳道信息
        //先从map中获取泳道信息
        String laneKey = jobBenchImportVo.getBenchName() + jobBenchImportVo.getLaneName();
        Long laneId = laneNameIdMap.get(laneKey);
        //该泳道为空，则初始化泳道信息
        if (null == laneId) {
            TemplateBench lane = new TemplateBench();
            Long tempId =benchTempIdMap.get(benchId);
            lane.setTemplateId(tempId);
            lane.setName(jobBenchImportVo.getLaneName());
            lane.setLabelIndex(laneIndex);
            lane.setParentId(benchId);
            lane.setCreateUserId(Utils.getUserId());
            lane.setCreateTime(DateUtils.getNowTime(""));
            lane.setModifyTime(DateUtils.getNowTime(""));
            lane.setModifyUserId(Utils.getUserId());
            lane.setTenantId(Utils.getTenantId());
            templateBenchMapper.insert(lane);
            laneNameIdMap.put(laneKey, lane.getId());
            laneId = lane.getId();
            laneIndex = laneIndex + 1;
        }
        //新增泳道和作业的关系
        TemplateBenchCustom templateBenchCustom = new TemplateBenchCustom();
        templateBenchCustom.setBenchId(laneId);
        templateBenchCustom.setCreateUserId(Utils.getUserId());
        templateBenchCustom.setCreateTime(DateUtils.getNowTime(""));
        templateBenchCustom.setTenantId(Utils.getTenantId());
        templateBenchCustom.setLabelIndex(jobIndex);
        TemplateSystemCustom systemCustomTemp = systemCustomTempMap.get(jobBenchImportVo.getJobName());
        if (null != systemCustomTemp) {
            templateBenchCustom.setSystemId(systemCustomTemp.getId());
            templateBenchCustomMapper.insert(templateBenchCustom);
            jobIndex = jobIndex + 1;
        }

    }


    /**
     * 校验excel数据
     *
     * @param jobBenchImportVo excel中的数据
     * @param benchNameList    数据库中的工作台名称
     * @param systemCustomTempMap  自定义组件map,key:名称,val:自定义组件
     * @param jobNameMap       工作台泳道信息
     * @return
     */
    private StringBuilder validateData(TemplateBenchImportVo jobBenchImportVo, List<String> benchNameList, Map<String, TemplateSystemCustom> systemCustomTempMap, Map<String, List<String>> jobNameMap) {
        StringBuilder errorSb = new StringBuilder();
        //工作台名称校验
        if (StringUtils.isEmpty(jobBenchImportVo.getBenchName())) {
            errorSb.append("“工作台名称”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(jobBenchImportVo.getBenchName()) && jobBenchImportVo.getBenchName().length() > 12) {
            errorSb.append("“工作台名称”内容超过最大长度限制").append(",");
        }
        if (benchNameList.contains(jobBenchImportVo.getBenchName())) {
            errorSb.append("“工作台名称”重名").append(",");
        }
        //泳道名称校验
        if (StringUtils.isEmpty(jobBenchImportVo.getLaneName())) {
            errorSb.append("“泳道名称”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(jobBenchImportVo.getLaneName()) && jobBenchImportVo.getLaneName().length() > 12) {
            errorSb.append("“泳道名称”内容超过最大长度限制").append(",");
        }
        if (StringUtils.isNotEmpty(jobBenchImportVo.getBenchName()) && StringUtils.isNotEmpty(jobBenchImportVo.getLaneName())) {
            //校验作业是否重名
            List<String> jobNameList = jobNameMap.get(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName());
            if (CollectionUtils.isEmpty(jobNameList)) {
                jobNameList = new ArrayList<>();
            }
            //作业名称重名
            if (StringUtils.isNotEmpty(jobBenchImportVo.getJobName()) &&
                    jobNameList.contains(jobBenchImportVo.getJobName())) {
                errorSb.append("“作业名称”重名").append(",");
            }
        }
        //作业校验
        if (StringUtils.isEmpty(jobBenchImportVo.getJobName())) {
            errorSb.append("“作业名称”未填写").append(",");
        }
        //作业不存在
        if (StringUtils.isNotEmpty(jobBenchImportVo.getJobName()) &&
                null == systemCustomTempMap.get(jobBenchImportVo.getJobName())) {
            errorSb.append("“作业名称”值错误").append(",");
        }
        //作业未启用
        if (StringUtils.isNotEmpty(jobBenchImportVo.getJobName()) &&
                null != systemCustomTempMap.get(jobBenchImportVo.getJobName())) {
            TemplateSystemCustom systemCustomTemp = systemCustomTempMap.get(jobBenchImportVo.getJobName());
            //没有开启
            if (systemCustomTemp.getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
                errorSb.append("关联作业未启用").append(",");
            }
            //分类不是作业和应用
            if (!systemCustomTemp.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())
                    && !systemCustomTemp.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())
            ) {
                errorSb.append("“作业名称”值错误").append(",");
            }
        }
        return errorSb;
    }



    @Override
    public PageInfoResp<TemplateBenchImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper<TemplateBenchImport> condition = new QueryWrapper<>();
        if (StringUtils.isBlank(queryImportRecordReq.getStartTime()) || StringUtils.isBlank(queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER);
            condition.ge("create_time", DateUtils.addDate(currentDate, DateUtils.DATE_TIME_NORMAL_FORMATTER, -1, DateUtils.YEAR));
            condition.le("create_time", currentDate);
        } else {
            condition.ge("create_time", queryImportRecordReq.getStartTime());
            condition.le("create_time", queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty(queryImportRecordReq.getUserIdName())) {
            condition.and(i -> i.like("create_user_name", queryImportRecordReq.getUserIdName()).or().like("create_user_id", queryImportRecordReq.getUserIdName()));
        }
        condition.orderByDesc("create_time");
        PageInfoResp<TemplateBenchImport> pageInfoResp = new PageInfoResp<>();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);
        Page<TemplateBenchImport> pageResult = templateBenchImportMapper.selectPage(new Page<>(queryImportRecordReq.getPageNum(), queryImportRecordReq.getPageSize()), condition);
        if (pageResult!=null && CollectionUtils.isNotEmpty(pageResult.getRecords())) {
            // 拼接文件预览链接
            pageResult.getRecords().forEach(m-> m.setFileUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + m.getFileId().trim()));
            pageInfoResp.setList(pageResult.getRecords());
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        }
        else {
            pageInfoResp.setList(Lists.newArrayList());
        }
        return pageInfoResp;
    }

    @Override
    public List<TemplateBenchExportVo> exportReport() {
        List<TemplateBenchExportVo> jobBenchExportVoList = new ArrayList<>();
        //自定义组件map,key:名称,val:自定义组件
        Map<Long, TemplateSystemCustom> systemCustomTempMap = new HashMap<>();
        //查询自定义组件-作业 和自定义组件-应用 分类的自定义组件
        LabelSystemAllVo req = new LabelSystemAllVo();
        List<Integer> dataCategoryList = new ArrayList<>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List<TemplateSystemCustom> systemCustomTempList = templateSystemCustomService.queryCustomList(req);
        if (CollectionUtils.isNotEmpty(systemCustomTempList)) {
            systemCustomTempMap = systemCustomTempList.stream().collect(Collectors.toMap(TemplateSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        //查询工作台信息
        TemplateBench reqBench = new TemplateBench();
        //查询所有一级工作台
        reqBench.setParentId(0L);
        List<TemplateBench> jobBenchList = selectByBench(reqBench);
        for (TemplateBench jobBench : jobBenchList) {
            //查询泳道信息
            TemplateBench reqLane = new TemplateBench();
            //查询下级信息
            reqLane.setParentId(jobBench.getId());
            List<TemplateBench> laneList = selectByBench(reqLane);
            if (CollectionUtils.isEmpty(laneList)) {
                //组装空的工作台
                jobBenchExportVoList.add(initJobBench(jobBench.getName(), ""));
                continue;
            }
            List<Long> laneIdList = laneList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            List<TemplateBenchCustom> jobBenchCustomList = templateBenchCustomMapper.selectBenchBy(laneIdList,null);
            Map<Long, List<TemplateBenchCustom>> laneSystemMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(jobBenchCustomList)) {
                laneSystemMap = jobBenchCustomList.stream().collect(Collectors.groupingBy(TemplateBenchCustom::getBenchId));
            }
            for (TemplateBench lane : laneList) {
                TemplateBenchExportVo jobBenchExportVo = new TemplateBenchExportVo();
                jobBenchExportVo.setBenchName(jobBench.getName());
                jobBenchExportVo.setLaneName(lane.getName());
                List<TemplateBenchCustom> benchCustomList = laneSystemMap.get(lane.getId());
                //组装空的泳道
                if (CollectionUtils.isEmpty(benchCustomList)) {
                    jobBenchExportVoList.add(jobBenchExportVo);
                    continue;
                }
                for (TemplateBenchCustom benchCustom : benchCustomList) {
                    TemplateBenchExportVo jobExportVo = new TemplateBenchExportVo();
                    jobExportVo.setBenchName(jobBench.getName());
                    jobExportVo.setLaneName(lane.getName());
                    TemplateSystemCustom systemCustomTemp = systemCustomTempMap.get(benchCustom.getSystemId());
                    //组装泳道下的作业
                    if (null != systemCustomTemp) {
                        jobExportVo.setJobName(systemCustomTemp.getNameZh());
                        jobBenchExportVoList.add(jobExportVo);
                    }
                }

            }
        }
        return jobBenchExportVoList;
    }


    /**
     * 模版中工作台条件查询
     * @param req
     * @return
     */
    public List<TemplateBench> selectByBench(TemplateBench req) {
        QueryWrapper queryWrapper = new QueryWrapper<JobBench>();
        queryWrapper.orderByAsc("label_index");
        //名称查询
        if (StringUtils.isNotEmpty(req.getName())) {
            queryWrapper.eq("name", req.getName());
        }
        if (null != req.getId()) {
            queryWrapper.notIn("id", req.getId());
        }
        if (null != req.getParentId()) {
            queryWrapper.eq("parent_id", req.getParentId());
        }
        return templateBenchMapper.selectList(queryWrapper);
    }


    /**
     * 初始化导出的工作台信息
     *
     * @param benchName
     * @param laneName
     * @return
     */
    public TemplateBenchExportVo initJobBench(String benchName, String laneName) {
        TemplateBenchExportVo jobBenchExportVo = new TemplateBenchExportVo();
        if (StringUtils.isNotEmpty(benchName)) {
            jobBenchExportVo.setBenchName(benchName);
        }
        if (StringUtils.isNotEmpty(laneName)) {
            jobBenchExportVo.setLaneName(laneName);
        }
        return jobBenchExportVo;
    }
}