package com.digiwin.athena.semc.service.temp.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.dto.portal.UsePortalDetailDto;
import com.digiwin.athena.semc.dto.portal.UsePortalInfoDto;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.bench.JobBench;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateBenchCustom;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.entity.temp.TemplateInfoTenant;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfo;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;
import com.digiwin.athena.semc.entity.temp.TemplateUserTenant;
import com.digiwin.athena.semc.mapper.bench.JobBenchCustomMapper;
import com.digiwin.athena.semc.mapper.bench.JobBenchMapper;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemDataMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemSourceMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupItemMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateUserTenantMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.LabelSystemDataAppVo;
import com.digiwin.athena.semc.vo.portal.QueryTempAppListVo;
import com.digiwin.athena.semc.vo.temp.TemplateTenantGroupVO;
import com.digiwin.athena.semc.vo.temp.TemplateTenantVO;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import io.github.linpeilie.Converter;

@Service
public class TemplateInfoServiceImpl extends ServiceImpl<TemplateInfoMapper, TemplateInfo> implements TemplateInfoService {

    @Resource
    TemplateInfoMapper templateInfoMapper;

    @Resource
    TemplateInfoTenantMapper templateInfoTenantMapper;

    @Resource
    TemplateTenantGroupMapper templateTenantGroupMapper;

    @Resource
    private TemplateTenantGroupItemMapper templateTenantGroupItemMapper;

    @Autowired
    JobBenchMapper jobBenchMapper;

    @Autowired
    JobBenchCustomMapper jobBenchCustomMapper;

    @Autowired
    LabelSystemSourceMapper labelSystemSourceMapper;

    @Resource
    TemplateSystemSourceMapper templateSystemSourceMapper;

    @Autowired
    LabelSystemDataMapper labelSystemDataMapper;

    @Autowired
    TemplateSystemDataMapper templateStystemDataMapper;

    @Autowired
    LabelSystemDataService labelSystemDataService;

    @Resource
    private IamService iamService;

    @Resource
    private MessageUtils messageUtils;

    @Resource
    LabelSystemPreService labelSystemPreService;

    @Autowired
    LabelSystemCustomMapper labelSystemCustomMapper;

    @Resource
    TemplateSystemCustomMapper templateSystemCustomMapper;

    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;

    @Resource
    TemplatePortalInfoMapper templatePortalInfoMapper;

    @Resource
    TemplatePortalInfoContentMapper templatePortalInfoContentMapper;

    @Autowired
    TemplateBenchMapper templateBenchMapper;

    @Autowired
    TemplateBenchCustomMapper templateBenchCustomMapper;

    @Resource
    TemplateUserTenantMapper templateUserTenantMapper;

    @Resource
    private Converter converter;

    @Override
    public ResultPageBean pageQuery(TemplateQueryReq req) {
        //获取ISV配置信息
        List<TemplateInfo> templateInfoList = templateInfoMapper.queryByTemp(req,null);
        Integer totalResults=templateInfoList.size();
        templateInfoList=templateInfoList.stream()
                .skip((req.getPageNum() - 1) * req.getPageSize().longValue())
                .limit(req.getPageSize()).collect(Collectors.toList());
        //组装模版的部分租户中的分组和租户
        packageTempTenant(templateInfoList);
        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(templateInfoList, PageInfo.getPageInfo(
                req.getPageNum(), req.getPageSize(), totalResults)));
        return resultPageBean;
    }


    /**
     * 组装模版的部分租户中的分组和租户
     * @param templateInfoList
     */
    public void packageTempTenant(List<TemplateInfo> templateInfoList) {
        if (CollectionUtils.isEmpty(templateInfoList)) {
            return;
        }
        //过滤订阅的类型，得到订阅的类型为部分租户的场景
        List<TemplateInfo> partTempList = templateInfoList.stream().filter(x -> Constants.SubTypeEnum.PART_TENANT.getFlag().equals(x.getSubType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(partTempList)) {
            return;
        }
        List<Long> tempIdList = partTempList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
        //如果是部分租户则需要查询分组和租户信息
        List<TemplateInfoTenant> tenantGroupList = templateInfoTenantMapper.selectByTemp(tempIdList);
        //部分租户信息Map,key:模版id，val：分组和租户信息
        Map<Long, List<TemplateInfoTenant>> tenantGroupTempMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(tenantGroupList)) {
            tenantGroupTempMap = tenantGroupList.stream().collect(Collectors.groupingBy(TemplateInfoTenant::getTemplateId));
        }
        //得到按分组的租户
        List<TemplateInfoTenant> groupAllList = tenantGroupList.stream().filter(x -> Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag().equals(x.getSelectType())).collect(Collectors.toList());
        //分组信息集合
        List<TemplateTenantGroupVO> tenantGroupVOList = new ArrayList<>();
        //分组信息Map
        Map<Long, TemplateTenantGroupVO> tenantGroupVOMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(groupAllList)) {
            List<String> groupIdList = groupAllList.stream().map(TemplateInfoTenant::getGroupTenantId).collect(Collectors.toList());
            tenantGroupVOList = templateTenantGroupMapper.selectByIds(groupIdList);

        }
        if (CollectionUtils.isNotEmpty(tenantGroupVOList)) {
            tenantGroupVOMap = tenantGroupVOList.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        }
        for (TemplateInfo templateInfo : templateInfoList) {
            //不是部分租户方式，跳过
            if (null ==templateInfo.getSubType() ||
                    !templateInfo.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
                continue;
            }
            //部分租户方式，取出模版中部分租户的数据（包括分组和租户）
            List<TemplateInfoTenant> infoTenantList = tenantGroupTempMap.get(templateInfo.getId());
            //租户集合
            List<TemplateTenantVO> tenantList = new ArrayList<>();
            //按分组
            List<TemplateTenantGroupVO> groupList = new ArrayList<>();
            if(CollectionUtils.isEmpty(infoTenantList)){
                continue;
            }
            for (TemplateInfoTenant tenant : infoTenantList) {
                //按租户
                if (tenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag())) {
                    TemplateTenantVO tenantVO = new TemplateTenantVO();
                    tenantVO.setSubTenantId(tenant.getGroupTenantId());
                    tenantVO.setSubTenantName(tenant.getSubTenantName());
                    tenantList.add(tenantVO);
                }
                //按分组
                if (tenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag())
                        && null !=tenantGroupVOMap.get(Long.parseLong(tenant.getGroupTenantId()))) {
                    groupList.add(tenantGroupVOMap.get(Long.parseLong(tenant.getGroupTenantId())));
                }
            }
            templateInfo.setSubTenantList(tenantList);
            templateInfo.setGroupList(groupList);
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveTemp(TemplateInfo req) {
        Long id = req.getId();
        req.setModifyTime(DateUtils.getNowTime(""));
        req.setModifyUserId(Utils.getUserId());
        req.setModifyUserName(Utils.getUserName());
        //默认给待布局
        if (null == req.getStatus()) {
            req.setStatus(Constants.TemplateStatusEnum.NO_RELEASE.getVal());
        }
        if (null == req.getId()) {
            //获取模版编号+1
           // req.setTemplateNo(getTemplateNo(req.getTemplateType()));
            req.setTenantId(Utils.getTenantId());
            req.setTemplateSort(3);
            req.setCreateTime(DateUtils.getNowTime(""));
            req.setCreateUserName(Utils.getUserName());
            req.setCreateUserId(Utils.getUserId());
            templateInfoMapper.insert(req);
            id = req.getId();
        } else {
            templateInfoMapper.upTempById(req);
        }
        return id;
    }


    @Override
    public List<TemplateInfo> queryByParam(TemplateInfo req) {
        QueryWrapper<TemplateInfo> condition = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(req.getTemplateNo())) {
            condition.eq("template_no", req.getTemplateNo());
        }
        if (StringUtils.isNotEmpty(req.getTemplateName())) {
            condition.eq("template_name", req.getTemplateName());
        }
        if (null != req.getTemplateType()) {
            condition.eq("template_type",req.getTemplateType());
        }
        if (null != req.getId()) {
            condition.ne("id", req.getId());
        }
        return templateInfoMapper.selectList(condition);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> batDel(List<Long> idList) {
        List<TemplateInfo> templateInfoList = templateInfoMapper.selectBatchIds(idList);
        //过滤得到布局类型的模版id
        List<TemplateInfo> portTempList = templateInfoList.stream().filter(x -> Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal().equals(x.getTemplateType())).collect(Collectors.toList());
        List<Long> portTempIdList = portTempList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(portTempIdList)) {
            //删除布局内容
            List<Long> portIds = templatePortalInfoMapper.selByTemp(portTempIdList);
            if (CollectionUtils.isNotEmpty(portIds)) {
                //删除布局
                templatePortalInfoMapper.delByTemp(portIds);
                //删除布局内容
                delPortalContent(portIds);
            }
        }
        //过滤得到作业工作台的模版
        List<TemplateInfo> benchTempList = templateInfoList.stream().filter(x -> Constants.TemplateTypeEnum.JOB_BENCH.getVal().equals(x.getTemplateType())).collect(Collectors.toList());
        List<Long> benchTempIdList = benchTempList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(benchTempIdList)) {
            List<TemplateBench> jobBenchList = templateBenchMapper.selectTempBench(benchTempIdList,null);
            List<Long> jobBenchIdList = jobBenchList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            //删除泳道、工作台
            if (CollectionUtils.isNotEmpty(jobBenchIdList)) {
                templateBenchMapper.deleteBatchIds(jobBenchIdList);
                //删除作业
                templateBenchCustomMapper.delBenchJob(jobBenchIdList);
            }
        }
        templateInfoMapper.deleteBatchIds(idList);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 删除布局内容
     */
    public void delPortalContent(List<Long> portalIdList) {
        QueryWrapper<TemplatePortalInfoContent> condition = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in("portal_id", portalIdList);
        }
        templatePortalInfoContentMapper.delete(condition);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> updateStatus(List<Long> idList, Integer status) {
        List<TemplateInfo> templateInfoList = templateInfoMapper.selectBatchIds(idList);
        if(CollectionUtils.isEmpty(templateInfoList)){
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "模版数据不存在");
        }
        //批量发布
        if(status.equals(Constants.VALID_STATUS_ENABLE)) {
            List<TemplateInfo> validTempList = templateInfoList.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getStatus())).collect(Collectors.toList());
            //全部都是已发布
            if (CollectionUtils.isNotEmpty(templateInfoList) && validTempList.size() == idList.size()) {
                String error = messageUtils.getMessage("error.message.template.updateStatus.published.msg");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
            }
        }
        //批量取消发布
        if(status.equals(Constants.VALID_STATUS_UNUSABLE)) {
            List<TemplateInfo> nnUSABLETempList = templateInfoList.stream().filter(x -> Constants.VALID_STATUS_UNUSABLE.equals(x.getStatus())).collect(Collectors.toList());
            //全部都是未发布
            if (CollectionUtils.isNotEmpty(nnUSABLETempList) && nnUSABLETempList.size() == idList.size()) {
                String error = messageUtils.getMessage("error.message.template.updateStatus.no.published.msg");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);

            }
        }
        //过滤得到布局类型的模版id
        List<TemplateInfo> portTempList = templateInfoList.stream().filter(x -> Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal().equals(x.getTemplateType())).collect(Collectors.toList());
        List<Long> portTempIdList = portTempList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
        //更新布局的状态
        if (CollectionUtils.isNotEmpty(portTempIdList)) {
            TemplatePortalInfo templatePortalInfo=new TemplatePortalInfo();
            templatePortalInfo.setStatus(status);
            templatePortalInfo.setModifyUserName(Utils.getUserName());
            templatePortalInfo.setModifyTime(DateUtils.getNowTime(""));
            templatePortalInfo.setModifyUserId(Utils.getUserId());
            templatePortalInfoMapper.updateByTemp(portTempIdList, templatePortalInfo);
        }
        TemplateInfo templateInfo=new TemplateInfo();
        templateInfo.setStatus(status);
        templateInfo.setModifyUserName(Utils.getUserName());
        templateInfo.setModifyTime(DateUtils.getNowTime(""));
        templateInfo.setModifyUserId(Utils.getUserId());
        templateInfoMapper.updateBat(idList, templateInfo);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Integer batTempToTenant(TemplateInfo req) {
        //批量更新模版
        TemplateInfo templateInfo=new TemplateInfo();
        templateInfo.setSubType(req.getSubType());
        templateInfo.setModifyUserName(Utils.getUserName());
        templateInfo.setModifyTime(DateUtils.getNowTime(""));
        templateInfo.setModifyUserId(Utils.getUserId());
        templateInfoMapper.updateBat(req.getIdList(), templateInfo);
        //删除模版租户
        templateInfoTenantMapper.delByTemp(req.getIdList());
        //保存模版中的部分租户
        for(Long tempId:req.getIdList()){
            List<TemplateInfoTenant> tenantGroupList=addTempTeanntList(req,tempId);
            if(CollectionUtils.isNotEmpty(tenantGroupList)){
                templateInfoTenantMapper.batchInsertTenant(tenantGroupList,Utils.getUserId(),DateUtils.getNowTime(""));
            }
        }
        return null;
    }

    /**
     * 组装待入库的模版中租户分组或者租户集合
     * @param req
     * @param tempId
     * @return
     */
    @Override
    public List<TemplateInfoTenant> addTempTeanntList(TemplateInfo req,Long tempId){
        List<TemplateInfoTenant> tenantGroupList=new ArrayList<>();
        //组装按租户的数据
        if(CollectionUtils.isNotEmpty(req.getSubTenantList())){
            for(TemplateTenantVO tenantVO:req.getSubTenantList()) {
                TemplateInfoTenant infoTenant = packageTemplateTenant(Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag(), tempId, tenantVO.getSubTenantId());
                infoTenant.setSubTenantName(tenantVO.getSubTenantName());
                tenantGroupList.add(infoTenant);
            }
        }
        //组装按分组的数据
        if(CollectionUtils.isNotEmpty(req.getGroupList())) {
            for (TemplateTenantGroupVO groupVO : req.getGroupList()) {
                TemplateInfoTenant infoTenant = packageTemplateTenant(Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag(), tempId, groupVO.getId() + "");
                tenantGroupList.add(infoTenant);
            }
        }
        return  tenantGroupList;
    }

    /**
     * 组装模版部分租户信息
     * @param selectType 部门租户选择类型（0：按租户、1：按分组）
     * @param tempId 模版ID
     * @param groupTenantId 订阅的租户id/分组ID
     * @return
     */
    public TemplateInfoTenant packageTemplateTenant(Integer selectType,Long tempId,String groupTenantId) {
        TemplateInfoTenant infoTenant = new TemplateInfoTenant();
        infoTenant.setTemplateId(tempId);
        infoTenant.setSelectType(selectType);
        infoTenant.setSubUserId(Utils.getUserId());
        infoTenant.setGroupTenantId(groupTenantId);
        infoTenant.setTenantId(Utils.getTenantId());
        infoTenant.setCreateUserId(Utils.getUserId());
        infoTenant.setCreateTime(DateUtils.getNowTime(""));
        return infoTenant;
    }


    /**
     * 获取模版中门户或者作业工作台中涉及的组件和数据源的关系
     *
     * @param portId        门户ID
     * @param serviceSource 0：经典门户、1：作业工作台。默认0
     * @param templateIds 用户选择需要同步的工作台模版ID
     * @return
     */
    public List<TemplateSystemSource> getSystemSource(Long portId, int serviceSource,List<Long> templateIds) {
        List<TemplateSystemSource> systemSourceList = new ArrayList<>();
        // 0：经典门户、1：作业工作台。默认0
        if (serviceSource == 0) {
            //查询门户配置的组件
            List<Integer> contentTypeList = new ArrayList<>();
            //查询预设组件和自定义组件
            contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
            contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
            List<TemplatePortalInfoContent> portalInfoContentList = templatePortalInfoContentMapper.queryPortalCont(portId, contentTypeList);
            //查询预设组件和自定义组件关联的数据源
            systemSourceList = getSysTemSourceTemp(portalInfoContentList);
        }
        //作业工作台查询涉及的IVS模版中涉及的组件
        if (serviceSource == 1) {
            //查询模版中工作台数据
            List<TemplateBench> benchTempList = templateBenchMapper.selectTempBench(templateIds,0L);
            //都没有配置工作台
            if (CollectionUtils.isEmpty(benchTempList)) {
                return systemSourceList;
            }
            List<Long> benchIdList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            //获取作业工作台模版中泳道数据
            List<TemplateBench> jobBenchTempList = templateBenchMapper.selectBenchByTemp(benchIdList,null);
            jobBenchTempList.addAll(benchTempList);
            //都没有配置工作台
            if (CollectionUtils.isEmpty(jobBenchTempList)) {
                //跳转到作业工作台
                return systemSourceList;
            }
            List<Long> jobIdTempList = jobBenchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            //查询模版工作台涉及的组件信息
            List<TemplateBenchCustom> jobBenchCustomList = templateBenchCustomMapper.selectBenchBy(jobIdTempList,null);
            if(CollectionUtils.isEmpty(jobBenchCustomList)){
                return systemSourceList;
            }
            List<Long> systemIdList = jobBenchCustomList.stream().map(TemplateBenchCustom::getSystemId).collect(Collectors.toList());
            //查询自定义组件关联的数据源
            systemSourceList = templateSystemSourceMapper.selBySystemIds(systemIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        }
        return systemSourceList;
    }

    /**
     * 将模版中数据源转换成租户数据的实体
     * @param templateSystemDataList
     * @return
     */
    public List<LabelSystemData> tempToTenData(List<TemplateSystemData> templateSystemDataList) {
        List<LabelSystemData> systemDataList = new ArrayList<>();
        if (CollectionUtils.isEmpty(templateSystemDataList)) {
            return systemDataList;
        }
        for (TemplateSystemData templateSystemData : templateSystemDataList) {
            LabelSystemData systemData = converter.convert(templateSystemData, LabelSystemData.class);
            systemDataList.add(systemData);
        }
        return systemDataList;
    }


    @Override
    public List<QueryTempAppListVo> queryTempAppList(TemplateInfo req) {
        List<QueryTempAppListVo> appLinkDTOList = new ArrayList<>();
        List<Long> dataIdList = new ArrayList<>();
        //查询预设组件和自定义组件关联的数据源
        List<TemplateSystemSource> systemSourceList = getSystemSource(req.getId(), req.getServiceSource(),req.getBenchIdList());
        if (CollectionUtils.isEmpty(systemSourceList)) {
            return appLinkDTOList;
        }
        dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        //判断组件ID是否为空
        if (CollectionUtils.isEmpty(dataIdList)) {
            return appLinkDTOList;
        }
        //查询数据源信息
        List<TemplateSystemData> systemDataTempList = templateStystemDataMapper.selByIds(dataIdList);
        if (CollectionUtils.isEmpty(systemDataTempList)) {
            return appLinkDTOList;
        }
        //将模版中数据源转换成租户数据的实体
        List<LabelSystemData> systemDataList =tempToTenData(systemDataTempList);
        //根据源应用来源（ 0：CS、1：BS、2：平台预设、3：雅典娜应用）拆分数据
        LabelSystemDataAppVo systemDataAppVo = labelSystemDataService.getSsoAppMap(systemDataList);
        //组装CS数据
        for (Map.Entry<Long, ErpSsoInfo> erpEntry : systemDataAppVo.getErpInfoMap().entrySet()) {
            ErpSsoInfo erpSsoInfo = erpEntry.getValue();
            QueryTempAppListVo linkDTO = new QueryTempAppListVo();
            linkDTO.setPrimaryId(erpSsoInfo.getId() + "");
            linkDTO.setName(erpSsoInfo.getName());
            linkDTO.setSystemIdList(systemDataAppVo.getErpSystemId());
            linkDTO.setCode(erpSsoInfo.getCode());
            linkDTO.setDataSource(ApplicationTypeEnum.CS_APPLICATION.getType());
            appLinkDTOList.add(linkDTO);
        }
        //组装BS数据
        for (Map.Entry<Long, ThirdSsoInfo> thirdEntry : systemDataAppVo.getThirdSsoInfoMap().entrySet()) {
            ThirdSsoInfo thirdSsoInfo = thirdEntry.getValue();
            QueryTempAppListVo linkDTO = new QueryTempAppListVo();
            linkDTO.setPrimaryId(thirdSsoInfo.getId() + "");
            linkDTO.setName(thirdSsoInfo.getAppName());
            linkDTO.setCode(thirdSsoInfo.getAppCode());
            linkDTO.setSystemIdList(systemDataAppVo.getBsSystemId());
            linkDTO.setDataSource(ApplicationTypeEnum.BS_APPLICATION.getType());
            appLinkDTOList.add(linkDTO);
        }
        //组装预设组件数据
        List<TemplateSystemData> preDataList = systemDataTempList.stream().filter(item -> ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        List<Long> preSystemIdList = preDataList.stream().map(TemplateSystemData::getId).collect(Collectors.toList());
        List<String> appCodeList=new ArrayList<>();
        for (TemplateSystemData preData : preDataList) {
            if (null == systemDataAppVo.getPreInfoMap()) {
                continue;
            }
            PreinstalledApplication preinsApp = systemDataAppVo.getPreInfoMap().get(Long.parseLong(preData.getAppCode()));
            if (null == preinsApp) {
                continue;
            }
            //已经加过的，过滤掉
            if(appCodeList.contains(preData.getAppCode())){
                continue;
            }
            appCodeList.add(preData.getAppCode());
            QueryTempAppListVo linkDTO = new QueryTempAppListVo();
            linkDTO.setPrimaryId(preData.getAppCode());
            linkDTO.setName(preinsApp.getApplicationName());
            linkDTO.setCode(preinsApp.getApplicationCode());
            linkDTO.setSystemIdList(preSystemIdList);
            linkDTO.setDataSource(ApplicationTypeEnum.PRESET_APPLICATION.getType());
            appLinkDTOList.add(linkDTO);
        }
        return appLinkDTOList;
    }


    /**
     * 校验模版中的数据源
     *
     * @param returnPort     返回实体
     * @param systemDataList 模版中涉及组件对应数据源
     * @return
     */
    public ResponseEntity<?> checkUserSystem(PortalInfo returnPort, List<TemplateSystemData> systemDataList) {
        //包含IAM应用 的数据源
        List<TemplateSystemData> iamDataList = systemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        //包含IAM应用的数据源为空，说明源应用都是SSO配置中的，需要弹出第二个弹框关联原应用
        if (CollectionUtils.isEmpty(iamDataList) && CollectionUtils.isNotEmpty(systemDataList)) {
            //跳转到关联源应用页面
            returnPort.setJumpToPage(Constants.JumpToPageEnum.CORRELATION_APP_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //获取该租户下应用清单
        List<TenantAppDTO> allTenantApps = iamService.queryTenantApps();
        //返回的租户下IAM应用没有任何有权限
        if (CollectionUtils.isEmpty(allTenantApps)) {
            //跳转到租户端无权限弹框
            returnPort.setJumpToPage(Constants.JumpToPageEnum.NO_PERMISSION_PAGE.getVal());
            String error = messageUtils.getMessage("error.message.portal.app.power.error");
            returnPort.setPromptMsg(error);
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        Map<String, TenantAppDTO> iamInfoMap = allTenantApps.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        for (TemplateSystemData iamData : iamDataList) {
            TenantAppDTO tenantAppDTO = iamInfoMap.get(iamData.getAppCode());
            //返回的IAM应用中没有该数据源中配置的源应用
            if (null == tenantAppDTO) {
                returnPort.setJumpToPage(Constants.JumpToPageEnum.NO_PERMISSION_PAGE.getVal());
                String error = messageUtils.getMessage("error.message.portal.app.power.error");
                returnPort.setPromptMsg(error);
                return ResponseEntityWrapper.wrapperOk(returnPort);
            }
            //返回的IAM应用中应用已过期
            String expiredTime = tenantAppDTO.getExpiredTime();
            if (LocalDateTime.parse(expiredTime, DateTimeFormatter.ofPattern(DateUtils.DATE_TIME_NORMAL_FORMATTER)).compareTo(LocalDateTime.now()) < 0) {
                returnPort.setJumpToPage(Constants.JumpToPageEnum.NO_PERMISSION_PAGE.getVal());
                String error = messageUtils.getMessage("error.message.portal.app.power.error");
                returnPort.setPromptMsg(error);
                return ResponseEntityWrapper.wrapperOk(returnPort);
            }
        }
        //包含非IAM应用 的数据源，且不是 业务代办-雅典娜智驱平台 和 鼎捷雅典娜APP
        List<TemplateSystemData> ssoDataList = systemDataList.stream().filter(item -> !ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType()) && !ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(item.getDataType()) ).collect(Collectors.toList());
        //包含非IAM应用 的数据源，需要弹出第二个弹框关联原应用
        if (CollectionUtils.isNotEmpty(ssoDataList)) {
            //跳转到关联源应用页面
            returnPort.setJumpToPage(Constants.JumpToPageEnum.CORRELATION_APP_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        return null;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> checkUserTemplate(Long portId) {
        TemplatePortalInfo portalInfo = templatePortalInfoMapper.getPortalById(portId);
        if (null == portalInfo) {
            String error = messageUtils.getMessage("error.message.portal.not.exist.error");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
        }
        //初始化租户布局
        PortalInfo returnPort = getInitPort(portalInfo, portalInfo.getId());
        //查询门户配置的组件
        List<Integer> contentTypeList = new ArrayList<>();
        //查询预设组件和自定义组件和容器
        contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
        contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        contentTypeList.add(Constants.PrtalContentTypeEnum.CONTAINER.getVal());
        //查询模版中涉及的预设组件、自定义组件、容器
        List<TemplatePortalInfoContent> portalContentTempList = templatePortalInfoContentMapper.queryPortalCont(portId, contentTypeList);
        //没有布局内容
        if (CollectionUtils.isEmpty(portalContentTempList)) {
            //跳转到布局设计器
            returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
            returnPort.setPortalContent("");
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //预设组件+ 自定义组件
        List<TemplatePortalInfoContent> preCustomContentList = portalContentTempList.stream().filter(item -> !Constants.PrtalContentTypeEnum.CONTAINER.getVal().equals(item.getContentType())).collect(Collectors.toList());
        //查询预设组件和自定义组件关联的数据源
        List<TemplateSystemSource> systemSourceList = getSysTemSourceTemp(preCustomContentList);
        //都没有配置数据源
        if (CollectionUtils.isEmpty(systemSourceList)) {
            //跳转到布局设计器
            returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
            //同步模版布局内容到租户门户内容里
            List<PortalInfoContent> tenPortalContent = getTenPortalContent(portalContentTempList);
            returnPort.setContentList(tenPortalContent);
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //获取数据源ID
        List<Long> dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        //查询数据源信息
        List<TemplateSystemData> systemDataList = templateStystemDataMapper.selByIds(dataIdList);
        //校验数据源中涉及的IAM应用权限
        ResponseEntity<?> checkResp = checkUserSystem(returnPort, systemDataList);
        if (null != checkResp) {
            return checkResp;
        }
        //数据源中包含的都是IAM应用且都都有授权，或者是业务代办-雅典娜智驱平台，则初始化这批数据源、组件
        List<PortalInfoContent> contentRespTenList = initIamSystemData(new ArrayList<Long>(), systemDataList, portalContentTempList);
        //跳转到布局设计器
        returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
        //同步模版布局内容到租户门户内容里
        returnPort.setContentList(contentRespTenList);
        return ResponseEntityWrapper.wrapperOk(returnPort);
    }

    /**
     *
     * @param preCustomContentList 模版中的布局内容
     * @return 返回模版中组件涉及的数据源关联关系
     */
    public List<TemplateSystemSource>  getSysTemSourceTemp(List<TemplatePortalInfoContent> preCustomContentList) {
        List<TemplateSystemSource> systemSourceTempList = new ArrayList<>();
        //模版中的预设组件
        List<TemplatePortalInfoContent> preContentTempList = preCustomContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preContentTempList)) {
            List<Long> contentIdPreList = preContentTempList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
            //查询预设组件和自定义组件关联的数据源
            List<TemplateSystemSource> systemSourcePreList = templateSystemSourceMapper.selBySystemIds(contentIdPreList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
            if (CollectionUtils.isNotEmpty(systemSourcePreList)) {
                systemSourceTempList.addAll(systemSourcePreList);
            }
        }
        //模版中的自定义组件
        List<TemplatePortalInfoContent> cusContentTempList = preCustomContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(cusContentTempList)) {
            List<Long> contentIdCusList = cusContentTempList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
            //查询预设组件和自定义组件关联的数据源
            List<TemplateSystemSource> systemSourcCusList = templateSystemSourceMapper.selBySystemIds(contentIdCusList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
            if (CollectionUtils.isNotEmpty(systemSourcCusList)) {
                systemSourceTempList.addAll(systemSourcCusList);
            }
        }
        return systemSourceTempList;
    }

    /**
     * 获取复制的预设组件内容
     *
     * @param tempPortalContent 模版中的全部内容
     * @return
     */
    public List<PortalInfoContent> getTenPortalContent(List<TemplatePortalInfoContent> tempPortalContent) {
        List<PortalInfoContent> portalInfoContentList=new ArrayList<>();
        //过滤dataType不为空的数据
        List<TemplatePortalInfoContent> preContentList = tempPortalContent.stream().filter(item -> null != item.getDataType()).collect(Collectors.toList());
        List<Integer> dataTypeList = preContentList.stream().map(TemplatePortalInfoContent::getDataType).collect(Collectors.toList());
        //查询该租户下预设组件
        List<LabelSystemPre> preSystemList = labelSystemPreService.initDefPortal(dataTypeList, Constants.ClientTypeEnum.PC.getValue());
        Map<Integer, LabelSystemPre> preInfoMap = preSystemList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        for (TemplatePortalInfoContent contentInfo : tempPortalContent) {
            PortalInfoContent portalInfoContent=new PortalInfoContent();
            contentInfo.setId(null);
            contentInfo.setTenantId(Utils.getTenantId());
            contentInfo.setPortalId(null);
            if (null == contentInfo.getDataType()) {
                converter.convert(contentInfo, portalInfoContent);
                portalInfoContentList.add(portalInfoContent);
                continue;
            }
            LabelSystemPre systemPre = preInfoMap.get(contentInfo.getDataType());
            if (null != systemPre) {
                contentInfo.setContentId(systemPre.getId());
            }
            converter.convert(contentInfo, portalInfoContent);
            portalInfoContentList.add(portalInfoContent);
        }
        return portalInfoContentList;
    }


    /**
     * 初始化租户数据源
     * @param iamNoPermDataIdTemp 模版中没有授权的IAM应用的数据源ID
     * @param ssoRelation 模版中SSO和用户SSO的关联关系,key:模版中PrimaryId_dataSource,val：租户SSO的PrimaryId_dataSource
     * @param systemDataTempList 模版中涉及的数据源
     * @param dataIdTenList      租户的数据源ID，已存在的和新增的
     * @return 获取模版中数据源和租户的数据源关系
     */
    public Map<Long, Long> initSystemDataTen(List<Long> iamNoPermDataIdTemp,Map<String, String> ssoRelation,List<TemplateSystemData> systemDataTempList, List<Long> dataIdTenList) {
        //将模版中数据源转换成租户数据的实体
        List<LabelSystemData> systemDataList =tempToTenData(systemDataTempList);
        //获取模版中数据源中的源应用信息map
        LabelSystemDataAppVo labelSystemDataDto = labelSystemDataService.getSsoAppMapTemp(systemDataList);
        //模版中数据源和租户的数据源映射关系
        Map<Long, Long> systemRelation = new HashMap<>();
        for (TemplateSystemData systemData : systemDataTempList) {
            //模版中的包含IAM的数据源，且IAM没有授权，该数据源是没有授权的IAM源应用，则跳过
            if(iamNoPermDataIdTemp.contains(systemData.getId())){
                continue;
            }
            String ssoTempKey = systemData.getAppCode() + "_" + systemData.getDataType();
            //非IAM 应用 且 不是虚拟应用 说明模版中该数据源对应的SSO没有配置租户的SSO关联关系
            if (!systemData.getDataType().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())
                    && !systemData.getDataType().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())
                    && null != ssoRelation) {
                String ssoTenVal = ssoRelation.get(ssoTempKey);
                if (StringUtils.isEmpty(ssoTenVal)) {
                    continue;
                }
            }
            Map<Long, LabelSystemDataDto> systemAppNameMap = labelSystemDataDto.getSystemAppNameMap();
            LabelSystemDataDto systemDataDto = systemAppNameMap.get(systemData.getId());
            String appName = systemDataDto == null ? "" : systemDataDto.getAppName();
            LabelSystemData systemDataReq = new LabelSystemData();
            String name=systemData.getName();
            if(StringUtils.isNotEmpty(appName)){
                name=appName + "_" + systemData.getName();
            }
            systemDataReq.setName(name);
            //查询租户下是否存在模版中数据源名称为：应用名称+模版中数据源名称
            LabelSystemData systemDataTen = labelSystemDataMapper.getByInit(systemDataReq);
            //数据源已存在
            if (null != systemDataTen) {
                dataIdTenList.add(systemDataTen.getId());
                systemRelation.put(systemData.getId(), systemDataTen.getId());
            } else {
                converter.convert(systemData, systemDataReq);
                //按租户选择的SSO初始化租户的数据源
                if (null != ssoRelation && StringUtils.isNotEmpty(ssoRelation.get(ssoTempKey))) {
                    String ssoTenVal = ssoRelation.get(ssoTempKey);
                    systemDataReq.setAppCode(ssoTenVal.split("_")[0]);
                    systemDataReq.setDataType(Integer.parseInt(ssoTenVal.split("_")[1]));
                }
                //如果是统计组件或者业务代办，则不统计业务指标和统计值
                if(systemData.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_COUNT.getVal()) ||
                        systemData.getDataCategory().equals(Constants.DataCategoryEnum.BUSINESS_TODO.getVal())
                ){
                    systemDataReq.setRestUrl("");
                    systemDataReq.setMiddleSystemUid("");
                    systemDataReq.setMiddleSystemName("");
                    systemDataReq.setDataModel(null);
                    systemDataReq.setCountCode("");
                    systemDataReq.setCountContentCode("");
                }
                systemDataReq.setName(name);
                systemDataReq.setCreateUserName(Utils.getUserName());
                systemDataReq.setModifyUserName(Utils.getUserName());
                systemDataReq.setCreateUserId(Utils.getUserId());
                systemDataReq.setCreateTime(DateUtils.getNowTime(""));
                systemDataReq.setModifyTime(DateUtils.getNowTime(""));
                systemDataReq.setModifyUserId(Utils.getUserId());
                //获取作业同步中的作业地址
                getSsoJobUrl(systemData, systemDataReq, systemDataDto);
                systemDataReq.setTenantId(Utils.getTenantId());
                systemDataReq.setId(null);
                labelSystemDataMapper.insert(systemDataReq);
                dataIdTenList.add(systemDataReq.getId());
                systemRelation.put(systemData.getId(), systemDataReq.getId());
            }
        }
        return systemRelation;
    }
    /**
     * 初始化租户IAM应用对应的数据源、预设组件、自定义组件
     * @param iamNoPermDataIdTemp    模版中没有授权的IAM应用的数据源ID
     * @param systemDataTempList    模版中组件中的数据源ID
     * @param portalContentTempList 模版中的内容
     * @return
     */
    public List<PortalInfoContent> initIamSystemData(List<Long> iamNoPermDataIdTemp,List<TemplateSystemData> systemDataTempList, List<TemplatePortalInfoContent> portalContentTempList) {
        //获取模版中的数据源ID
        List<Long> dataIdTempList = systemDataTempList.stream().map(TemplateSystemData::getId).collect(Collectors.toList());
        //租户的数据源ID，已存在的和新增的
        List<Long> dataIdTenList = new ArrayList<>();
        //初始化租户数据源，获取模版中数据源和租户的数据源映射关系
        Map<Long, Long> systemRelation = initSystemDataTen(iamNoPermDataIdTemp,null,systemDataTempList, dataIdTenList);
        //过滤取出模版中涉及的容器和自定义菜单组件
        List<TemplatePortalInfoContent> contentTempList = portalContentTempList.stream().filter(item ->  item.getContentType().intValue() > Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().intValue() ).collect(Collectors.toList());
        //初始化ID为null
        initContentId(contentTempList);
        //将模版里的内容转换成租户的内容
        List<PortalInfoContent> portalInfoContenTenList=tempToTenContent(contentTempList);
        //初始化租户预设组件
        List<PortalInfoContent> preContentTempList = intPreSystem(portalContentTempList, dataIdTempList, systemRelation);
        if (CollectionUtils.isNotEmpty(preContentTempList)) {
            portalInfoContenTenList.addAll(preContentTempList);
        }
        //将模版中数据源转换成租户数据的实体
        List<LabelSystemData> systemDataList =tempToTenData(systemDataTempList);
        //获取模版中数据源中的源应用信息map
        LabelSystemDataAppVo labelSystemDataDto = labelSystemDataService.getSsoAppMapTemp(systemDataList);
        //初始化租户自定义组件
        List<PortalInfoContent> customContentTempList = intCustomSystem(portalContentTempList, dataIdTempList, systemRelation, dataIdTenList,labelSystemDataDto);
        if (CollectionUtils.isNotEmpty(customContentTempList)) {
            portalInfoContenTenList.addAll(customContentTempList);
        }
        return portalInfoContenTenList;
    }

    /**
     * 将模版里的内容转换成租户的内容
     * @param contentTempList
     * @return
     */
    public  List<PortalInfoContent> tempToTenContent( List<TemplatePortalInfoContent> contentTempList){
        List<PortalInfoContent> portalInfoContenTenList=new ArrayList<>();
        for(TemplatePortalInfoContent contentTemp:contentTempList){
            PortalInfoContent portalInfoContent= converter.convert(contentTemp, PortalInfoContent.class);
            portalInfoContenTenList.add(portalInfoContent);
        }
        return  portalInfoContenTenList;
    }




    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> confimTenTemplate(Long portId) {
        TemplatePortalInfo portalInfo = templatePortalInfoMapper.getPortalById(portId);
        if (null == portalInfo) {
            String error = messageUtils.getMessage("error.message.portal.not.exist.error");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
        }
        //初始化租户布局
        PortalInfo returnPort = getInitPort(portalInfo, portalInfo.getId());
        //查询门户配置的组件
        List<Integer> contentTypeList = new ArrayList<>();
        //查询预设组件和自定义组件和容器
        contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
        contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        contentTypeList.add(Constants.PrtalContentTypeEnum.CONTAINER.getVal());
        //查询模版中涉及的预设组件、自定义组件、容器
        List<TemplatePortalInfoContent> portalContentTempList = templatePortalInfoContentMapper.queryPortalCont(portId, contentTypeList);
        //没有布局内容
        if (CollectionUtils.isEmpty(portalContentTempList)) {
            //跳转到布局设计器
            returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
            returnPort.setPortalContent("");
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //预设组件+ 自定义组件
        List<TemplatePortalInfoContent> preCustomContentList = portalContentTempList.stream().filter(item -> !Constants.PrtalContentTypeEnum.CONTAINER.getVal().equals(item.getContentType())).collect(Collectors.toList());
        //查询预设组件和自定义组件关联的数据源
        List<TemplateSystemSource> systemSourceList = getSysTemSourceTemp(preCustomContentList);
        //都没有配置数据源
        if (CollectionUtils.isEmpty(systemSourceList)) {
            //跳转到布局设计器
            returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
            //同步模版布局内容到租户门户内容里
            List<PortalInfoContent> tenPortalContent = getTenPortalContent(portalContentTempList);
            returnPort.setContentList(tenPortalContent);
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //获取数据源ID
        List<Long> dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        //查询模版中数据源信息
        List<TemplateSystemData> systemDataTempList = templateStystemDataMapper.selByIds(dataIdList);
        //查询模版中包含非IAM应用 的数据源
        List<TemplateSystemData> ssoDataList = systemDataTempList.stream().filter(item -> !ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        //查询模版中包含非IAM应用 的数据源，需要弹出第二个弹框关联原应用
        if (CollectionUtils.isNotEmpty(ssoDataList)) {
            //跳转到关联源应用页面
            returnPort.setJumpToPage(Constants.JumpToPageEnum.CORRELATION_APP_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //模版中没有授权的IAM应用的数据源ID
        List<Long> iamNoPermDataIdTemp=new ArrayList<>();
        //过滤掉没有授权的IAM应用对应的数据源
        systemDataTempList = filterNoPerIAM(systemDataTempList,iamNoPermDataIdTemp);
        //数据源中都是包含的IAM应用，该应用已经全部授权
        List<PortalInfoContent> contentRespTenList = initIamSystemData(iamNoPermDataIdTemp,systemDataTempList, portalContentTempList);
        //跳转到布局设计器
        returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
        //同步模版布局内容到租户门户内容里
        returnPort.setContentList(contentRespTenList);
        return ResponseEntityWrapper.wrapperOk(returnPort);
    }


    /**
     * 过滤掉IAM应用无权限的数据源
     *
     * @param systemDataTempAllList 模版中的数据源
     * @param iamNoPermDataIdTemp 模版中的数据源,且是IAM的，且没有授权的
     * @return
     */
    public List<TemplateSystemData> filterNoPerIAM(List<TemplateSystemData> systemDataTempAllList,List<Long> iamNoPermDataIdTemp) {
        List<TemplateSystemData> systemDataTempList = new ArrayList<>();
        //包含IAM应用 的数据源
        List<TemplateSystemData> iamDataList = systemDataTempAllList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<String, TenantAppDTO> iamInfoMap = new HashMap<>();
        //包含IAM应用的数据源,查询权限
        if (CollectionUtils.isNotEmpty(iamDataList)) {
            //获取该租户下应用清单
            List<TenantAppDTO> allTenantApps = iamService.queryTenantApps();
            iamInfoMap = allTenantApps.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        }
        for (TemplateSystemData systemData : systemDataTempAllList) {
            //如果是IAM应用的数据源
            if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
                TenantAppDTO tenantAppDTO = iamInfoMap.get(systemData.getAppCode());
                //返回的IAM应用中没有该数据源中配置的源应用
                if (null == tenantAppDTO) {
                    iamNoPermDataIdTemp.add(systemData.getId());
                    continue;
                }
                //返回的IAM应用中应用已过期
                String expiredTime = tenantAppDTO.getExpiredTime();
                if (LocalDateTime.parse(expiredTime, DateTimeFormatter.ofPattern(DateUtils.DATE_TIME_NORMAL_FORMATTER)).compareTo(LocalDateTime.now()) < 0) {
                    iamNoPermDataIdTemp.add(systemData.getId());
                    continue;
                }
            }
            systemDataTempList.add(systemData);
        }
        return systemDataTempList;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PortalInfo usePortalInfo(UsePortalInfoDto req) {
        TemplatePortalInfo portalInfo = templatePortalInfoMapper.getPortalById(req.getId());
        if (null == portalInfo) {
            return null;
        }
        //初始化租户布局
        PortalInfo returnPort = getInitPort(portalInfo, req.getId());
        //查询模版内容信息
        List<TemplatePortalInfoContent> portalInfoContentTempList = templatePortalInfoContentMapper.queryPortalCont(portalInfo.getId(), new ArrayList<>());
        //查询模版中预设组件+ 自定义组件
        List<TemplatePortalInfoContent> preCustomContentList = portalInfoContentTempList.stream().filter(item -> !Constants.PrtalContentTypeEnum.CONTAINER.getVal().equals(item.getContentType())).collect(Collectors.toList());
        //查询预设组件和自定义组件关联的数据源
        List<TemplateSystemSource> systemSourceList = getSysTemSourceTemp(preCustomContentList);
        //获取数据源ID
        List<Long> dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        //查询模版中数据源信息
        List<TemplateSystemData> systemDataTempList = templateStystemDataMapper.selByIds(dataIdList);
        // 获取关联的模版中sso和租户的sso中的关联关系
        // 模版中SSO和用户SSO的关联关系,key:模版中PrimaryId_dataSource,val：租户SSO的PrimaryId_dataSource
        Map<String, String> ssoRelation = filterAppRelation(req.getAppRelationList());
        //模版中没有授权的IAM应用的数据源ID
        List<Long> iamNoPermDataIdTemp = new ArrayList<>();
        //获取没有授权的IAM应用对应的数据源
        filterNoPerIAM(systemDataTempList, iamNoPermDataIdTemp);
        //初始化租户数据源/预设组件/自定义组件
        List<PortalInfoContent> contentRespTenList = initSystemData(iamNoPermDataIdTemp, ssoRelation, systemDataTempList, portalInfoContentTempList);
        //初始化租户布局内容
        returnPort.setContentList(contentRespTenList);
        return returnPort;
    }

    /**
     * 获取初始化租户的门户信息
     *
     * @param portalInfo 模版库中门户信息
     * @param id         模版库中门户id
     * @return
     */
    public PortalInfo getInitPort(TemplatePortalInfo portalInfo, Long id) {
        //初始化租户布局
        PortalInfo returnPort = converter.convert(portalInfo, PortalInfo.class);
        returnPort.setId(null);
        returnPort.setPortalImgUrl("");
        returnPort.setParentId(id);
        returnPort.setTemplateId(null);
        String name=Utils.subToName(portalInfo.getName(),30);
        returnPort.setName(name);
        //未发布
        returnPort.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        return returnPort;
    }

    /**
     * 初始化布局中租户数据源、预设组件、自定义组件
     * @param iamNoPermDataIdTemp  模版中没有授权的IAM应用的数据源ID
     * @param ssoRelation 用户在应用关联关系中选择的sso关联关系
     * @param systemDataTempList 模版中组件涉及的数据源
     * @param tempPortalContentList  模版中布局内容-全量
     * @return
     */
    public List<PortalInfoContent> initSystemData(List<Long> iamNoPermDataIdTemp,Map<String, String> ssoRelation, List<TemplateSystemData> systemDataTempList, List<TemplatePortalInfoContent> tempPortalContentList) {
        //租户的数据源ID，已存在的和新增的
        List<Long> dataIdTenList = new ArrayList<>();
        //模版中数据源和租户的数据源映射关系
        Map<Long, Long> systemRelation = new HashMap<>();
        //将模版中数据源转换成租户数据的实体
        List<LabelSystemData> systemDataList =tempToTenData(systemDataTempList);
        //获取模版中数据源中的源应用信息map
        LabelSystemDataAppVo labelSystemDataDto = labelSystemDataService.getSsoAppMapTemp(systemDataList);
        for (TemplateSystemData systemDataTemp : systemDataTempList) {
            //获取模版中数据源中的源应用对应的源应用信息
            Map<Long, LabelSystemDataDto> systemAppNameMap = labelSystemDataDto.getSystemAppNameMap();
            LabelSystemDataDto systemDataDto = systemAppNameMap.get(systemDataTemp.getId());
            String appName = systemDataDto == null ? "" : systemDataDto.getAppName();
            LabelSystemData systemDataReq = new LabelSystemData();
            if(StringUtils.isNotEmpty(appName)){
                appName=appName + "_" + systemDataTemp.getName();
            }
            systemDataReq.setName(appName);
            //模版中的包含IAM的数据源，且IAM没有授权，该数据源是没有授权的IAM源应用，则跳过
            if(iamNoPermDataIdTemp.contains(systemDataTemp.getId())){
                continue;
            }
            String ssoTempKey = systemDataTemp.getAppCode() + "_" + systemDataTemp.getDataType();
            //非IAM 应用 且 说明模版中该数据源对应的SSO没有配置租户的SSO关联关系
            if (!systemDataTemp.getDataType().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())
                    && !systemDataTemp.getDataType().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())
                    && null != ssoRelation) {
                String ssoTenVal = ssoRelation.get(ssoTempKey);
                if (StringUtils.isEmpty(ssoTenVal)) {
                    continue;
                }
            }
            //查询租户下是否存在模版中数据源名称为：应用名称+模版中数据源名称
            LabelSystemData systemDataTen = labelSystemDataMapper.getByInit(systemDataReq);
            //数据源已存在
            if (null != systemDataTen) {
                dataIdTenList.add(systemDataTen.getId());
                systemRelation.put(systemDataTemp.getId(), systemDataTen.getId());
            } else {
                converter.convert(systemDataTemp, systemDataReq);
                //按租户选择的SSO初始化租户的数据源
                if (null != ssoRelation && StringUtils.isNotEmpty(ssoRelation.get(ssoTempKey))) {
                    String ssoTenVal = ssoRelation.get(ssoTempKey);
                    systemDataReq.setAppCode(ssoTenVal.split("_")[0]);
                    systemDataReq.setDataType(Integer.parseInt(ssoTenVal.split("_")[1]));
                }
                //如果是统计组件或者业务代办，则不统计业务指标和统计值
                if(systemDataTemp.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_COUNT.getVal()) ||
                        systemDataTemp.getDataCategory().equals(Constants.DataCategoryEnum.BUSINESS_TODO.getVal())
                ){
                    systemDataReq.setRestUrl("");
                    systemDataReq.setMiddleSystemUid("");
                    systemDataReq.setMiddleSystemName("");
                    systemDataReq.setDataModel(null);
                    systemDataReq.setCountCode("");
                    systemDataReq.setCountContentCode("");
                }
                systemDataReq.setName(appName);
                systemDataReq.setCreateUserId(Utils.getUserId());
                systemDataReq.setCreateTime(DateUtils.getNowTime(""));
                systemDataReq.setModifyTime(DateUtils.getNowTime(""));
                systemDataReq.setModifyUserId(Utils.getUserId());
                //获取作业同步中的作业地址
                getSsoJobUrl(systemDataTemp, systemDataReq, systemDataDto);
                systemDataReq.setTenantId(Utils.getTenantId());
                systemDataReq.setId(null);
                labelSystemDataMapper.insert(systemDataReq);
                dataIdTenList.add(systemDataReq.getId());
                systemRelation.put(systemDataTemp.getId(), systemDataReq.getId());
            }

        }
        //获取模版中的数据源ID
        List<Long> dataIdTempList = systemDataTempList.stream().map(TemplateSystemData::getId).collect(Collectors.toList());
        //过滤取出模版中涉及的容器和自定义菜单组件
        List<TemplatePortalInfoContent> contentTempList = tempPortalContentList.stream().filter(item ->  item.getContentType().intValue() > Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().intValue() ).collect(Collectors.toList());
        //初始化ID为null
        initContentId(contentTempList);
        //将模版内容转换成租户内容
        List<PortalInfoContent> portalInfoContentList=tempToTenContent(contentTempList);
        //初始化租户预设组件
        List<PortalInfoContent> preContentTempList = intPreSystem(tempPortalContentList, dataIdTempList, systemRelation);
        if (CollectionUtils.isNotEmpty(preContentTempList)) {
            portalInfoContentList.addAll(preContentTempList);
        }
        //初始化租户自定义组件
        List<PortalInfoContent> customContentTempList = intCustomSystem(tempPortalContentList, dataIdTempList, systemRelation, dataIdTenList,labelSystemDataDto);
        if (CollectionUtils.isNotEmpty(customContentTempList)) {
            portalInfoContentList.addAll(customContentTempList);
        }
        return portalInfoContentList;
    }

    /**
     * 初始化ID为null
     * @param contentTempList
     */
    public void initContentId(List<TemplatePortalInfoContent> contentTempList ){
        for(TemplatePortalInfoContent contentTemp:contentTempList){
            contentTemp.setId(null);
        }
    }
    /**
     * 获取模版中数据源的作业地址
     *
     * @param systemDataTemp 模版中数据源
     * @param systemDataTen  租户数据源
     * @return
     */
    public String getSsoJobUrl(TemplateSystemData systemDataTemp, LabelSystemData systemDataTen, LabelSystemDataDto systemDataDto) {
        //不是作业集成，退出
        if (!systemDataTemp.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
            return systemDataTemp.getCallBackUrl();
        }
        //是否需要自定义作业（0：不需要；1：需要）
        if (null == systemDataTemp.getIsJob() || systemDataTemp.getIsJob() == 1) {
            return systemDataTemp.getCallBackUrl();
        }
        //雅典娜应用不需要获取作业地址
        if (null != systemDataTemp.getDataType() && ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemDataTemp.getDataType())) {
            return systemDataTemp.getWorkCode();
        }
        List<TemplateSystemData>  systemDataList=new ArrayList<>();
        systemDataList.add(systemDataTemp);
        //获取模版中数据源中的源应用对应的appID
        if (null == systemDataDto) {
            return systemDataTemp.getWorkCode();
        }
        String appId = systemDataDto.getAppId();
        //查询模版中源应用同步的作业地址
        List<SyncJobInfo> syncJobInfoList = syncJobInfoMapper.selByCode(appId, systemDataTemp.getWorkCode());
        if (CollectionUtils.isNotEmpty(syncJobInfoList)) {
            //自定义作业方式
            systemDataTen.setIsJob(1);
            systemDataTen.setWorkCode("");
            systemDataTen.setCallBackUrl(syncJobInfoList.get(0).getJobUrl());
            return syncJobInfoList.get(0).getJobUrl();
        }
        return "";
    }

    /**
     * 初始化 自定义组件
     *
     * @param tempPortalContentList 模版布局中配置的内容
     * @param dataIdTempList        模版组件中涉及的数据源ID
     * @param systemRelation        模版中数据源和租户的数据源映射关系
     * @param dataIdTenList         租户下数据源ID
     */
    public List<PortalInfoContent> intCustomSystem(List<TemplatePortalInfoContent> tempPortalContentList, List<Long> dataIdTempList, Map<Long, Long> systemRelation, List<Long> dataIdTenList,LabelSystemDataAppVo labelSystemDataDto ) {
        //模版组件中涉及的数据源ID 为空
        if (CollectionUtils.isEmpty(dataIdTempList)) {
            return new ArrayList<>();
        }
        //模版中涉及的自定义组件
        List<TemplatePortalInfoContent> customContentTempList = tempPortalContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customContentTempList)) {
            return new ArrayList<>();
        }
        List<Long> customIdTempList = customContentTempList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
        //查询模版中自定义组件信息
        List<TemplateSystemCustom> customTemList = templateSystemCustomMapper.selByIds(customIdTempList);
        if (CollectionUtils.isEmpty(customTemList)) {
            return new ArrayList<>();
        }
        //模版中涉及的自定义信息map
        Map<Long, TemplateSystemCustom> customTemMap = customTemList.stream().collect(Collectors.toMap(TemplateSystemCustom::getId, Function.identity(), (a, b) -> a));
        //查询模版中涉及的自定义组件关联的数据源ID
        List<TemplateSystemSource> customSourceTempList = templateSystemSourceMapper.selBySystemIds(customIdTempList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty(customSourceTempList)) {
            return new ArrayList<>();
        }
        //模版中根据组件ID转map，一个组件对应1个数据源,key:组件ID,val:数据源ID
        Map<Long, Long> customDataTempMap = customSourceTempList.stream().collect(Collectors.toMap(TemplateSystemSource::getSystemId, TemplateSystemSource::getDataId, (a, b) -> a));
        //查询租户中涉及的自定义组件关联的数据源ID
        List<LabelSystemSource> customSourceTenList = labelSystemSourceMapper.selByDataIds(dataIdTenList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        List<Long> customIdTenpList = customSourceTenList.stream().map(LabelSystemSource::getSystemId).collect(Collectors.toList());
        //查询租户中自定义组件信息
        List<LabelSystemCustom> customTenList=new ArrayList<>();
        //租户中涉及的自定义信息map
        Map<Long, LabelSystemCustom> customTenMap=new HashMap<>();
        if(CollectionUtils.isNotEmpty(customIdTenpList)){
            customTenList = labelSystemCustomMapper.selByIds(customIdTenpList);
            //租户中涉及的自定义信息map
            customTenMap = customTenList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        //租户中根据组件ID转map，一个组件对应1个数据源,key:数据源ID,val:组件ID
        Map<Long, Long> customDataTenMap = customSourceTenList.stream().collect(Collectors.toMap(LabelSystemSource::getDataId, LabelSystemSource::getSystemId, (a, b) -> a));
        //需要返回的租户下模版中的自定义组件
        List<PortalInfoContent> customContentTenList = new ArrayList<>();
        for (TemplatePortalInfoContent customContentTemp : customContentTempList) {
             customContentTemp.setId(null);
            //取出模版中组件对应的数据源ID
            Long dataIdTemp = customDataTempMap.get(customContentTemp.getContentId());
            //模版中组件对应的数据源不是当前选择的数据源范围内
            if (!dataIdTempList.contains(dataIdTemp)) {
                continue;
            }
            //取出模版中的数据源ID对应的租户的数据源ID
            Long dataIdTen = systemRelation.get(dataIdTemp);
            //如果该模版中组件关联的数据源 对应的租户下数据源不存在，
            //说明该组件不应该初始化，可能是没有选择或者没有权限
            if(null ==dataIdTen){
                continue;
            }
            //根据数据源ID获取租户的组件ID
            Long customIdTen = customDataTenMap.get(dataIdTen);
            String contentName=customContentTemp.getContentName();
            //租户下该数据源对应的自定义组件已存在，则替换模版中的自定义组件id
            if (null != customIdTen) {
                customContentTemp.setContentId(customIdTen);
                LabelSystemCustom systemCustomTen = customTenMap.get(customIdTen);
                contentName = systemCustomTen == null ? "" : systemCustomTen.getNameZh();
            }//需要初始化租户的自定义组件、自定义组件和数据源的关系
            else {
                LabelSystemCustom systemCustomTen = initCustomData(dataIdTemp,customTemMap.get(customContentTemp.getContentId()), dataIdTen,labelSystemDataDto);
                customContentTemp.setContentId(systemCustomTen.getId());
                customContentTemp.setContentName(systemCustomTen.getNameZh());
            }
            //如果内容中组件名称为空，则获取租户的组件名称
            if(StringUtils.isEmpty(customContentTemp.getContentName())){
                customContentTemp.setContentName(contentName);
            }
            PortalInfoContent portalInfoContentTen= converter.convert(customContentTemp, PortalInfoContent.class);
            customContentTenList.add(portalInfoContentTen);

        }
        return customContentTenList;
    }

    /**
     * 初始化租户的自定义组件以及 自定义组件和数据源的关系
     * @param dataIdTemp 模版中组件对应的的数据源ID
     * @param systemCustomTemp 模版中自定义组件信息
     * @param dataIdTen 租户的数据源ID（模版中自定义组件关联的模版的数据源ID所对应的租户数据源ID）
     * @return
     */
    public LabelSystemCustom initCustomData(Long dataIdTemp,TemplateSystemCustom systemCustomTemp, Long dataIdTen,LabelSystemDataAppVo labelSystemDataDto ) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        //获取模版中数据源中的源应用对应的源应用信息
        Map<Long, LabelSystemDataDto> systemAppNameMap = labelSystemDataDto.getSystemAppNameMap();
        LabelSystemDataDto systemDataDto = systemAppNameMap.get(dataIdTemp);
        String appName = systemDataDto == null ? "" : systemDataDto.getAppName();

        LabelSystemCustom systemCustomTen = converter.convert(systemCustomTemp, LabelSystemCustom.class);
        systemCustomTen.setId(null);
        String contentName= systemCustomTemp.getNameZh();
        if(StringUtils.isNotEmpty(appName)){
            contentName=appName+"_"+systemCustomTemp.getNameZh();
        }
        //先根据模版中组件名称+类型查询是否存在
        LabelSystemCustom customTemp = labelSystemCustomMapper.selByName(contentName, null);
        if (null != customTemp) {
            return customTemp;
        }
        systemCustomTen.setNameZh(contentName);
        systemCustomTen.setCreateUserId(Utils.getUserId());
        systemCustomTen.setCreateUserName(Utils.getUserName());
        systemCustomTen.setModifyUserName(Utils.getUserName());
        systemCustomTen.setCreateTime(DateUtils.getNowTime(""));
        systemCustomTen.setModifyTime(DateUtils.getNowTime(""));
        systemCustomTen.setModifyUserId(Utils.getUserId());
        systemCustomTen.setTenantId(tenantId);
        //初始化租户的自定义组件
        labelSystemCustomMapper.insert(systemCustomTen);
        //初始化租户的自定义组件和数据源的关系
        LabelSystemSource systemSource = new LabelSystemSource();
        systemSource.setDataId(dataIdTen);
        systemSource.setSystemId(systemCustomTen.getId());
        systemSource.setTenantId(tenantId);
        systemSource.setCreateUserId(Utils.getUserId());
        systemSource.setCreateTime(DateUtils.getNowTime(""));
        systemSource.setComponentSource(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        labelSystemSourceMapper.insert(systemSource);
        return systemCustomTen;
    }


    /**
     * 初始化 预设组件
     *
     * @param tempPortalContentList 模版布局中配置的内容
     * @param dataIdTempList        模版组件中涉及的数据源ID
     * @param systemRelation        模版中数据源和租户的数据源映射关系
     */
    public List<PortalInfoContent> intPreSystem(List<TemplatePortalInfoContent> tempPortalContentList, List<Long> dataIdTempList, Map<Long, Long> systemRelation) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        //租户的移动门户对应预设组件
        List<PortalInfoContent> portalInfoContentList=new ArrayList<>();
        //模版中涉及的预设组件
        List<TemplatePortalInfoContent> preContentTempList = tempPortalContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(preContentTempList)) {
            return portalInfoContentList;
        }
        List<Long> preIdTempList = preContentTempList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
        //查询模版中涉及的预设组件关联的数据源ID
        List<TemplateSystemSource> systemSourceTempList = templateSystemSourceMapper.selBySystemIds(preIdTempList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
        //根据组件ID转map，一个组件对应多个数据源
        Map<Long, List<TemplateSystemSource>> preDataTempMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(systemSourceTempList)) {
            //根据组件ID转map，一个组件对应多个数据源
            preDataTempMap = systemSourceTempList.stream().collect(Collectors.groupingBy(TemplateSystemSource::getSystemId));
        }

        //查询模版中的预设组件类型
        List<Integer> dataTypeList = preContentTempList.stream().map(TemplatePortalInfoContent::getDataType).collect(Collectors.toList());
        //如果模版中包含dataType=0 的待办，则需要将租户的dataType=10的三方待办查询出
        if(CollectionUtils.isNotEmpty(dataTypeList)
                && dataTypeList.contains(Constants.DataTypeEnum.TYPE_TODO.getVal())){
            dataTypeList.add(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
        }
        //查询该租户下预设组件
        List<LabelSystemPre> preSystemTenList = labelSystemPreService.initDefPortal(dataTypeList, Constants.ClientTypeEnum.PC.getValue());
        //租户下预设组件信息，key:预设组件ID，val：预设组件
        Map<Integer, LabelSystemPre> preInfoTenMap = preSystemTenList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        List<Long> preTenIdList = preSystemTenList.stream().map(LabelSystemPre::getId).collect(Collectors.toList());
        //查询租户的预设组件关联的数据源ID
        List<LabelSystemSource> systemSourceTenList = labelSystemSourceMapper.selBySystemIds(preTenIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
        //根据组件ID转map，一个组件对应多个数据源，key：预设组件ID，key：多个数据源ID
        Map<Long, List<LabelSystemSource>> preDataTenMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(systemSourceTenList)) {
            //根据组件ID转map，一个组件对应多个数据源
            preDataTenMap = systemSourceTenList.stream().collect(Collectors.groupingBy(LabelSystemSource::getSystemId));
        }
        //遍历模版的预设组件
        for (TemplatePortalInfoContent preContent : preContentTempList) {
            //查询模版预设组件对应的数据源关系
            List<TemplateSystemSource> systemSourcesTempList = preDataTempMap.get(preContent.getContentId());
            //租户下预设组件
            LabelSystemPre preTen = preInfoTenMap.get(preContent.getDataType());
            if(null ==preTen){
                continue;
            }
            preContent.setContentId(preTen.getId());
            preContent.setId(null);
            //模版中预设组件没有配置数据源
            if(CollectionUtils.isEmpty(systemSourcesTempList)){
                continue;
            }
            //租户的三方待办
            //如果模版中的是预设组件中的待办-则需要同步租户的待办的布局和租户的三方待办
            if(preContent.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())){
                LabelSystemPre thirdToDoPreTen = preInfoTenMap.get(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
                BeanUtils.copyProperties(thirdToDoPreTen,preTen);
            }
            //初始化租户的预设组件和数据源的关系
            for (TemplateSystemSource systemSourcesTemp : systemSourcesTempList) {
                //当前的预设组件关联的数据源不在用户选择的数据源范围内
                if (!dataIdTempList.contains(systemSourcesTemp.getDataId())) {
                    continue;
                }
                //取出该模版数据源对应的租户数据源
                Long systemDataIdTen = systemRelation.get(systemSourcesTemp.getDataId());
                //判断该组件关联的数据源是否是用户关联的范围内,为空，说明不在用户选择的数据源范围内
                if(null ==systemDataIdTen){
                    continue;
                }
                //判断该租户的数据源在租户下是否存在
                //租户下预设组件关联的数据源
                List<Long> dataTenIdList=new ArrayList<>();
                List<LabelSystemSource> systemSourcesList = preDataTenMap.get(preTen.getId());
                if(CollectionUtils.isNotEmpty(systemSourcesList)){
                    dataTenIdList = systemSourcesList.stream().map(LabelSystemSource::getDataId).collect(Collectors.toList());
                }
                //如果租户的预设组件中关联的数据源中 没有该数据源，需要加进去
                if (!dataTenIdList.contains(systemDataIdTen)) {
                    LabelSystemSource systemSource = new LabelSystemSource();
                    systemSource.setDataId(systemDataIdTen);
                    systemSource.setSystemId(preTen.getId());
                    systemSource.setTenantId(tenantId);
                    systemSource.setCreateUserId(Utils.getUserId());
                    systemSource.setCreateTime(DateUtils.getNowTime(""));
                    systemSource.setComponentSource(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
                    labelSystemSourceMapper.insert(systemSource);
                    if(null !=preTen){
                        preTen.setModifyTime(DateUtils.getNowTime(""));
                        labelSystemPreService.updateById(preTen);
                    }
                }
            }
        }
        portalInfoContentList=tempToTenContent(preContentTempList);
        return portalInfoContentList;
    }

    /**
     * 获取关联的模版中sso和租户的sso中的关联关系
     * @param appRelationList
     * @return 模版中sso和租户的sso中的关联关系
     */
    public Map<String,String>  filterAppRelation(List<UsePortalDetailDto> appRelationList) {
        //模版中SSO和用户SSO的关联关系,key:模版中PrimaryId_dataSource,val：租户SSO的PrimaryId_dataSource
        Map<String,String>  ssoRelation=new HashMap<>();
        for (UsePortalDetailDto appRelation : appRelationList) {
            AppLinkDTO tempApp = appRelation.getTempApp();
            if (null == tempApp) {
                continue;
            }
            //必填参数为空则跳过
            if (StringUtils.isEmpty(tempApp.getPrimaryId()) || null == tempApp.getDataSource()) {
                continue;
            }
            String key=tempApp.getPrimaryId()+"_"+tempApp.getDataSource();
            AppLinkDTO ssoApp = appRelation.getSsoApp();
            if (null == ssoApp) {
                continue;
            }
            //必填参数为空则跳过
            if (StringUtils.isEmpty(ssoApp.getPrimaryId())|| null == ssoApp.getDataSource()) {
                continue;
            }
            String val=ssoApp.getPrimaryId()+"_"+ssoApp.getDataSource();
            ssoRelation.put(key,val);
        }
        return ssoRelation;
    }

    @Override
    public ResponseEntity<?> checkBenchTemplate(List<Long> templateIds) {
        PortalInfo returnPort = new PortalInfo();
        //查询模版中工作台数据
        List<TemplateBench> benchTempList = templateBenchMapper.selectTempBench(templateIds,0L);
        //都没有配置工作台
        if (CollectionUtils.isEmpty(benchTempList)) {
            //跳转到作业工作台
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        List<Long> benchIdList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        //查询模版中所有泳道数据
        List<TemplateBench> jobBenchTempList= templateBenchMapper.selectBenchByTemp(benchIdList,null);
        if(CollectionUtils.isNotEmpty(jobBenchTempList)){
            benchTempList.addAll(jobBenchTempList);
        }
        List<Long> jobIdTempList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        //都没有配置工作台
        if (CollectionUtils.isEmpty(jobIdTempList)) {
            //跳转到作业工作台
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //查询模版工作台涉及的组件信息
        List<TemplateBenchCustom> jobBenchCustomList = templateBenchCustomMapper.selectBenchBy(jobIdTempList,null);
        //都没有配置作业
        if (CollectionUtils.isEmpty(jobBenchCustomList)) {
            //跳转到作业工作台
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            //初始化模版中工作台、泳道
            initBench(benchTempList);
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        List<Long> systemIdList = jobBenchCustomList.stream().map(TemplateBenchCustom::getSystemId).collect(Collectors.toList());
        //查询作业工作台模版中自定义组件关联的数据源
        List<TemplateSystemSource> systemSourceTempList = templateSystemSourceMapper.selBySystemIds(systemIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        //都没有配置数据源
        if (CollectionUtils.isEmpty(systemSourceTempList)) {
            //跳转到作业工作台
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            //初始化模版中工作台、泳道
            initBench(benchTempList);
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //获取模版中组件关联的数据源ID
        List<Long> dataIdTempList = systemSourceTempList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        //获取模版中数据源信息
        List<TemplateSystemData> systemDataTempList = templateStystemDataMapper.selByIds(dataIdTempList);
        //校验数据源中涉及的IAM应用权限
        ResponseEntity<?> checkResp = checkUserSystem(returnPort, systemDataTempList);
        if (null != checkResp) {
            return checkResp;
        }
        //数据源中包含的都是IAM应用且都都有授权，则初始化这批数据源、组件
        initBenchData(new ArrayList<Long>(),null,systemDataTempList, benchTempList, jobBenchCustomList, systemSourceTempList);
        //跳转到作业工作台
        returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
        return ResponseEntityWrapper.wrapperOk(returnPort);
    }


    /**
     * 初始化作业工作台、数据源、组件、泳道、工作台
     *  @param iamNoPermDataIdTemp 模版中没有授权的IAM应用的数据源ID
     * @param ssoRelation 模版中SSO和用户SSO的关联关系,key:模版中PrimaryId_dataSource,val：租户SSO的PrimaryId_dataSource
     * @param systemDataTempList 模版中的数据源的信息
     * @param jobBenchTempList   模版中的工作台和泳道的信息
     * @param jobBenchCustomList 模版中的泳道和组件的信息
     * @param systemSourceTempList   模版中的组件和数据源的信息
     *
     */
    public void initBenchData(List<Long> iamNoPermDataIdTemp,Map<String, String> ssoRelation,
                              List<TemplateSystemData> systemDataTempList, List<TemplateBench> jobBenchTempList,
                              List<TemplateBenchCustom> jobBenchCustomList, List<TemplateSystemSource> systemSourceTempList) {
        //获取模版中的数据源ID
        List<Long> dataIdTempList = systemDataTempList.stream().map(TemplateSystemData::getId).collect(Collectors.toList());
        //租户的数据源ID，已存在的和新增的
        List<Long> dataIdTenList = new ArrayList<>();
        //初始化租户数据源，获取模版中数据源和租户的数据源映射关系
        Map<Long, Long> systemRelation = initSystemDataTen(iamNoPermDataIdTemp,ssoRelation,systemDataTempList, dataIdTenList);
        //初始化自定义组件
        //模版中组件ID和租户的组件ID关系,key:模版中组件ID，val：租户组件ID
        Map<Long, Long> customDataRelationMap = initBenchCustom(iamNoPermDataIdTemp,systemDataTempList,dataIdTempList, dataIdTenList, jobBenchCustomList, systemSourceTempList, systemRelation);
        //初始化模版中工作台、泳道
        Map<Long, Long> benchRelationMap =initBench(jobBenchTempList);
        //初始化工作台和组件的关系
        for (TemplateBenchCustom jobBenchCustomTemp : jobBenchCustomList) {
            //根据模版中的泳道ID获取租户的泳道ID
            Long benchIdTen = benchRelationMap.get(jobBenchCustomTemp.getBenchId());
            //根据模版中的组件ID获取租户的组件ID
            Long systemIdTen = customDataRelationMap.get(jobBenchCustomTemp.getSystemId());
            JobBenchCustom benchCustomTen = converter.convert(jobBenchCustomTemp, JobBenchCustom.class);
            benchCustomTen.setId(null);
            benchCustomTen.setBenchId(benchIdTen);
            benchCustomTen.setTenantId(Utils.getTenantId());
            benchCustomTen.setCreateTime(DateUtils.getNowTime(""));
            if(null !=systemIdTen && null !=benchIdTen){
                benchCustomTen.setSystemId(systemIdTen);
                jobBenchCustomMapper.insert(benchCustomTen);
            }
        }

    }

    /**
     * 初始化作业工作台 泳道
     * @param jobBenchTempList   模版中的工作台和泳道的信息
     *
     */
    public  Map<Long, Long> initBench(List<TemplateBench> jobBenchTempList) {
        //模版中工作台、泳道 和 租户下工作台、泳道的关系
        Map<Long, Long> benchRelationMap = new HashMap<>();
        //将工作台和泳道转上下级map
        Map<Long,List<TemplateBench>> benchLaneTempMap = jobBenchTempList.stream().collect(Collectors.groupingBy(TemplateBench::getParentId));
       //得到所有一级的工作台
        List<TemplateBench> jobBenchParentTempList = jobBenchTempList.stream().filter(x -> x.getParentId().equals(0L)).collect(Collectors.toList());
        //获取租户工作台中排序最近的下标
        Integer index = jobBenchMapper.getIndexByTen(Utils.getTenantId());
        //初始化工作台和泳道的数据
        for (TemplateBench jobBenchTemp : jobBenchParentTempList) {

            if (null == index) {
                index = 0;
            }
            index = index + 1;
            //插入工作台
            JobBench jobBenchTen = converter.convert(jobBenchTemp, JobBench.class);
            jobBenchTen.setLabelIndex(index);
            //根据名称查询一级的工作台是否存在
            JobBench jobBenchParentTen = jobBenchMapper.checkBenchList(jobBenchTemp.getParentId(), jobBenchTemp.getName());
            if (null != jobBenchParentTen) {
                String name = Utils.subToName(jobBenchTemp.getName(), 12);
                jobBenchTen.setName(name);
            }
            jobBenchTen.setId(null);
            jobBenchTen.setTenantId(Utils.getTenantId());
            jobBenchTen.setTemplateId(null);
            jobBenchMapper.insert(jobBenchTen);
            //插入泳道数据
            List<TemplateBench> laneTempList=benchLaneTempMap.get(jobBenchTemp.getId());
            for (TemplateBench childBenchTemp : laneTempList) {
                JobBench childBenchTen = converter.convert(childBenchTemp, JobBench.class);
                childBenchTen.setId(null);
                childBenchTen.setParentId(jobBenchTen.getId());
                childBenchTen.setTenantId(Utils.getTenantId());
                childBenchTen.setTemplateId(null);
                childBenchTen.setCreateTime(DateUtils.getNowTime(""));
                jobBenchMapper.insert(childBenchTen);
                benchRelationMap.put(childBenchTemp.getId(), childBenchTen.getId());
            }
        }
      return  benchRelationMap;
    }

    /**
     * 初始化 作业工作台中的 自定义组件
     * @param iamNoPermDataIdTemp 模版中没有授权的IAM应用的数据源ID
     * @param systemDataTempList      模版中的数据源
     * @param dataIdTempList         模版中的数据源ID
     * @param dataIdTenList          租户的数据源
     * @param jobBenchCustomTempList 模版中工作台涉及组件
     * @param systemSourceTempList   模版中工作台涉及组件和数据源
     * @param systemRelation         模版中数据源和租户的数据源映射关系
     */
    public Map<Long, Long> initBenchCustom(List<Long> iamNoPermDataIdTemp,List<TemplateSystemData> systemDataTempList,
                                           List<Long> dataIdTempList, List<Long> dataIdTenList,
                                           List<TemplateBenchCustom> jobBenchCustomTempList,
                                           List<TemplateSystemSource> systemSourceTempList,
                                           Map<Long, Long> systemRelation) {
        //模版中组件ID和租户的组件ID关系,key:模版中组件ID，val：租户组件ID
        Map<Long, Long> customDataRelationMap = new HashMap<>();
        //将模版中数据源转换成租户数据的实体
        List<LabelSystemData> systemDataList =tempToTenData(systemDataTempList);
        //获取模版中数据源中的源应用信息map
        LabelSystemDataAppVo labelSystemDataDto = labelSystemDataService.getSsoAppMapTemp(systemDataList);
        //模版中组件ID集合
        List<Long> sytemIdTempList = systemSourceTempList.stream().map(TemplateSystemSource::getSystemId).collect(Collectors.toList());
        //查询模版中自定义组件信息
        List<TemplateSystemCustom> customTempList = templateSystemCustomMapper.selByIds(sytemIdTempList);
        if (CollectionUtils.isEmpty(customTempList)) {
            return customDataRelationMap;
        }
        //模版中涉及的自定义信息map
        Map<Long, TemplateSystemCustom> customTemMap = customTempList.stream().collect(Collectors.toMap(TemplateSystemCustom::getId, Function.identity(), (a, b) -> a));
        //模版中工作台涉及组件和数据源的关系map,key:组件ID，val:数据源ID
        Map<Long, Long> systemDataTemMap = systemSourceTempList.stream().collect(Collectors.toMap(TemplateSystemSource::getSystemId, TemplateSystemSource::getDataId, (a, b) -> a));
        //模版中工作台涉及组件和数据源的关系map,key:数据源ID，val:组件ID
        Map<Long, Long> systemDataTemCheckMap = systemSourceTempList.stream().collect(Collectors.toMap(TemplateSystemSource::getDataId, TemplateSystemSource::getSystemId, (a, b) -> a));

        //租户的数据源关联的组件信息
        List<LabelSystemSource> customSourceTenList = labelSystemSourceMapper.selByDataIds(dataIdTenList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        //租户中根据组件ID转map，一个组件对应1个数据源,key:数据源ID,val:组件ID
        Map<Long, Long> customDataTenMap=new HashMap<>();
        if (CollectionUtils.isNotEmpty(customSourceTenList)) {
            customDataTenMap = customSourceTenList.stream().collect(Collectors.toMap(LabelSystemSource::getDataId, LabelSystemSource::getSystemId, (a, b) -> a));
        }

        for (TemplateBenchCustom jobBenchCustomTemp : jobBenchCustomTempList) {
            //取出模版中组件对应的数据源ID
            Long dataIdTemp = systemDataTemMap.get(jobBenchCustomTemp.getSystemId());
            //模版中组件对应的数据源不是当前选择的数据源范围内
            if (!dataIdTempList.contains(dataIdTemp)) {
                continue;
            }
            //校验是当前的组件是否是 没有IAM授权的数据源所关联的组件
            //取出模版中组件对应的数据源ID
            Long iamNoPremDataId = systemDataTemCheckMap.get(jobBenchCustomTemp.getSystemId());
            //该组件关联的数据源是IAM的源应用，且没有授权
            if (iamNoPermDataIdTemp.contains(iamNoPremDataId)) {
                continue;
            }
            //取出模版中的数据源ID对应的租户的数据源ID
            Long dataIdTen = systemRelation.get(dataIdTemp);
            //如果该模版中组件关联的数据源 对应的租户下数据源不存在，
            //说明该组件不应该初始化，可能是没有选择或者没有权限
            if(null ==dataIdTen){
                continue;
            }
            //根据数据源ID获取租户的组件ID
            Long customIdTen = customDataTenMap.get(dataIdTen);
            //租户下该数据源对应的自定义组件已存在，则替换模版中的自定义组件id
            if (null != customIdTen) {
                customDataRelationMap.put(jobBenchCustomTemp.getSystemId(), customIdTen);
            }//需要初始化租户的自定义组件、自定义组件和数据源的关系
            else {
                LabelSystemCustom systemCustomTen = initCustomData(dataIdTemp,customTemMap.get(jobBenchCustomTemp.getSystemId()), dataIdTen, labelSystemDataDto);
                customDataRelationMap.put(jobBenchCustomTemp.getSystemId(), systemCustomTen.getId());
            }
        }
        return customDataRelationMap;
    }

    @Override
    public ResponseEntity<?> confimBenchTemplate(List<Long> templateIds) {
        PortalInfo returnPort = new PortalInfo();

        //查询模版中工作台数据
        List<TemplateBench> benchTempList = templateBenchMapper.selectTempBench(templateIds, 0L);
        //都没有配置工作台
        if (CollectionUtils.isEmpty(benchTempList)) {
            //跳转到作业工作台
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        List<Long> benchIdList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        //查询模版中泳道数据
        List<TemplateBench> jobBenchTempList = templateBenchMapper.selectBenchByTemp(benchIdList, null);
        jobBenchTempList.addAll(benchTempList);
        //都没有配置工作台
        if (CollectionUtils.isEmpty(jobBenchTempList)) {
            //跳转到作业工作台
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        List<Long> jobIdTempList = jobBenchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        //查询模版工作台涉及的组件信息
        List<TemplateBenchCustom> jobBenchCustomList = templateBenchCustomMapper.selectBenchBy(jobIdTempList,null);
        //都没有配置作业
        if (CollectionUtils.isEmpty(jobBenchCustomList)) {
            //跳转到作业工作台
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            //初始化模版中工作台、泳道
            initBench(jobBenchTempList);
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        List<Long> systemIdList = jobBenchCustomList.stream().map(TemplateBenchCustom::getSystemId).collect(Collectors.toList());
        //查询作业工作台模版中自定义组件关联的数据源
        List<TemplateSystemSource> systemSourceTempList = templateSystemSourceMapper.selBySystemIds(systemIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        //都没有配置数据源
        if (CollectionUtils.isEmpty(systemSourceTempList)) {
            //跳转到作业工作台
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            //初始化模版中工作台、泳道
            initBench(jobBenchTempList);
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //获取模版中数据源ID
        List<Long> dataIdList = systemSourceTempList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        //查询模版中数据源信息
        List<TemplateSystemData> systemDataTempList = templateStystemDataMapper.selByIds(dataIdList);
        //包含非IAM应用 的数据源
        List<TemplateSystemData> ssoDataList = systemDataTempList.stream().filter(item -> !ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        //包含非IAM应用 的数据源，需要弹出第二个弹框关联原应用
        if (CollectionUtils.isNotEmpty(ssoDataList)) {
            //跳转到关联源应用页面
            returnPort.setJumpToPage(Constants.JumpToPageEnum.CORRELATION_APP_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk(returnPort);
        }
        //模版中没有授权的IAM应用的数据源ID
        List<Long> iamNoPermDataIdTemp = new ArrayList<>();
        //过滤掉没有授权的IAM应用对应的数据源
        systemDataTempList = filterNoPerIAM(systemDataTempList, iamNoPermDataIdTemp);
        //数据源中包含的都是IAM应用且都都有授权，则初始化这批数据源、组件
        initBenchData(iamNoPermDataIdTemp, null, systemDataTempList, jobBenchTempList, jobBenchCustomList, systemSourceTempList);
        //跳转到作业工作台
        returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
        return ResponseEntityWrapper.wrapperOk(returnPort);
    }

    @Override
    public ResponseEntity<?> useBenchTemp(UsePortalInfoDto req) {
        //查询模版中工作台数据
        List<TemplateBench> benchTempList = templateBenchMapper.selectTempBench(req.getBenchIdList(),0L);
        //都没有配置工作台
        if (CollectionUtils.isEmpty(benchTempList)) {
            //跳转到作业工作台
            return ResponseEntityWrapper.wrapperOk();
        }
        List<Long> benchIdList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        //获取作业工作台模版中泳道数据
        List<TemplateBench> jobBenchTempList = templateBenchMapper.selectBenchByTemp(benchIdList,null);
        jobBenchTempList.addAll(benchTempList);
        //都没有配置工作台
        if (CollectionUtils.isEmpty(jobBenchTempList)) {
            //跳转到作业工作台
            return ResponseEntityWrapper.wrapperOk();
        }
        List<Long> jobIdTempList = jobBenchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        //查询模版工作台涉及的组件信息
        List<TemplateBenchCustom> jobBenchCustomList = templateBenchCustomMapper.selectBenchBy(jobIdTempList,null);
        //都没有配置作业
        if (CollectionUtils.isEmpty(jobBenchCustomList)) {
            //初始化模版中工作台、泳道
            initBench(jobBenchTempList);
            //跳转到作业工作台
            return ResponseEntityWrapper.wrapperOk();
        }
        List<Long> systemIdList = jobBenchCustomList.stream().map(TemplateBenchCustom::getSystemId).collect(Collectors.toList());
        //查询模版中作业工作台模版中自定义组件关联的数据源
        List<TemplateSystemSource> systemSourceTempList = templateSystemSourceMapper.selBySystemIds(systemIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        //获取模版中数据源ID
        List<Long> dataIdList = systemSourceTempList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        //查询模版中数据源信息
        List<TemplateSystemData> systemDataTempList = templateStystemDataMapper.selByIds(dataIdList);
        // 获取关联的模版中sso和租户的sso中的关联关系
        // 模版中SSO和用户SSO的关联关系,key:模版中PrimaryId_dataSource,val：租户SSO的PrimaryId_dataSource
        Map<String, String> ssoRelation = filterAppRelation(req.getAppRelationList());
        //模版中没有授权的IAM应用的数据源ID
        List<Long> iamNoPermDataIdTemp=new ArrayList<>();
        //获取没有授权的IAM应用对应的数据源
        filterNoPerIAM(systemDataTempList,iamNoPermDataIdTemp);
        //初始化租户工作台、数据源、预设组件、自定义组件
        initBenchData(iamNoPermDataIdTemp,ssoRelation,systemDataTempList, jobBenchTempList, jobBenchCustomList, systemSourceTempList);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    public TemplateInfo getTempGroupVO(Long tempId) {
        TemplateInfo templateInfo=new TemplateInfo();
        List<Long> templateIdList = new ArrayList<>();
        templateIdList.add(tempId);
        //查询模版中的分组
        List<TemplateInfoTenant> infoTenantList = templateInfoTenantMapper.selectByTemp(templateIdList);
        //分组信息集合
        List<TemplateTenantGroupVO> tenantGroupVOList = new ArrayList<>();
        //分组信息Map
        Map<Long, TemplateTenantGroupVO> tenantGroupVOMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(infoTenantList)) {
            List<String> groupIdList = infoTenantList.stream().map(TemplateInfoTenant::getGroupTenantId).collect(Collectors.toList());
            tenantGroupVOList = templateTenantGroupMapper.selectByIds(groupIdList);

        }
        if (CollectionUtils.isNotEmpty(tenantGroupVOList)) {
            tenantGroupVOMap = tenantGroupVOList.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        }
        //租户集合
        List<TemplateTenantVO> tenantList = new ArrayList<>();
        //按分组
        List<TemplateTenantGroupVO> groupList = new ArrayList<>();
        for (TemplateInfoTenant tenant : infoTenantList) {
            //按租户
            if (tenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag())) {
                TemplateTenantVO tenantVO = new TemplateTenantVO();
                tenantVO.setSubTenantId(tenant.getGroupTenantId());
                tenantVO.setSubTenantName(tenant.getSubTenantName());
                tenantList.add(tenantVO);
            }
            //按分组
            if (tenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag())
                    && null !=tenantGroupVOMap.get(Long.parseLong(tenant.getGroupTenantId()))
            ) {
                groupList.add(tenantGroupVOMap.get(Long.parseLong(tenant.getGroupTenantId())));
            }
        }
        templateInfo.setSubTenantList(tenantList);
        templateInfo.setGroupList(groupList);
        return templateInfo;
    }

    @Override
    public List<TemplateBench> queryVisibleTempList(Integer templateType) {
        List<TemplateBench> benchList = new ArrayList<>();
        //获取全部租户和部分租户可见的模版
        TemplateQueryReq req = new TemplateQueryReq();
        req.setTemplateType(templateType);
        List<Integer> subTypeList = new ArrayList<>();
        subTypeList.add(Constants.SubTypeEnum.ALL_TENANT.getFlag());
        subTypeList.add(Constants.SubTypeEnum.PART_TENANT.getFlag());
        List<TemplateInfo> templateInfoList = templateInfoMapper.queryByTemp(req, subTypeList);
        //模版中租户信息map，key：模版ID，val:租户和分组信息
        Map<Long, List<TemplateInfoTenant>> tenantGroupMap = new HashMap<>();
        //分组信息map，key：分组ID，val:分组信息
        Map<Long, TemplateTenantGroup> groupMap = new HashMap<>();
        //分组中租户信息map，key：分组ID，val:租户信息
        Map<Long, List<TemplateTenantGroupItem>> groupItemMap = new HashMap<>();
        //全员可见模版创建人的租户信息map，key：创建人ID，val:租户信息
        Map<String, List<TemplateUserTenant>> userTenantMap = new HashMap<>();
        //得到全员可见模版 且不是通用模版 的 创建人ID
        List<String> tempSubUserIdList=new ArrayList<>();

        if (CollectionUtils.isNotEmpty(templateInfoList)) {
            //得到全员可见模版 且不是通用模版 的 创建人ID
            List<TemplateInfo> allTenantList = templateInfoList.stream()
                    .filter(item -> Constants.SubTypeEnum.ALL_TENANT.getFlag().equals(item.getSubType()))
                    .filter(item -> !item.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES))
                    .collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(allTenantList)) {
                tempSubUserIdList=allTenantList.stream().map(TemplateInfo::getCreateUserId).collect(Collectors.toList());
            }
            //得到全员可见和部分可见的模版ID
            List<Long> tempIdList = templateInfoList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
            //如果模版是部分租户则需要查询分组和租户信息
            List<TemplateInfoTenant> tenantGroupList = templateInfoTenantMapper.selectByTemp(tempIdList);
            tenantGroupMap = tenantGroupList.stream().collect(Collectors.groupingBy(TemplateInfoTenant::getTemplateId));
            //得到所有按分组的分组id
            List<String> groupIdList = tenantGroupList.stream().filter(x -> Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag().equals(x.getSelectType())).map(TemplateInfoTenant::getGroupTenantId).distinct().collect(Collectors.toList());
            //查询分组信息
            if (CollectionUtils.isNotEmpty(groupIdList)) {
                List<TemplateTenantGroup> groupList = templateTenantGroupMapper.selectByParam(groupIdList);
                groupMap = groupList.stream().collect(Collectors.toMap(TemplateTenantGroup::getId, Function.identity()));
                List<TemplateTenantGroupItem> groupItemList = templateTenantGroupItemMapper.selectByGroup(groupIdList);
                groupItemMap = groupItemList.stream().collect(Collectors.groupingBy(TemplateTenantGroupItem::getGroupId));
            }
        }

        if (CollectionUtils.isNotEmpty(tempSubUserIdList)) {
            //查询模版创建人关联的全部租户
            List<TemplateUserTenant> userTenantList = templateUserTenantMapper.selectByUserId(tempSubUserIdList);
            if (CollectionUtils.isNotEmpty(userTenantList)) {
                userTenantMap = userTenantList.stream().collect(Collectors.groupingBy(TemplateUserTenant::getSubUserId));
            }
        }
        for (TemplateInfo templateInfo : templateInfoList) {
            TemplateBench templateBench = new TemplateBench();
            templateBench.setId(templateInfo.getId());
            templateBench.setName(templateInfo.getTemplateName());
            //全部租户可见 且 通用门户
            if (templateInfo.getSubType().equals(Constants.SubTypeEnum.ALL_TENANT.getFlag())
                    && templateInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)
            ) {
                benchList.add(templateBench);
                continue;
            }

            //全部租户可见 且 当前登录用户的租户在范围内
            List<TemplateUserTenant> tempTenantList=userTenantMap.get(templateInfo.getCreateUserId());
            //全员可见模版创建人的租户信息map，key：创建人ID，val:租户信息
            List<String> subTenantIdList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(tempTenantList)) {
                subTenantIdList = tempTenantList.stream().map(TemplateUserTenant::getSubTenantId).collect(Collectors.toList());
            }
           if (templateInfo.getSubType().equals(Constants.SubTypeEnum.ALL_TENANT.getFlag())
                    && subTenantIdList.contains(Utils.getTenantId())
            ) {
                benchList.add(templateBench);
                continue;
            }
            //部分租户可见，判断当前租户是否在部分租户中
            if (templateInfo.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
                //当前租户可见
                if (checkTenantAuth(templateInfo.getId(), tenantGroupMap, groupItemMap, groupMap)) {
                    benchList.add(templateBench);
                }
            }
        }
        return benchList;
    }

    /**
     * 校验租户是否有权限
     * @param tempId 模版ID
     * @param tenantGroupMap 模版中租户
     * @param groupItemMap 分组中的租户
     * @param groupMap 分组信息
     * @return
     */
    public boolean checkTenantAuth(Long tempId,Map<Long,List<TemplateInfoTenant>> tenantGroupMap,
                                   Map<Long,List<TemplateTenantGroupItem>> groupItemMap,
                                   Map<Long,TemplateTenantGroup> groupMap) {
        Boolean isAuth = false;
        List<TemplateInfoTenant> templateInfoTenants = tenantGroupMap.get(tempId);
        if (CollectionUtils.isEmpty(templateInfoTenants)) {
            return isAuth;
        }
        for (TemplateInfoTenant templateTenant : templateInfoTenants) {
            //按租户,且当前租户=该租户
            if (templateTenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag())
                    && templateTenant.getGroupTenantId().equals(Utils.getTenantId())
            ) {
                isAuth = true;
                return isAuth;
            }
            //按分组
            if (templateTenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag())) {
                //校验分组是否存在
                TemplateTenantGroup group = groupMap.get(Long.parseLong(templateTenant.getGroupTenantId()));
                if (null == group) {
                    continue;
                }
                //校验分组是否已停用
                if (group.getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
                    continue;
                }
                List<TemplateTenantGroupItem> groupItemList = groupItemMap.get(Long.parseLong(templateTenant.getGroupTenantId()));
                //分组下的租户为空
                if (CollectionUtils.isEmpty(groupItemList)) {
                    continue;
                }
                List<String> groupTenantIdList = groupItemList.stream().map(TemplateTenantGroupItem::getSubTenantId).collect(Collectors.toList());
                //当前的租户在分组下的租户中
                if (groupTenantIdList.contains(Utils.getTenantId())) {
                    isAuth = true;
                    return isAuth;
                }
            }
        }
        return isAuth;
    }

}