package com.digiwin.athena.semc.service.temp.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ComponentSourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.entity.temp.TemplateInfoTenant;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfo;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemPre;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.portal.PortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemPreMapper;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.service.temp.TemplatePortalInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.temp.TemplatePortalVO;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import io.github.linpeilie.Converter;

@Service
public class TemplatePortalInfoServiceImpl extends ServiceImpl<TemplatePortalInfoMapper, TemplatePortalInfo> implements TemplatePortalInfoService {

    @Resource
    TemplateInfoMapper templateInfoMapper;

    @Resource
    TemplateInfoTenantMapper templateInfoTenantMapper;

    @Resource
    TemplatePortalInfoMapper templatePortalInfoMapper;

    @Resource
    TemplatePortalInfoContentMapper templatePortalInfoContentMapper;

    @Resource
    TemplateInfoService templateInfoService;


    @Resource
    PortalInfoMapper portalInfoMapper;

    @Resource
    PortalInfoContentMapper portalInfoContentMapper;

    @Resource
    private EnvProperties envProperties;

    @Resource
    TemplateSystemCustomMapper templateSystemCustomMapper;

    @Autowired
    TemplateSystemPreMapper templateSystemPreMapper;

    @Resource(name = "semcAsyncExecutor")
    private Executor asyncTaskExecutor;

    @Resource
    private Converter converter;

    @Override
    @Transactional
    public Integer savePortalTemp(TemplatePortalVO req) {
        //保存模版信息
        TemplateInfo templateInfo = packageTemplateInfo(req);
        Long tempId = templateInfoService.saveTemp(templateInfo);
        //默认门户
        if(null !=req.getDefaultFlag() && req.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)){
            editDefPortal(tempId, req);
        }else {
            //保存门户信息
            saveTempPortal(tempId, req);
        }
        //如果发布的租户非部分租户，则结束
        if (null == req.getSubType() || !req.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
            return null;
        }
        //删除之前的模版下数据
        List<Long> templateIdList=new ArrayList<>();
        templateIdList.add(tempId);
        templateInfoTenantMapper.delByTemp(templateIdList);
        //保存发布到租户的数据
        TemplateInfo tenantReq = new TemplateInfo();
        tenantReq.setSubTenantList(req.getSubTenantList());
        tenantReq.setGroupList(req.getGroupList());
        List<TemplateInfoTenant> tenantGroupList = templateInfoService.addTempTeanntList(tenantReq, tempId);
        if (CollectionUtils.isNotEmpty(tenantGroupList)) {
            templateInfoTenantMapper.batchInsertTenant(tenantGroupList,Utils.getUserId(),DateUtils.getNowTime(""));
        }
        return null;
    }

    /**
     * 保存模版中通用门户信息
     * @param tempId
     * @param req
     */
    public Integer editDefPortal(Long tempId,TemplatePortalVO req) {
        //更新模版
        TemplatePortalInfo templatePortalInfo = converter.convert(req, TemplatePortalInfo.class);
        templatePortalInfo.setTemplateId(tempId);
        templatePortalInfo.setModifyTime(DateUtils.getNowTime(""));
        templatePortalInfo.setTenantId(Utils.getTenantId());
        templatePortalInfo.setModifyUserName(Utils.getUserName());
        templatePortalInfoMapper.upPortDefById(templatePortalInfo);
        //删除布局内容
        templatePortalInfoContentMapper.delPortalCont(templatePortalInfo.getId());
        //保存涉及布局内容
        if (CollectionUtils.isNotEmpty(req.getContentList())) {
            templatePortalInfoContentMapper.batchInsert(req.getContentList(), templatePortalInfo.getId(), Utils.getTenantId());
        }
        //异步更新租户的通用门户
        CompletableFuture.supplyAsync(() -> upTenantDefPortal(req), asyncTaskExecutor);
        return 0;
    }

    /**
     * 异步更新租户的通用门户
     * @param req
     * @return
     */
    public Integer upTenantDefPortal(TemplatePortalVO req){
        //更新租户的通用门户
        List<PortalInfo> portalInfoList=portalInfoMapper.queryDefPortal("");
        for(PortalInfo portalInfo:portalInfoList){
            portalInfo.setPortalImgId(req.getPortalImgId());
            portalInfo.setPortalContent(req.getPortalContent());
            portalInfo.setTemplateId(null);
            portalInfo.setModifyTime(DateUtils.getNowTime(""));
            portalInfo.setModifyUserName(Utils.getUserName());
            portalInfoMapper.upPortDefById(portalInfo);
            //删除布局内容
            portalInfoContentMapper.delPortalCont(portalInfo.getId());
            //保存涉及布局内容
            if (CollectionUtils.isNotEmpty(req.getContentList())) {
                List<PortalInfoContent> contentList=new ArrayList<>();
                for(TemplatePortalInfoContent contetTempList:req.getContentList()){
                    PortalInfoContent content=converter.convert(contetTempList, PortalInfoContent.class);
                    contentList.add(content);
                }
                portalInfoContentMapper.batchInsert(contentList,portalInfo.getId(),portalInfo.getTenantId());
            }
        }
        return 0;
    }
    /**
     * 保存模版中门户信息
     * @param tempId
     * @param req
     */
    public void saveTempPortal(Long tempId,TemplatePortalVO req) {
        TemplatePortalInfo templatePortalInfo = converter.convert(req, TemplatePortalInfo.class);
        templatePortalInfo.setTemplateId(tempId);
        templatePortalInfo.setModifyTime(DateUtils.getNowTime(""));
        templatePortalInfo.setTenantId(Utils.getTenantId());
        templatePortalInfo.setModifyUserName(Utils.getUserName());
        //默认给未发布
        if (null == req.getStatus()) {
            templatePortalInfo.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        }
        //门户保存
        if (null == req.getId()) {
            templatePortalInfo.setCreateTime(DateUtils.getNowTime(""));
            templatePortalInfo.setCreateUserName(Utils.getUserName());
            templatePortalInfoMapper.insert(templatePortalInfo);
        } else {
            templatePortalInfoMapper.updateById(templatePortalInfo);
        }
        //删除布局内容
        templatePortalInfoContentMapper.delPortalCont(templatePortalInfo.getId());
        //保存涉及布局内容
        if (CollectionUtils.isNotEmpty(req.getContentList())) {
            templatePortalInfoContentMapper.batchInsert(req.getContentList(), templatePortalInfo.getId(), Utils.getTenantId());
        }
    }

    /**
     * 组装模版数据
     * @param req
     * @return
     */
    public TemplateInfo packageTemplateInfo(TemplatePortalVO req) {
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setId(req.getTemplateId());
        templateInfo.setTemplateName(req.getName());
        templateInfo.setTemplateDesc(req.getPortalDesc());
        templateInfo.setSubType(req.getSubType());
        templateInfo.setTemplateType(Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal());
        templateInfo.setStatus(req.getStatus());
        return templateInfo;
    }


    @Override
    public TemplatePortalVO getPortalTemp(TemplatePortalVO req) {
        //默认都是通用菜单
        req.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        //查询模版信息
        TemplateInfo templateInfo = templateInfoMapper.getTemplateById(req.getTemplateId());
        if (null == templateInfo) {
            return req;
        }
        req.setSubType(templateInfo.getSubType());
        TemplatePortalInfo portalInfo = templatePortalInfoMapper.getPortalByTemp(req.getTemplateId());
        if (portalInfo==null) {
            return req;
        }
        req=converter.convert(portalInfo, TemplatePortalVO.class);
        req.setCreateTime(templateInfo.getCreateTime());
        req.setCreateUserId(templateInfo.getCreateUserId());
        req.setCreateUserName(templateInfo.getCreateUserName());
        req.setModifyUserName(templateInfo.getModifyUserName());
        req.setModifyTime(templateInfo.getModifyTime());
        req.setModifyUserId(templateInfo.getModifyUserId());
        //默认都是通用菜单
        req.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        //查询门户内容
        List<TemplatePortalInfoContent> contentList = templatePortalInfoContentMapper.queryPortalCont(portalInfo.getId(), null);
        Map<Long, TemplateSystemPre> preInfoMap = new HashMap<>();
        //预设组件
        List<TemplatePortalInfoContent> preDataList = contentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preDataList)) {
            List<Long> preIds = preDataList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
            List<TemplateSystemPre> preList = templateSystemPreMapper.selectBatchIds(preIds);
            preInfoMap = preList.stream().collect(Collectors.toMap(TemplateSystemPre::getId, Function.identity(), (a, b) -> a));
        }
        Map<Long, TemplateSystemCustom> customInfoMap = new HashMap<>();
        //自定义组件
        List<TemplatePortalInfoContent> customDataList = contentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customDataList)) {
            List<Long> customIds = customDataList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
            List<TemplateSystemCustom> customList = templateSystemCustomMapper.selectBatchIds(customIds);
            customInfoMap = customList.stream().collect(Collectors.toMap(TemplateSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        //组装图标和类型
        for (TemplatePortalInfoContent content : contentList) {
            //预设组件
            if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(content.getContentType())) {
                TemplateSystemPre labelSystemPre = preInfoMap.get(content.getContentId());
                content.setDataType(labelSystemPre == null ? null : labelSystemPre.getDataType());
                content.setContentId(labelSystemPre == null ? content.getContentId() : labelSystemPre.getId());
            }
            //自定义组件
            if (ComponentSourceEnum.LABEL_SYSTEM_CUSTOM.getCode().equals(content.getContentType())) {
                TemplateSystemCustom systemCustom = customInfoMap.get(content.getContentId());
                if (systemCustom == null) {
                    continue;
                }
                content.setContentName(StringUtils.isEmpty(content.getContentName()) ? systemCustom.getNameZh() : content.getContentName());
                content.setClassicsIcon(systemCustom.getClassicsIcon());
            }
        }
        req.setContentList(contentList);
        //不是部分租户方式，跳过
        if (null == templateInfo.getSubType() || !templateInfo.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
            return req;
        }
        //部分租户方式，取出模版中部分租户的数据（包括分组和租户）
        TemplateInfo templateGroup=templateInfoService.getTempGroupVO(templateInfo.getId());
        req.setSubTenantList(templateGroup.getSubTenantList());
        req.setGroupList(templateGroup.getGroupList());
        return req;
    }

    @Override
    public ResultPageBean pageQueryTemp(PortalInfoQueryReq req) {
        //获取全部租户和部分租户可见的门户模版
        List<TemplateBench> portalTempList =templateInfoService.queryVisibleTempList(Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal());
        //查询门户列表
        List<TemplatePortalInfo> portalInfoList =new ArrayList<>();
        if(CollectionUtils.isNotEmpty(portalTempList)){
            List<Long> tempIdList = portalTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            portalInfoList=templatePortalInfoMapper.selectByISV(req,tempIdList);
        }
        //组装缩略图地址
        for (TemplatePortalInfo portalInfo : portalInfoList) {
            if (StringUtils.isNotEmpty(portalInfo.getPortalImgId())) {
                String portalImgUrl = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + portalInfo.getPortalImgId();
                portalInfo.setPortalImgUrl(portalImgUrl);
            }
        }
        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(portalInfoList.stream()
                .skip((req.getPageNum() - 1) * req.getPageSize().longValue())
                .limit(req.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                req.getPageNum(), req.getPageSize(), portalInfoList.size())));
        return resultPageBean;
    }

}