package com.digiwin.athena.semc.service.temp.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.temp.TemplateBenchCustom;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustomImport;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomImportMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemDataMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemSourceMapper;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.impl.SystemCustomWriteHandler;
import com.digiwin.athena.semc.service.temp.TemplateSystemCustomService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemCustomQueryVO;
import com.digiwin.athena.semc.vo.portal.SystemCustomExportVo;
import com.digiwin.athena.semc.vo.portal.SystemCustomImportVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service
public class TemplateSystemCustomServiceImpl extends ServiceImpl<TemplateSystemCustomMapper, TemplateSystemCustom> implements TemplateSystemCustomService {

    @Resource
    MessageUtils messageUtils;

    @Resource
    TemplateSystemCustomMapper templateSystemCustomMapper;

    @Resource
    TemplateSystemSourceMapper templateSystemSourceMapper;

    @Autowired
    TemplateSystemDataMapper templateStystemDataMapper;

    @Autowired
    TemplatePortalInfoContentMapper templatePortalInfoContentMapper;

    @Autowired
    MdcService mdcService;

    @Resource
    private IImportRecordService importRecordService;

    @Resource
    private EnvProperties envProperties;

    @Resource
    private TemplateSystemCustomImportMapper templateSystemCustomImportMapper;

    @Resource
    TemplateBenchCustomMapper templateBenchCustomMapper;

    @Resource
    private Converter converter;


    /**
     * 经典门户图标数量
     */
    public static final int CLASSIC_ICON_COUNT = 20;

    @Override
    public ResultPageBean pageQuery(LabelSystemCustomQueryReq labelSystemCustomQueryReq) {
        ResultPageBean resultPageBean;
            LambdaQueryWrapper<TemplateSystemCustom> queryPreWrapper = new LambdaQueryWrapper<>();
            queryPreWrapper.eq(TemplateSystemCustom::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryPreWrapper.like(!StringUtils.isEmpty(labelSystemCustomQueryReq.getQueryCondition().getNameZh()),TemplateSystemCustom::getNameZh,
                    labelSystemCustomQueryReq.getQueryCondition().getNameZh());
            queryPreWrapper.eq(!Objects.isNull(labelSystemCustomQueryReq.getQueryCondition().getValidStatus()),TemplateSystemCustom::getValidStatus,
                    labelSystemCustomQueryReq.getQueryCondition().getValidStatus());
            queryPreWrapper.in(!CollectionUtils.isEmpty(labelSystemCustomQueryReq.getQueryCondition().getDataCategory()),TemplateSystemCustom::getDataCategory,
                    labelSystemCustomQueryReq.getQueryCondition().getDataCategory());

            // 查找自定义组件信息
            List<TemplateSystemCustom> labelSystemCustomList = templateSystemCustomMapper.selectList(queryPreWrapper);
            if (!CollectionUtils.isEmpty(labelSystemCustomList)) {
                Gson gson = new Gson();
                // 查询数据源信息
                List<JSONObject> labelSystemSourceList = templateSystemSourceMapper.listByCondition(
                        AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(),0,
                        labelSystemCustomList.stream().map(TemplateSystemCustom::getId).collect(Collectors.toList()));

                List<LabelSystemCustomQueryVO.DataSourceInfo> dataSourceInfoList = new LinkedList<>();
                labelSystemSourceList.forEach(item->{
                    LabelSystemCustomQueryVO.DataSourceInfo dataSourceInfo = gson.fromJson(JSON.toJSONString(item),LabelSystemCustomQueryVO.DataSourceInfo.class);
                    dataSourceInfoList.add(dataSourceInfo);
                });

                Map<Long,List<LabelSystemCustomQueryVO.DataSourceInfo>> map
                        = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemCustomQueryVO.DataSourceInfo::getSystemId));

                List<LabelSystemCustomQueryVO> labelSystemCustomQueryVOList = labelSystemCustomList.stream()
                        .map(item->{
                            LabelSystemCustomQueryVO labelSystemCustomQueryVO = converter.convert(item, LabelSystemCustomQueryVO.class);
                            List<LabelSystemCustomQueryVO.DataSourceInfo> dataList = map.get(item.getId());
                            labelSystemCustomQueryVO.setComponentSource(0);
                            labelSystemCustomQueryVO.setDataSourceInfo(dataList);

                            return labelSystemCustomQueryVO;
                        }).collect(Collectors.toList());
                List<LabelSystemCustomQueryVO> LabelSystemCustomQuerySortVO = labelSystemCustomQueryVOList.stream()
                        .sorted(Comparator.comparing(LabelSystemCustomQueryVO::getModifyTime).reversed()).collect(Collectors.toList());

                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(LabelSystemCustomQuerySortVO.stream()
                        .skip((labelSystemCustomQueryReq.getPageNum() - 1) * labelSystemCustomQueryReq.getPageSize().longValue())
                        .limit(labelSystemCustomQueryReq.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                        labelSystemCustomQueryReq.getPageNum(), labelSystemCustomQueryReq.getPageSize(), LabelSystemCustomQuerySortVO.size())));
            } else {
                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(labelSystemCustomList, PageInfo.getPageInfo(
                        labelSystemCustomQueryReq.getPageNum(), labelSystemCustomQueryReq.getPageSize(), labelSystemCustomList.size())));
            }
        return resultPageBean;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> save(LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        ResponseEntity<?> responseEntity = this.validData(labelSystemCustomSaveReq);
        if (null != responseEntity) {
            return responseEntity;
        }
        if (Objects.isNull(labelSystemCustomSaveReq.getId())) {
            TemplateSystemCustom labelSystemCustom = converter.convert(labelSystemCustomSaveReq, TemplateSystemCustom.class);
            labelSystemCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            labelSystemCustom.setValidStatus(0);
            labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            labelSystemCustom.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            if (Constants.COUNT_COMPOENT_TYPE.equals(labelSystemCustom.getDataCategory())) {
                labelSystemCustom.setClassicsIcon(labelSystemCustomSaveReq.getClassicsIcon());
            }
            templateSystemCustomMapper.insert(labelSystemCustom);

            if (!CollectionUtils.isEmpty(labelSystemCustomSaveReq.getDataSourceInfo())) {
                List<TemplateSystemSource> labelSystemSourceList = labelSystemCustomSaveReq.getDataSourceInfo().stream()
                        .map(item -> {
                            TemplateSystemSource labelSystemSource = converter.convert(item, TemplateSystemSource.class);
                            labelSystemSource.setSystemId(labelSystemCustom.getId());
                            labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                            return labelSystemSource;
                        }).collect(Collectors.toList());

                templateSystemSourceMapper.insertBatch(labelSystemSourceList);
            }

            return ResponseEntityWrapper.wrapperOk(labelSystemCustom.getId());

        } else {

            TemplateSystemCustom labelSystemCustom = converter.convert(labelSystemCustomSaveReq, TemplateSystemCustom.class);
            labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            templateSystemCustomMapper.updateById(labelSystemCustom);

            if (!CollectionUtils.isEmpty(labelSystemCustomSaveReq.getDataSourceInfo())) {
                LambdaUpdateWrapper<TemplateSystemSource> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(TemplateSystemSource::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                updateWrapper.in(TemplateSystemSource::getSystemId,
                        labelSystemCustomSaveReq.getDataSourceInfo().stream().map(LabelSystemCustomSaveReq.DataSourceInfo::getSystemId)
                                .collect(Collectors.toList()));
                templateSystemSourceMapper.delete(updateWrapper);

                List<TemplateSystemSource> labelSystemSourceList = labelSystemCustomSaveReq.getDataSourceInfo().stream()
                        .map(item -> {
                            TemplateSystemSource labelSystemSource = converter.convert(item, TemplateSystemSource.class);
                            labelSystemSource.setSystemId(labelSystemCustomSaveReq.getId());
                            labelSystemSource.setComponentSource(0);
                            labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                            return labelSystemSource;
                        }).collect(Collectors.toList());

                templateSystemSourceMapper.insertItemBatch(labelSystemSourceList);
            }
            return ResponseEntityWrapper.wrapperOk(labelSystemCustomSaveReq.getId());
        }
    }


    /**
     *  校验自定义组件名称重复 以及 数据源类型是否相同
     * @param labelSystemCustomSaveReq
     * @return
     */
    private ResponseEntity<?> validData (LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        // 编辑
        if (Objects.nonNull(labelSystemCustomSaveReq.getId())) {
            LambdaQueryWrapper<TemplateSystemCustom> queryWrapperById = new LambdaQueryWrapper<>();
            queryWrapperById.eq(TemplateSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapperById.eq(TemplateSystemCustom::getId,labelSystemCustomSaveReq.getId());
            TemplateSystemCustom labelSystemCustom = templateSystemCustomMapper.selectOne(queryWrapperById);

            LambdaQueryWrapper<TemplateSystemCustom> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(TemplateSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            List<TemplateSystemCustom> labelSystemCustomList = templateSystemCustomMapper.selectList(queryWrapper);

            if(!labelSystemCustomSaveReq.getNameZh().trim().equals(labelSystemCustom.getNameZh())) {
                // 再去判断和其他数据是否重复
                for (TemplateSystemCustom data : labelSystemCustomList) {
                    if(labelSystemCustomSaveReq.getNameZh().trim().equals(data.getNameZh())) {
                        String error = String.format(messageUtils.getMessage("error.message.system.custom.name.zh.exist"), labelSystemCustomSaveReq.getNameZh());
                        return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
                    }
                }
            }

        } else {
            LambdaQueryWrapper<TemplateSystemCustom> queryZhWrapper = new LambdaQueryWrapper<>();
            queryZhWrapper.eq(TemplateSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryZhWrapper.eq(TemplateSystemCustom::getNameZh,labelSystemCustomSaveReq.getNameZh());
            List<TemplateSystemCustom> labelSystemCustomZh = templateSystemCustomMapper.selectList(queryZhWrapper);

            LambdaQueryWrapper<TemplateSystemCustom> queryUsWrapper = new LambdaQueryWrapper<>();
            queryUsWrapper.eq(TemplateSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryUsWrapper.eq(TemplateSystemCustom::getNameUs,labelSystemCustomSaveReq.getNameUs());
            List<TemplateSystemCustom> labelSystemCustomUs = templateSystemCustomMapper.selectList(queryUsWrapper);
            // 新增
            if (labelSystemCustomZh.size() >= 1){
                String error = String.format(messageUtils.getMessage("error.message.system.custom.name.zh.exist"), labelSystemCustomSaveReq.getNameZh());
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }
            if (labelSystemCustomUs.size() >= 1){
                String error = String.format(messageUtils.getMessage("error.message.system.custom.name.us.exist"), labelSystemCustomSaveReq.getNameUs());
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }
        }

        // 判断组件的组件分类值与数据源分类值是否相同
        for (LabelSystemCustomSaveReq.DataSourceInfo item : labelSystemCustomSaveReq.getDataSourceInfo()) {
            LambdaQueryWrapper<TemplateSystemData> queryWrapperData = new LambdaQueryWrapper<>();
            queryWrapperData.eq(TemplateSystemData::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapperData.eq(TemplateSystemData::getId,item.getDataId());
            TemplateSystemData labelSystemData = templateStystemDataMapper.selectOne(queryWrapperData);

            if (!labelSystemData.getDataCategory().equals(labelSystemCustomSaveReq.getDataCategory())) {
                String error = messageUtils.getMessage("error.message.system.pre.dara.fail");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, error);
            }
        }
        return null;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> delete(List<Long> idList) {
        LambdaQueryWrapper<TemplateSystemCustom> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TemplateSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (idList.size() == 1) {
            queryWrapper.eq(TemplateSystemCustom::getId,idList.get(0));
            queryWrapper.eq(TemplateSystemCustom::getValidStatus,0);
            TemplateSystemCustom labelSystemCustom = templateSystemCustomMapper.selectOne(queryWrapper);
            if (ObjectUtils.isEmpty(labelSystemCustom)) {
                String error = messageUtils.getMessage("error.message.system.custom.del.fail");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }
        } else {
            queryWrapper.in(TemplateSystemCustom::getId,idList);
            List<TemplateSystemCustom> labelSystemCustom = templateSystemCustomMapper.selectList(queryWrapper);
            boolean flag = labelSystemCustom.stream().anyMatch(item->Constants.LABEL_SYSTEM_PRE_VALID_STATUS.equals(item.getValidStatus()));
            if (flag) {
                String error = messageUtils.getMessage("error.message.system.custom.batdel.fail");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }
        }
        //校验是否有经典门户关联
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List<TemplatePortalInfoContent> contentList=templatePortalInfoContentMapper.selPortalConent(tenantId,idList,Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isNotEmpty(contentList)) {
            String error = messageUtils.getMessage("error.message.jd.portal.layout.del.error");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
        }
        //查询是否有作业关联
        List<TemplateBenchCustom> jobBenchCustomList = templateBenchCustomMapper.selectBenchBy(null,idList);
        if (CollectionUtils.isNotEmpty(jobBenchCustomList)) {
            String error = messageUtils.getMessage("error.message.job.system.data.del.error");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
        templateSystemCustomMapper.deleteBatchIds(idList);
        //删除自定义组件和数据源关系
        LambdaUpdateWrapper<TemplateSystemSource> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(TemplateSystemSource::getSystemId,idList);
        updateWrapper.eq(TemplateSystemSource::getComponentSource,Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
        templateSystemSourceMapper.delete(updateWrapper);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    public List<TemplateSystemCustom> queryCustomSystem(LabelSystemAllVo req) {
        QueryWrapper<TemplateSystemCustom> condition = new QueryWrapper<>();
        if(CollectionUtils.isNotEmpty(req.getDataCategoryList())){
            condition.in("data_category",req.getDataCategoryList());
        }
        if(StringUtils.isNotEmpty(req.getName())){
            condition.like("name_zh", req.getName());
        }
        condition.eq("valid_status",1);
        condition.orderByDesc("modify_time");
        return templateSystemCustomMapper.selectList(condition);
    }

    @Override
    public List<SystemCustomImportVo> readExcel(String fileId) {
        DMC dmcInstance = mdcService.buildDmc();
        List<SystemCustomImportVo> excelVoList;
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            // 读取sheet
            ExcelReader excelReader = EasyExcelFactory.read(input).build();
            excelReader.read(EasyExcelFactory.readSheet(0).head(SystemCustomImportVo.class).headRowNumber(2).registerReadListener(excelListener).build());
            // 这里千万别忘记关闭，读的
            excelReader.finish();
            excelVoList = mdcService.doReadSync(excelListener);
        } catch (Exception e) {
            log.error("SystemDataImport read excel occur error", e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Override
    @Transactional
    public ImportExcelResp importReport(List<SystemCustomImportVo> customImportVoList) {
        ImportExcelResp excelResp=new ImportExcelResp();
        //数据库中自定义组件名称
        List<String> customNameList = new ArrayList<>();
        Map<String,TemplateSystemData> systemDataMap=new HashMap<>();
        //查询数据源信息
        List<TemplateSystemData> systemDataList = templateStystemDataMapper.selectList(new QueryWrapper<TemplateSystemData>());
        if (CollectionUtils.isNotEmpty(systemDataList)) {
            systemDataMap =systemDataList.stream().collect(Collectors.toMap(TemplateSystemData::getName, Function.identity(), (a, b) -> a));
        }
        //查询自定义组件
        List<TemplateSystemCustom> systemCustomList=templateSystemCustomMapper.selectList(new QueryWrapper<TemplateSystemCustom>());
        if (CollectionUtils.isNotEmpty(systemCustomList)) {
            customNameList = systemCustomList.stream().map(TemplateSystemCustom::getNameZh).collect(Collectors.toList());
        }

        //初始化分类map
        Map<String,Integer> categoryMap=initCategoryMap();
        //初始化状态
        Map<String,Integer> statusMap=initStatusMap();
        int successNum = 0;
        int failNum = 0;
        int iconIndex=0;
        int classIconAppIndex=1;
        int classIconJobIndex=1;
        for (SystemCustomImportVo customImportVo : customImportVoList) {
            // 基础校验
            StringBuilder errorSb = validateData(customImportVo,customNameList,systemDataMap,categoryMap);
            if (StringUtils.isNotBlank(errorSb.toString())) {
                failNum++;
                customImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            customImportVo.setFailDesc(errorSb.toString());
            //插入自定义组件
            TemplateSystemCustom systemCustom=initLabelCustom(customImportVo,systemDataMap,categoryMap,statusMap,iconIndex,classIconAppIndex,classIconJobIndex);
            successNum++;
            iconIndex++;
            //作业-经典门户图标
            if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
                classIconJobIndex++;
            }
            //应用-经典门户图标
            if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
                classIconAppIndex++;
            }
            //极简门户图标，如果大于7，则取第一个
            if (iconIndex >= 7) {
                iconIndex = 0;
            }
            //经典门户应用图标下标索引，如果大于20，则取第一个
            if (classIconAppIndex > CLASSIC_ICON_COUNT) {
                classIconAppIndex = 1;
            }
            //经典门户作业图标下标索引，如果大于20，则取第一个
            if (classIconJobIndex > CLASSIC_ICON_COUNT) {
                classIconJobIndex = 1;
            }
        }
        String nowTime= DateUtils.getNowTime(DateUtils.DATE_TIME_FORMATTER);
        //生成失败的excel文件
        ShareInfo shareInfo = importRecordService.uploadExcel(write(customImportVoList,nowTime));
        //初始化导入记录
        initDataImport(shareInfo.getFileId(),successNum,failNum,nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        // 构建返回信息
        String resultCode;
        if (successNum > 0 && failNum == 0) {
            resultCode = "2001";
        } else if (successNum > 0 && failNum > 0) {
            resultCode = "2002";
        } else if (successNum == 0 && failNum > 0) {
            resultCode = "2003";
        } else {
            resultCode = "2003";
        }
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(failNum);
        excelResp.setSuccessCount(successNum);
        return excelResp;
    }

    /**
     * 初始化数据源导入记录
     * @param fileId
     * @param successCount
     * @param failCount
     * @return
     */
    public TemplateSystemCustomImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime){
        TemplateSystemCustomImport importRecord=new TemplateSystemCustomImport();
        importRecord.setFileId(fileId);
        importRecord.setSuccessCount(successCount);
        importRecord.setFailCount(failCount);
        importRecord.setCreateUserName(Utils.getUserName());
        importRecord.setCreateUserId(Utils.getUserId());
        importRecord.setCreateTime(DateUtils.getDateFormat(nowTime,DateUtils.DATE_TIME_FORMATTER,DateUtils.DATE_TIME_NORMAL_FORMATTER));
        importRecord.setModifyTime(DateUtils.getDateFormat(nowTime,DateUtils.DATE_TIME_FORMATTER,DateUtils.DATE_TIME_NORMAL_FORMATTER));
        importRecord.setModifyUserId(Utils.getUserId());
        importRecord.setTenantId(Utils.getTenantId());
        templateSystemCustomImportMapper.insert(importRecord);
        return importRecord;
    }

    /**
     * 写入excel文件
     *
     * @param list 报表数据
     * @return
     */
    public File write(List<SystemCustomImportVo> list,String nowTime) {
        File file = new File("自定义组件导入记录_"+nowTime+".xlsx");
        EasyExcel.write(file, SystemCustomImportVo.class).relativeHeadRowIndex(1)
                .registerWriteHandler(new SystemCustomWriteHandler())
                .registerWriteHandler(Utils.initHorizontalCell())
                .sheet("自定义组件").doWrite(list);
        return file;
    }
    /**
     * 组装待插入的数据源数据数据
     * @param customImportVo excel中的数据
     * @param systemDataMap 数据源信息map
     * @param categoryMap 分类信息map
     * @param statusMap 状态map
     * @param iconIndex 极简门户图标的下标，7个图标里顺序取
     * @param classIconAppIndex 经典门户应用图标的下标，5个，1-5
     * @return classIconJobIndex 经典门户作业图标的下标，5个，1-5
     */
    public TemplateSystemCustom initLabelCustom(SystemCustomImportVo customImportVo ,
                                             Map<String,TemplateSystemData> systemDataMap,
                                             Map<String,Integer> categoryMap,
                                             Map<String,Integer> statusMap,
                                             int iconIndex,int classIconAppIndex,
                                             int classIconJobIndex
                                             ) {
        //组装自定义组件的数据
        TemplateSystemCustom systemCustom = new TemplateSystemCustom();
        systemCustom.setNameZh(customImportVo.getNameZh());
        systemCustom.setRemark(customImportVo.getRemark());
        systemCustom.setDataCategory(categoryMap.get(customImportVo.getDataCategory()));
        systemCustom.setValidStatus(statusMap.get(customImportVo.getValidStatus()));
        systemCustom.setCreateUserName(Utils.getUserName());
        systemCustom.setModifyUserName(Utils.getUserName());
        systemCustom.setCreateUserId(Utils.getUserId());
        systemCustom.setCreateTime(DateUtils.getNowTime(""));
        systemCustom.setModifyTime(DateUtils.getNowTime(""));
        systemCustom.setModifyUserId(Utils.getUserId());
        systemCustom.setTenantId(Utils.getTenantId());
        systemCustom.setIcon(Utils.getPortCard(iconIndex));
        //作业-经典门户图标
        if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
            systemCustom.setClassicsIcon(Constants.ICON_TZZY_JOB + classIconJobIndex);
        }
        //应用-经典门户图标
        if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
            systemCustom.setClassicsIcon(Constants.ICON_TZYY_APP + classIconAppIndex);
        }
        templateSystemCustomMapper.insert(systemCustom);
        TemplateSystemData systemData = systemDataMap.get(customImportVo.getDataName());
        if (null != systemData) {
            //插入组件和数据源的关系
            TemplateSystemSource systemSource = new TemplateSystemSource();
            systemSource.setSystemId(systemCustom.getId());
            systemSource.setDataId(systemData.getId());
            systemSource.setComponentSource(0);
            systemSource.setCreateTime(DateUtils.getNowTime(""));
            systemSource.setTenantId(Utils.getTenantId());
            templateSystemSourceMapper.insert(systemSource);
        }
        return systemCustom;
    }


    /**
     * 校验excel数据
     * @param customImportVo excel中的数据
     * @param customNameList 数据库和excel中的自定义组件名称
     * @param systemDataMap 数据源信息map
     * @param categoryMap 初始化分类map
     * @return
     */
    private StringBuilder validateData(SystemCustomImportVo customImportVo , List<String> customNameList,Map<String,TemplateSystemData> systemDataMap,Map<String,Integer> categoryMap) {
        StringBuilder errorSb = new StringBuilder();
        //自定义组件名称校验
        if (StringUtils.isEmpty(customImportVo.getNameZh())) {
            errorSb.append("“自定义组件名称”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(customImportVo.getNameZh()) && customImportVo.getNameZh().length() > 40) {
            errorSb.append("“自定义组件名称”内容超过最大长度限制").append(",");
        }
        if (customNameList.contains(customImportVo.getNameZh())) {
            errorSb.append("“自定义组件名称”重复").append(",");
        }
        if (StringUtils.isNotEmpty(customImportVo.getNameZh())){
            customNameList.add(customImportVo.getNameZh());
        }
        //组件分类
        if (StringUtils.isEmpty(customImportVo.getDataCategory())) {
            errorSb.append("“组件分类”未填写").append(",");
        }
        List<String> categoryNameList =initCategoryNameList();
        if (StringUtils.isNotEmpty(customImportVo.getDataCategory()) && !categoryNameList.contains(customImportVo.getDataCategory())) {
            errorSb.append("“组件分类”值错误").append(",");
        }
        //状态校验
        if (StringUtils.isEmpty(customImportVo.getValidStatus())) {
            errorSb.append("“状态”未填写").append(",");
        }
        List<String> validStatusList =initValidStatusList();
        if (StringUtils.isNotEmpty(customImportVo.getValidStatus()) && !validStatusList.contains(customImportVo.getValidStatus())) {
            errorSb.append("“状态”值错误").append(",");
        }
        //备注校验
        if (StringUtils.isNotBlank(customImportVo.getRemark()) && customImportVo.getRemark().length() > 100) {
            errorSb.append("“自定义组件备注”内容超过最大长度限制").append(",");
        }
        //数据源校验
        if (StringUtils.isEmpty(customImportVo.getDataName())) {
            errorSb.append("“数据源名称”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(customImportVo.getDataName()) &&
                null == systemDataMap.get(customImportVo.getDataName())) {
            errorSb.append("“数据源名称”值错误").append(",");
        }

        if (StringUtils.isNotEmpty(customImportVo.getDataName()) &&
                StringUtils.isNotEmpty(customImportVo.getDataCategory()) &&
                null != systemDataMap.get(customImportVo.getDataName())) {
            TemplateSystemData systemData=systemDataMap.get(customImportVo.getDataName());
            if(!systemData.getDataCategory().equals(categoryMap.get(customImportVo.getDataCategory()))){
                errorSb.append("自定义组件类型与关联数据源类型不一致").append(",");
            }
        }
        if (StringUtils.isNotEmpty(customImportVo.getDataName()) &&
                null != systemDataMap.get(customImportVo.getDataName())) {
            TemplateSystemData systemData=systemDataMap.get(customImportVo.getDataName());
            //数据源没有开启
            if(systemData.getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)){
                errorSb.append("关联数据源未启用").append(",");
            }
        }
        return errorSb;
    }

    /**
     * 初始化分类Map,key:名称，val:枚举值
     * @return
     */
    public Map<String,Integer> initCategoryMap() {
        Map<String,Integer> categoryMap = new HashMap<>();
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal(),Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal(),Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        return categoryMap;
    }

    /**
     * 初始化状态Map,key:名称，val:枚举值
     * @return
     */
    public Map<String,Integer> initStatusMap() {
        Map<String,Integer> statusMap = new HashMap<>();
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal(),Constants.VALID_STATUS_ENABLE);
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal(),Constants.VALID_STATUS_UNUSABLE);
        return statusMap;
    }

    /**
     * 初始化分类Map,key:枚举值，val:名称
     * @return
     */
    public Map<Integer,String> initCategoryValMap() {
        Map<Integer,String> categoryMap = new HashMap<>();
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_WORK.getVal(),Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_APP.getVal(),Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryMap;
    }

    /**
     * 初始化状态Map,key:枚举值，val:名称
     * @return
     */
    public Map<Integer,String> initStatusValMap() {
        Map<Integer,String> statusMap = new HashMap<>();
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(),Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_REPORT.getVal(),Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        return statusMap;
    }

    /**
     * 初始化分类集合
     * @return
     */
    public List<String> initCategoryNameList() {
        List<String> categoryNameList = new ArrayList<>();
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryNameList;
    }

    /**
     * 初始化状态集合
     * @return
     */
    public List<String> initValidStatusList() {
        List<String> validStatusList = new ArrayList<>();
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        return validStatusList;
    }

    @Override
    public PageInfoResp<TemplateSystemCustomImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper<TemplateSystemCustomImport> condition = new QueryWrapper<>();
        if (StringUtils.isBlank(queryImportRecordReq.getStartTime()) || StringUtils.isBlank(queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER);
            condition.ge("create_time", DateUtils.addDate(currentDate, DateUtils.DATE_TIME_NORMAL_FORMATTER, -1, DateUtils.YEAR));
            condition.le("create_time", currentDate);
        } else {
            condition.ge("create_time", queryImportRecordReq.getStartTime());
            condition.le("create_time", queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty(queryImportRecordReq.getUserIdName())) {
            condition.and(i -> i.like("create_user_name", queryImportRecordReq.getUserIdName()).or().like("create_user_id", queryImportRecordReq.getUserIdName()));
        }
        condition.orderByDesc("create_time");
        PageInfoResp<TemplateSystemCustomImport> pageInfoResp = new PageInfoResp<>();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);
        Page<TemplateSystemCustomImport> pageResult = templateSystemCustomImportMapper.selectPage(new Page<>(queryImportRecordReq.getPageNum(), queryImportRecordReq.getPageSize()), condition);
        if (pageResult != null && CollectionUtils.isNotEmpty(pageResult.getRecords())) {
            // 拼接文件预览链接
            pageResult.getRecords().forEach(m-> m.setFileUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + m.getFileId().trim()));
            pageInfoResp.setList(pageResult.getRecords());
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        }
        else {
            pageInfoResp.setList(Lists.newArrayList());
        }
        return pageInfoResp;
    }

    @Override
    public List<SystemCustomExportVo> exportReport() {
        List<SystemCustomExportVo> customExportVoList = new ArrayList<>();
        //查询自定义组件-作业 和自定义组件-应用 分类的自定义组件
        LabelSystemAllVo req = new LabelSystemAllVo();
        List<Integer> dataCategoryList = new ArrayList<>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List<TemplateSystemCustom> systemCustomList = queryCustomList(req);
        if (CollectionUtils.isEmpty(systemCustomList)) {
            return customExportVoList;
        }
        List<Long> customIdList = systemCustomList.stream().map(TemplateSystemCustom::getId).collect(Collectors.toList());
        //查询预设组件和自定义组件关联的数据源
        List<TemplateSystemSource> systemSourcCusList = templateSystemSourceMapper.selBySystemIds(customIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty(systemSourcCusList)) {
            return customExportVoList;
        }
        Map<Long, Long> systemSourcMap = systemSourcCusList.stream().collect(Collectors.toMap(TemplateSystemSource::getSystemId, TemplateSystemSource::getDataId, (a, b) -> a));
        //查询数据源
        List<Long> dataIdList = systemSourcCusList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataIdList)) {
            return customExportVoList;
        }
        List<TemplateSystemData> systemDataList = templateStystemDataMapper.selByIds(dataIdList);
        Map<Long, TemplateSystemData> systemDataMap = systemDataList.stream().collect(Collectors.toMap(TemplateSystemData::getId, Function.identity()));

        //初始化分类map
        Map<Integer, String> categoryMap = initCategoryValMap();
        //初始化状态map
        Map<Integer, String> statusMap = initStatusValMap();
        for (TemplateSystemCustom systemCustom : systemCustomList) {
            SystemCustomExportVo customExport = new SystemCustomExportVo();
            customExport.setNameZh(systemCustom.getNameZh());
            customExport.setDataCategory(categoryMap.get(systemCustom.getDataCategory()));
            customExport.setValidStatus(statusMap.get(systemCustom.getValidStatus()));
            customExport.setRemark(systemCustom.getRemark());
            //获取组件对应的数据源ID
            Long dataId = systemSourcMap.get(systemCustom.getId());
            if (null  != dataId) {
                //获取数据源信息
                TemplateSystemData systemData = systemDataMap.get(dataId);
                if (null != systemData) {
                    customExport.setDataName(systemData.getName());
                }
            }
            customExportVoList.add(customExport);
        }
        return customExportVoList;
    }

    /**
     * 查询自定义组件
     * @param req
     * @return
     */
    @Override
    public List<TemplateSystemCustom> queryCustomList(LabelSystemAllVo req) {
        QueryWrapper<TemplateSystemCustom> condition = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(req.getDataCategoryList())) {
            condition.in("data_category", req.getDataCategoryList());
        }
        condition.orderByDesc("modify_time");
        return templateSystemCustomMapper.selectList(condition);
    }
}