package com.digiwin.athena.semc.service.temp.impl;

import com.google.gson.Gson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.RedisConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ComponentSourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataSourceUpdateReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreQueryReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.temp.TemplateBenchCustom;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemPre;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemDataMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemPreMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemSourceMapper;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.temp.TemplateSystemPreService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreQueryVO;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;



@Slf4j
@Service
public class TemplateSystemPreServiceImpl extends ServiceImpl<TemplateSystemPreMapper, TemplateSystemPre> implements TemplateSystemPreService {


    @Autowired
    MessageUtils messageUtils;

    @Autowired
    TemplateSystemPreMapper templateSystemPreMapper;

    @Autowired
    TemplateSystemSourceMapper templateSystemSourceMapper;

    @Autowired
    TemplateSystemDataMapper templateSystemDataMapper;

    @Autowired
    TemplateSystemCustomMapper templateSystemCustomMapper;

    @Autowired
    TemplateBenchCustomMapper templateBenchCustomMapper;

    @Autowired
    TemplatePortalInfoContentMapper templatePortalInfoContentMapper;

    @Resource
    private Converter converter;

    @Override
    public ResultPageBean pageQuery(LabelSystemPreQueryReq labelSystemPreQueryReq) {
        initPreData();
        List<TemplateSystemPre> systemPreList=selectByParam(labelSystemPreQueryReq);
        if ( CollectionUtils.isEmpty(systemPreList)) {
            return ResultPageBean.success(ResponseBody.getInstance(systemPreList, PageInfo.getPageInfo(
                    labelSystemPreQueryReq.getPageNum(), labelSystemPreQueryReq.getPageSize(), systemPreList.size())));
        }
        Gson gson = new Gson();
        // 查询数据源信息
        List<JSONObject> labelSystemSourceList = templateSystemSourceMapper.listByCondition(
                AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), 1,
                systemPreList.stream().map(TemplateSystemPre::getId).collect(Collectors.toList()));
        List<LabelSystemPreQueryVO.DataSourceInfo> dataSourceInfoList = new LinkedList<>();
        labelSystemSourceList.forEach(item -> {
            LabelSystemPreQueryVO.DataSourceInfo dataSourceInfo = gson.fromJson(JSON.toJSONString(item), LabelSystemPreQueryVO.DataSourceInfo.class);
            dataSourceInfoList.add(dataSourceInfo);
        });
        Map<Long, List<LabelSystemPreQueryVO.DataSourceInfo>> map
                = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemPreQueryVO.DataSourceInfo::getSystemId));
        List<LabelSystemPreQueryVO> labelSystemPreQueryEmptyList = new LinkedList<>();
        for(TemplateSystemPre systemPre:systemPreList){
            LabelSystemPreQueryVO labelSystemPreQueryVO = converter.convert(systemPre, LabelSystemPreQueryVO.class);
            labelSystemPreQueryVO.setComponentSource(ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            //需要卡死状态 且 不允许修改数据源的组件 更新信息返回空
            if (Constants.IsUseDataNum.USE_DATA_FALSE.getVal().equals(systemPre.getIsUseData())
                    && Constants.IsEnableTrueNum.ENABLE_TRUE.getVal().equals(systemPre.getIsEnableTrue())) {
                labelSystemPreQueryVO.setModifyUserName("");
                labelSystemPreQueryVO.setModifyUserId("");
                labelSystemPreQueryVO.setModifyTime("");
            }
            List<LabelSystemPreQueryVO.DataSourceInfo> dataList = map.get(systemPre.getId());
            labelSystemPreQueryVO.setDataSourceInfo(dataList);
            labelSystemPreQueryEmptyList.add(labelSystemPreQueryVO);
        }
        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(labelSystemPreQueryEmptyList.stream()
                .skip((labelSystemPreQueryReq.getPageNum() - 1) * labelSystemPreQueryReq.getPageSize().longValue())
                .limit(labelSystemPreQueryReq.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                labelSystemPreQueryReq.getPageNum(), labelSystemPreQueryReq.getPageSize(), labelSystemPreQueryEmptyList.size())));
        return resultPageBean;
    }


    /**
     * 条件查询预设组件且根据更新时间倒序
     * @param queryReq
     * @return
     */
    public List<TemplateSystemPre> selectByParam(LabelSystemPreQueryReq queryReq){
        QueryWrapper queryWrapper = new QueryWrapper<TemplateSystemPre>();
        queryWrapper.eq("tenant_id",Utils.getTenantId());
        queryWrapper.orderByDesc("modify_time");
        if ( StringUtils.isNotEmpty(queryReq.getQueryCondition().getName())) {
            queryWrapper.like("name",queryReq.getQueryCondition().getName());
        }
        if (null != queryReq.getQueryCondition().getValidStatus()) {
            queryWrapper.eq("valid_status",queryReq.getQueryCondition().getValidStatus());
        }
        if (CollectionUtils.isNotEmpty(queryReq.getQueryCondition().getDataCategory())) {
            queryWrapper.eq("data_category",queryReq.getQueryCondition().getDataCategory());
        }
        return  templateSystemPreMapper.selectList(queryWrapper);
    }


    /**
     * 获取预设组件或者自定义组件的分类
     * @param item
     * @param templateSystemPreMap 预设组件信息map
     * @param templateSystemCustomMap 自定义组件信息map
     * @return
     */
    public Integer getDataCategory(LabelSystemDataSourceUpdateReq.DataSourceInfo item,
                                   Map<Long,TemplateSystemPre> templateSystemPreMap,
                                   Map<Long,TemplateSystemCustom> templateSystemCustomMap) {
        Integer dataCategory = null;
        //预设组件
        if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(item.getComponentSource())) {
            TemplateSystemPre templateSystemPre = templateSystemPreMap.get(item.getSystemId());
            if (null == templateSystemPre) {
                templateSystemPre = templateSystemPreMapper.selectById(item.getSystemId());
                templateSystemPreMap.put(item.getSystemId(), templateSystemPre);
            }
            dataCategory = templateSystemPre.getDataCategory();
        } else {
            TemplateSystemCustom templateSystemCustom = templateSystemCustomMap.get(item.getSystemId());
            if (null == templateSystemCustom) {
                templateSystemCustom = templateSystemCustomMapper.selectById(item.getSystemId());
                templateSystemCustomMap.put(item.getSystemId(), templateSystemCustom);
            }
            dataCategory = templateSystemCustom.getDataCategory();
        }
        return dataCategory;
    }

    @Override
    @Transactional
    public ResponseEntity<?> updateDataSource(LabelSystemDataSourceUpdateReq labelSystemUpdateReq) {
        //预设组件map
        Map<Long, TemplateSystemPre> templateSystemPreMap = new HashMap<>();
        //自定义组件map
        Map<Long, TemplateSystemCustom> templateSystemCustomMap = new HashMap<>();
        //组件ID
        Long systemId = null;
        //组件类型
        Integer componentSource = null;
        //待保存的组件和数据源关系
        List<TemplateSystemSource> templateSystemSourceList = new ArrayList<>();
        // 判断组件的组件分类值与数据源分类值是否相同
        for (LabelSystemDataSourceUpdateReq.DataSourceInfo item : labelSystemUpdateReq.getDataSourceInfo()) {
            systemId = item.getSystemId();
            componentSource = item.getComponentSource();
            //数据源为空
            if(null == item.getDataId()){
                continue;
            }
            TemplateSystemData labelSystemData = templateSystemDataMapper.selectById(item.getDataId());
            Integer dataCategory = getDataCategory(item, templateSystemPreMap, templateSystemCustomMap);
            if (null != dataCategory && !labelSystemData.getDataCategory().equals(dataCategory)) {
                String error = messageUtils.getMessage("error.message.system.pre.dara.fail");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, error);
            }
            TemplateSystemSource templateSystemSource = converter.convert(item, TemplateSystemSource.class);
            templateSystemSource.setTenantId(Utils.getTenantId());
            templateSystemSource.setCreateTime(DateUtils.getNowTime(""));
            templateSystemSource.setCreateUserId(Utils.getUserId());
            templateSystemSourceList.add(templateSystemSource);
        }
        //先删除该组件关联的数据源
        templateSystemSourceMapper.delByDataIds(null, systemId, componentSource);
        //更新预设组件和自定义组件的更新人
        if (CollectionUtils.isNotEmpty(labelSystemUpdateReq.getDataSourceInfo())) {
            initUserName(labelSystemUpdateReq.getDataSourceInfo().get(0));
        }
        //保存该组件关联的数据源
        if (CollectionUtils.isNotEmpty(templateSystemSourceList)) {
            templateSystemSourceMapper.insertBatch(templateSystemSourceList);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 更新预设组件和自定义组件的更新人
     *
     * @param dataSourceInfo
     */
    public void initUserName(LabelSystemDataSourceUpdateReq.DataSourceInfo dataSourceInfo) {
        //自定义组件
        if (dataSourceInfo.getComponentSource().equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
            TemplateSystemCustom labelSystemCustom = new TemplateSystemCustom();
            labelSystemCustom.setId(dataSourceInfo.getSystemId());
            labelSystemCustom.setModifyUserName(Utils.getUserName());
            labelSystemCustom.setModifyUserId(Utils.getUserId());
            labelSystemCustom.setModifyTime(DateUtils.getNowTime(""));
            templateSystemCustomMapper.updateById(labelSystemCustom);
        }
        //预设组件
        if (dataSourceInfo.getComponentSource().equals(Constants.LabelTypeEnum.SYSTEM_PRE.getVal())) {
            TemplateSystemPre labelSystemPre = new TemplateSystemPre();
            labelSystemPre.setId(dataSourceInfo.getSystemId());
            labelSystemPre.setModifyUserName(Utils.getUserName());
            labelSystemPre.setModifyUserId(Utils.getUserId());
            labelSystemPre.setModifyTime(DateUtils.getNowTime(""));
            templateSystemPreMapper.updateById(labelSystemPre);
        }
    }

    @Override
    @Transactional
    public ResponseEntity<?> updateValidStatus(Long id, Integer validStatus, Integer componentSource) {
        //查询是否有经典门户关联
        List<Long> systemIdList = new ArrayList<>();
        systemIdList.add(id);
        List<TemplatePortalInfoContent> contentList = templatePortalInfoContentMapper.selPortalConent(Utils.getTenantId(), systemIdList, componentSource);
        //自定义组件
        if (componentSource.equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
            //校验是否有经典门户关联
            if (CollectionUtils.isNotEmpty(contentList) && validStatus.equals(Constants.ValidStatusEnum.VALID_STATUS_ON.getVal())) {
                String error = messageUtils.getMessage("error.message.jd.portal.layout.stop.error");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
            }
            //自定义组件停用时 查询是否有作业关联
            List<Long> idList = new ArrayList<>();
            idList.add(id);
            List<TemplateBenchCustom> tempBenchCustomList = templateBenchCustomMapper.selectBenchBy(null, idList);
            if (CollectionUtils.isNotEmpty(tempBenchCustomList) && validStatus.equals(Constants.ValidStatusEnum.VALID_STATUS_ON.getVal())) {
                String error = messageUtils.getMessage("error.message.job.system.data.stop.error");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
            }
            // 启用的时候判断数据信息是否完整
            if (validStatus.equals(Constants.ValidStatusEnum.VALID_STATUS_OFF.getVal())) {
                List<JSONObject> jsonObjectList = templateSystemSourceMapper.listBySystemId(Utils.getTenantId(), id, componentSource);
                if (CollectionUtils.isEmpty(jsonObjectList)) {
                    String error = messageUtils.getMessage("error.message.system.pre.incomplete.fail");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                }
            }
        }
        //预设组件停用校验是否有布局关联
        if (componentSource.equals(Constants.LabelTypeEnum.SYSTEM_PRE.getVal())) {
            TemplateSystemPre systemPre = templateSystemPreMapper.selectById(id);
            if (systemPre == null) {
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, "component does not exist!");
            }
            if (!Constants.DataTypeEnum.TYPE_TODO.getVal().equals(systemPre.getDataType())) {
                //校验是否有经典门户关联
                if (!systemPre.getDataType().equals(Constants.DataTypeEnum.TYPE_INFO.getVal()) && CollectionUtils.isNotEmpty(contentList) && 0 == validStatus) {
                    String error = messageUtils.getMessage("error.message.jd.portal.layout.stop.error");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                }
            }
            // 启用的时候判断数据信息是否完整
            if (validStatus.equals(Constants.ValidStatusEnum.VALID_STATUS_OFF.getVal())
                    && !systemPre.getDataType().equals(Constants.DataTypeEnum.TYPE_INFO.getVal())) {
                List<JSONObject> jsonObjectList = templateSystemSourceMapper.listBySystemId(Utils.getTenantId(), id, componentSource);
                if (CollectionUtils.isEmpty(jsonObjectList)) {
                    String error = messageUtils.getMessage("error.message.system.pre.incomplete.fail");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                }
            }
        }

        // 预设组件
        if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(componentSource)) {
            TemplateSystemPre templateSystemPre = new TemplateSystemPre();
            templateSystemPre.setId(id);
            templateSystemPre.setValidStatus(validStatus);
            templateSystemPre.setModifyUserName(Utils.getUserName());
            templateSystemPre.setModifyTime(DateUtils.getNowTime(""));
            templateSystemPreMapper.updateById(templateSystemPre);
        } else {
            // 自定义组件
            TemplateSystemCustom templateSystemCustom = new TemplateSystemCustom();
            templateSystemCustom.setId(id);
            templateSystemCustom.setValidStatus(validStatus);
            templateSystemCustom.setModifyUserName(Utils.getUserName());
            templateSystemCustom.setModifyTime(DateUtils.getNowTime(""));
            templateSystemCustomMapper.updateById(templateSystemCustom);
        }
        return ResponseEntityWrapper.wrapperOk();
    }


    @Override
    @Transactional
    public List<TemplateSystemPre> initPreData() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        //查询租户的数据
        List<TemplateSystemPre> labelSystemPreList = getInitData(tenantId);
        RedisLock redisLock = new RedisLock(RedisConstant.LABEL_SYSTEM_PRE_LOCK + tenantId);
        //分布式锁
        try {
            if(!redisLock.lock()){
                return labelSystemPreList;
            }
        } catch (InterruptedException e) {
            return labelSystemPreList;
        }
        try {
            //查询全局预设组件信息
            List<TemplateSystemPre> overSystemPreList = getInitData("");
            //待插入的预设组件
            List<TemplateSystemPre> insertPreList = new ArrayList<>();
            //该租户下没有预设组件，初始化全局的组件给该租户
            if (CollectionUtils.isEmpty(labelSystemPreList)) {
                insertPreList = overSystemPreList;
            } else {
                //比较数据库预设和租户下的预设组件，将新增的初始化
                //将租户下预设组件的数据转map
                Map<Integer, TemplateSystemPre> preListMap = labelSystemPreList.stream().collect(Collectors.toMap(TemplateSystemPre::getDataType, Function.identity(), (a, b) -> a));
                for (TemplateSystemPre overSystemPre : overSystemPreList) {
                    //如果租户的组件中没有该全局的组件，则需要插入
                    if (null == preListMap.get(overSystemPre.getDataType())) {
                        insertPreList.add(overSystemPre);
                    }
                }
            }
            //初始化租户的预设组件数据
            if (CollectionUtils.isNotEmpty(insertPreList)) {
                labelSystemPreList = batchSavePreData(insertPreList, tenantId);
            }
            //查询租户的数据
            labelSystemPreList = getInitData(tenantId);
            return labelSystemPreList;
        } catch (Exception e) {
            log.error("LabelSystemPre initPreData error", e);
        } finally {
            redisLock.unlock();
        }
        return labelSystemPreList;
    }

    @Override
    public TemplateSystemPre getPreSystemID(Integer dataType) {
        QueryWrapper queryWrapper = new QueryWrapper<LabelSystemPre>();
        queryWrapper.eq("tenant_id", Utils.getTenantId());
        queryWrapper.eq("data_type", dataType);
        List<TemplateSystemPre> labelSystemPreList = templateSystemPreMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(labelSystemPreList)) {
            return labelSystemPreList.get(0);
        }
        return null;
    }

    @Override
    public LabelSystemPreCustomVo queryAllSystem(LabelSystemAllVo req) {
        LabelSystemPreCustomVo preCustomVo = new LabelSystemPreCustomVo();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        //自定义组件
        List<LabelSystemAllVo> customList =  templateSystemPreMapper.queryCustomSystem(tenantId, req.getName(),req.getDataCategoryList());
        if (CollectionUtils.isNotEmpty(customList)) {
            preCustomVo.setCustomList(customList);
        }
        //预设组件
        List<LabelSystemAllVo> presetList = templateSystemPreMapper.queryPreSystem(tenantId, req.getName());
        if (CollectionUtils.isNotEmpty(presetList)) {
            presetList.forEach(x -> x.setName(Constants.THIRD_TO_DO_DESC.equals(x.getName()) ? Constants.TO_DO_DESC : x.getName()));
            preCustomVo.setPresetList(presetList);
        }
        return preCustomVo;
    }

    @Override
    public List<TemplateSystemPre> initDefPortal(List<Integer> dataCategoryList) {
        //先初始化预设组件
        List<TemplateSystemPre> preList=initPreData();
        preList=preList.stream().filter(item -> dataCategoryList.contains(item.getDataType())).collect(Collectors.toList());
        return preList;
    }

    /**
     * 初始化租户预设组件
     *
     * @param labelSystemPreList
     * @param tenantId
     * @return
     */
    public List<TemplateSystemPre> batchSavePreData(List<TemplateSystemPre> labelSystemPreList, String tenantId) {
        List<TemplateSystemPre> systemPreTenantList = new ArrayList<>();
        for (TemplateSystemPre labelSystemPre : labelSystemPreList) {
            TemplateSystemPre systemPreTenant = new TemplateSystemPre();
            BeanUtils.copyProperties(labelSystemPre, systemPreTenant);
            labelSystemPre.setTenantId(tenantId);
            labelSystemPre.setId(null);
            templateSystemPreMapper.insert(labelSystemPre);
            labelSystemPre.setId(labelSystemPre.getId());
            systemPreTenantList.add(labelSystemPre);
        }
        return systemPreTenantList;
    }

    /**
     * 查询租户为空的数据
     *
     * @return
     */
    public List<TemplateSystemPre> getInitData(String tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper<TemplateSystemPre>();
        if (StringUtils.isNotEmpty(tenantId)) {
            queryWrapper.eq("tenant_id", tenantId);
        } else {
            queryWrapper.isNull("tenant_id");
        }
        List<TemplateSystemPre> labelSystemPreList = templateSystemPreMapper.selectList(queryWrapper);
        return labelSystemPreList;
    }
}