package com.digiwin.athena.semc.service.temp.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;
import com.digiwin.athena.semc.entity.temp.TemplateUserTenant;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupItemMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupMapper;
import com.digiwin.athena.semc.service.temp.TemplateTenantGroupService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class TemplateTenantGroupServiceImpl extends ServiceImpl<TemplateTenantGroupMapper, TemplateTenantGroup> implements TemplateTenantGroupService {

    @Resource
    private TemplateTenantGroupMapper templateTenantGroupMapper;

    @Resource
    private TemplateTenantGroupItemMapper templateTenantGroupItemMapper;

    @Resource
    private TemplateInfoTenantMapper templateInfoTenantMapper;

    @Override
    @Transactional
    public Long saveTenantGroup(TemplateTenantGroup req) {
        req.setModifyTime(DateUtils.getNowTime(""));
        req.setModifyUserId(Utils.getUserId());
        req.setModifyUserName(Utils.getUserName());
        if(null == req.getId()){
            req.setTenantId(Utils.getTenantId());
            req.setCreateUserName(Utils.getUserName());
            req.setCreateUserId(Utils.getUserId());
            req.setCreateTime(DateUtils.getNowTime(""));
            req.setSubUserId(Utils.getUserId());
            req.setValidStatus(Constants.VALID_STATUS_ENABLE);
            templateTenantGroupMapper.insert(req);
        }else {
            templateTenantGroupMapper.updateById(req);
        }
        return  req.getId();
    }

    /**
     * 获取分组QueryWrapper
     * @return
     */
    public QueryWrapper getGroupWrapper(TemplateTenantGroup req) {
        QueryWrapper<TemplateTenantGroup> condition = new QueryWrapper<>();
        condition.orderByDesc("valid_status").orderByDesc("modify_time");
        if(StringUtils.isNotEmpty(req.getName())){
            condition.like("name", req.getName());
        }
        if(null !=req.getValidStatus()){
            condition.eq("valid_status", req.getValidStatus());
        }
        if(StringUtils.isNotEmpty(req.getCreateUserId())){
            condition.eq("sub_user_id", req.getCreateUserId());
        }
        return condition;
    }


    /**
     * 获取分组下租户QueryWrapper
     * @param groupId
     * @return
     */
    public QueryWrapper getGroupItemWrapper(Long groupId) {
        QueryWrapper<TemplateTenantGroupItem> condition = new QueryWrapper<>();
        condition.orderByDesc("id");
        if (null != groupId) {
            condition.eq("group_id", groupId);
        }
        return condition;
    }

    @Override
    @Transactional
    public Integer saveGroupTenant(TemplateTenantGroup req) {
        //查询数据库中分组下租户
        List<TemplateTenantGroupItem> tenantGroupItemList=templateTenantGroupItemMapper.selectList(getGroupItemWrapper(req.getId()));
        //租户信息map
        Map<String, TemplateTenantGroupItem> groupItemMap=new HashMap<>();
        if(CollectionUtils.isNotEmpty(tenantGroupItemList)){
            groupItemMap=tenantGroupItemList.stream().collect(Collectors.toMap(TemplateTenantGroupItem::getSubTenantId, Function.identity(), (a, b) -> a));
        }
        //已存在的租户
        List<Long> isExistIds = new ArrayList<>();
        //待插入的租户
        List<TemplateTenantGroupItem> addGroupItemList=new ArrayList<>();
        for(TemplateTenantGroupItem groupItem:req.getSubTenantList()) {
            TemplateTenantGroupItem groupItemDB = groupItemMap.get(groupItem.getSubTenantId());
            if (null == groupItemDB) {
                groupItem.setGroupId(req.getId());
                groupItem.setTenantId(Utils.getTenantId());
                groupItem.setCreateUserId(Utils.getUserId());
                groupItem.setCreateTime(DateUtils.getNowTime(""));
                groupItem.setModifyTime(DateUtils.getNowTime(""));
                groupItem.setModifyUserId(Utils.getUserId());
                addGroupItemList.add(groupItem);
                continue;
            }
            isExistIds.add(groupItemDB.getId());
        }
        //删除租户
        if(CollectionUtils.isNotEmpty(isExistIds)){
            templateTenantGroupItemMapper.delTenantBy(req.getId(),isExistIds);
        }
        //批量保存租户
        if(CollectionUtils.isNotEmpty(addGroupItemList)){
            templateTenantGroupItemMapper.batchInsert(addGroupItemList,req.getId());
        }
        return null;
    }

    @Override
    public List<TemplateTenantGroupItem> queryGroupTenant(Long groupId) {
        List<TemplateTenantGroupItem> tenantGroupItemList=templateTenantGroupItemMapper.selectList(getGroupItemWrapper(groupId));
        return tenantGroupItemList;
    }

    @Override
    public List<TemplateTenantGroup> selTenantGroup(TemplateTenantGroup req) {
        req.setCreateUserId(Utils.getUserId());
        List<TemplateTenantGroup> tenantGroupList=templateTenantGroupMapper.selectList(getGroupWrapper(req));
        return tenantGroupList;
    }

    @Override
    public ResultPageBean pageQueryGroupTenant(TemplateQueryReq req) {
        List<TemplateTenantGroupItem> tenantGroupItemList=templateTenantGroupItemMapper.selectByParam(req.getGroupId(),req.getTenantNameId());
        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(tenantGroupItemList.stream()
                .skip((req.getPageNum() - 1) * req.getPageSize().longValue())
                .limit(req.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                req.getPageNum(), req.getPageSize(), tenantGroupItemList.size())));
        return resultPageBean;
    }

    @Override
    @Transactional
    public Integer updateStatus(TemplateQueryReq req) {
        TemplateTenantGroup tenantGroup=new TemplateTenantGroup();
        tenantGroup.setValidStatus(req.getValidStatus());
        tenantGroup.setModifyTime(DateUtils.getNowTime(""));
        tenantGroup.setModifyUserId(Utils.getUserId());
        tenantGroup.setModifyUserName(Utils.getUserName());
        return  templateTenantGroupMapper.updateStatus(tenantGroup,req.getIdList());
    }

    @Override
    @Transactional
    public Integer delGroup(TemplateQueryReq req) {
        //删除分组
        templateTenantGroupMapper.deleteById(req.getId());
        //删除分组下租户
        templateTenantGroupItemMapper.delGroupItem(req.getId(),null);
        List<String> groupTenantIds=new ArrayList<>();
        groupTenantIds.add(req.getId()+"");
        //删除工作台和门户中涉及的部分租户
        templateInfoTenantMapper.delTenantBy("",groupTenantIds, Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag());
        return null;
    }

    @Override
    @Transactional
    public Integer delGroupTenant(List<Long> idList) {
        return templateTenantGroupItemMapper.deleteBatchIds(idList);
    }

    @Override
    public List<TemplateTenantGroup> selGroupBy(TemplateTenantGroup req) {
        QueryWrapper<TemplateTenantGroup> condition = new QueryWrapper<>();
        condition.eq("sub_user_id",Utils.getUserId());
        if(StringUtils.isNotEmpty(req.getName())){
            condition.eq("name", req.getName());
        }
        if(null !=req.getId()){
            condition.ne("id",req.getId());
        }
        return templateTenantGroupMapper.selectList(condition);
    }

}