package com.digiwin.athena.semc.service.temp.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.entity.temp.TemplateUserMapping;
import com.digiwin.athena.semc.entity.temp.TemplateUserTenant;
import com.digiwin.athena.semc.mapper.temp.*;
import com.digiwin.athena.semc.service.temp.TemplateUserMappingService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class TemplateUserMappingServiceImpl extends ServiceImpl<TemplateUserMappingMapper, TemplateUserMapping> implements TemplateUserMappingService {

    @Resource
    private TemplateUserMappingMapper templateUserMappingMapper;

    @Resource
    private TemplateUserTenantMapper templateUserTenantMapper;

    @Resource
    private TemplateTenantGroupMapper templateTenantGroupMapper;

    @Resource
    private TemplateTenantGroupItemMapper templateTenantGroupItemMapper;

    @Resource
    private TemplateInfoTenantMapper templateInfoTenantMapper;


    @Override
    public List<TemplateUserMapping> selAllMappingUser(String subUserNameId) {
        List<TemplateUserMapping> userMappingList=setectBy(null,subUserNameId);
        return userMappingList;
    }

    /**
     * 条件查询账号关联关系
     * @param userIdList
     * @return
     */
    public List<TemplateUserMapping> setectBy(List<String> userIdList,String subUserNameId) {
        QueryWrapper<TemplateUserMapping> condition = new QueryWrapper<>();
        condition.orderByDesc("modify_time").orderByDesc("id");
        if(CollectionUtils.isNotEmpty(userIdList)){
            condition.in("sub_user_id",userIdList);
        }
        if(StringUtils.isNotEmpty(subUserNameId)){
            condition.like("sub_user_id",subUserNameId).or().like("sub_user_name",subUserNameId);
        }
        List<TemplateUserMapping> userMappingList = templateUserMappingMapper.selectList(condition);
        return userMappingList;
    }

    /**
     * 条件查询账号下租户
     * @param mappingIdList
     * @return
     */
    public List<TemplateUserTenant> selectByTenant(List<Long> mappingIdList, List<Long> notInIdList, Long mappingId) {
        QueryWrapper<TemplateUserTenant> condition = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(mappingIdList)) {
            condition.in("mapping_id", mappingIdList);
        }
        if (CollectionUtils.isNotEmpty(notInIdList)) {
            condition.notIn("id", notInIdList);
        }
        if (null != mappingId) {
            condition.eq("mapping_id", mappingId);
        }
        List<TemplateUserTenant> userTenantList = templateUserTenantMapper.selectList(condition);
        return userTenantList;
    }

    @Override
    public ResultPageBean pageQueryUserTenant(TemplateQueryReq req) {
        List<TemplateUserTenant> userTenantList = templateUserTenantMapper.selectByParam(req.getId(),req.getTenantNameId());
        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(userTenantList.stream()
                .skip((req.getPageNum() - 1) * req.getPageSize().longValue())
                .limit(req.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                req.getPageNum(), req.getPageSize(), userTenantList.size())));
        return resultPageBean;
    }

    @Override
    public ResultPageBean pageLongUserTenant(TemplateQueryReq req) {
        List<String> userIdList = new ArrayList<>();
        userIdList.add(Utils.getUserId());
        //查询登录账号的关联关系信息
        List<TemplateUserMapping> userMappingList = setectBy(userIdList,"");
        if (CollectionUtils.isEmpty(userMappingList)) {
            ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(userMappingList.stream()
                    .skip((req.getPageNum() - 1) * req.getPageSize().longValue())
                    .limit(req.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                    req.getPageNum(), req.getPageSize(), userMappingList.size())));
            return resultPageBean;
        }
        req.setId(userMappingList.get(0).getId());
        return pageQueryUserTenant(req);
    }

    @Override
    public List<TemplateUserTenant> getLongUserTenant() {
        List<TemplateUserTenant> userTenantList = new ArrayList<>();
        List<String> userIdList = new ArrayList<>();
        userIdList.add(Utils.getUserId());
        //查询登录账号的关联关系信息
        List<TemplateUserMapping> userMappingList = setectBy(userIdList,"");
        if (CollectionUtils.isEmpty(userMappingList)) {
            return userTenantList;
        }
        userTenantList = queryUserAllTenant(userMappingList.get(0).getId());
        return userTenantList;
    }



    @Override
    public List<TemplateUserTenant> queryUserAllTenant(Long id) {
        return  templateUserTenantMapper.selectByParam( id,"");
    }

    @Transactional
    @Override
    public Integer saveUserTenant(List<TemplateUserMapping> mappingList) {
        //查询已保存的数据
        //获取订阅用户ID集合
        List<String> userIdList = mappingList.stream().map(TemplateUserMapping::getSubUserId).collect(Collectors.toList());
        List<TemplateUserMapping> userMappingList = setectBy(userIdList,"");
        //账号信息map
        Map<String, TemplateUserMapping> userMappingMap = new HashMap<>();
        //账号下租户map
        Map<String, TemplateUserTenant> userTenantMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(userMappingList)) {
            userMappingMap = userMappingList.stream().collect(Collectors.toMap(TemplateUserMapping::getSubUserId, Function.identity(), (a, b) -> a));
            //查询账号下租户
            List<Long> mappingIdList = userMappingList.stream().map(TemplateUserMapping::getId).collect(Collectors.toList());
            List<TemplateUserTenant> userTenantList = selectByTenant(mappingIdList, null, null);
            if (CollectionUtils.isNotEmpty(userTenantList)) {
                userTenantMap = userTenantList.stream().collect(Collectors.toMap(value -> value.getMappingId() + "-" + value.getSubTenantId(), value -> value, (key1, key2) -> key1));
            }
        }
        for (TemplateUserMapping mapping : mappingList) {
            TemplateUserMapping userMapping = userMappingMap.get(mapping.getSubUserId());
            //新增的账号
            if (null == userMapping) {
                mapping.setCreateUserId(Utils.getUserId());
                mapping.setCreateUserName(Utils.getUserName());
                mapping.setCreateTime(DateUtils.getNowTime(""));
                templateUserMappingMapper.insert(mapping);
                //插入账号下租户
                if (CollectionUtils.isNotEmpty(mapping.getSubTenantList())) {
                    templateUserTenantMapper.batchInsert(mapping.getSubTenantList(), mapping.getId());
                }
                continue;
            }
            //编辑账号的场景
            templateUserMappingMapper.updateById(userMapping);
            //已存在的账号下租户
            List<Long> isExistIds = new ArrayList<>();
            //需要保存的租户
            List<TemplateUserTenant> addTeanantList = new ArrayList<>();
            for (TemplateUserTenant userTenant : mapping.getSubTenantList()) {
                TemplateUserTenant userTenantDB = userTenantMap.get(userMapping.getId() + "-" + userTenant.getSubTenantId());
                if (null != userTenantDB) {
                    isExistIds.add(userTenantDB.getId());
                    continue;
                }
                addTeanantList.add(userTenant);
            }
            //查询需要删除的租户
            List<TemplateUserTenant> userTenantList = selectByTenant(null, isExistIds, userMapping.getId());
            //删除租户
            if (CollectionUtils.isNotEmpty(userTenantList)) {
                List<Long> delIdList = userTenantList.stream().map(TemplateUserTenant::getId).collect(Collectors.toList());
                templateUserTenantMapper.deleteBatchIds(delIdList);
            }
            //插入需要新增的租户
            if (CollectionUtils.isNotEmpty(addTeanantList)) {
                templateUserTenantMapper.batchInsert(addTeanantList, userMapping.getId());
            }
        }
        return null;
    }


    /**
     * 获取账号下租户QueryWrapper
     * @param mappingId
     * @return
     */
    public QueryWrapper getUserTenantWrapper(Long mappingId) {
        QueryWrapper<TemplateUserTenant> condition = new QueryWrapper<>();
        if (null != mappingId) {
            condition.eq("mapping_id", mappingId);
        }
        return condition;
    }


    @Override
    @Transactional
    public Integer delUserMapping(Long id) {
        //查询账号
        TemplateUserMapping userMapping = templateUserMappingMapper.selectById(id);
        if (null == userMapping) {
            return null;
        }
        //查询账号下租户
        List<TemplateUserTenant> userTenantList = templateUserTenantMapper.selectList(getUserTenantWrapper(id));
        //删除账号
        templateUserMappingMapper.deleteById(id);
        //删除账号下租户
        templateUserTenantMapper.delete(getUserTenantWrapper(id));
        //删除分组中涉及的租户
        List<TemplateTenantGroup> tenantGroupList = templateTenantGroupMapper.selectTenantGroup(userMapping.getSubUserId());
        if (CollectionUtils.isNotEmpty(tenantGroupList)) {
            List<Long> groupIdList = tenantGroupList.stream().map(TemplateTenantGroup::getId).collect(Collectors.toList());
            templateTenantGroupItemMapper.batDelGroupItem(groupIdList,null);
        }
        //删除工作台和门户中涉及的部分租户
        if (CollectionUtils.isNotEmpty(userTenantList)) {
            List<String> subTenantIdList = userTenantList.stream().map(TemplateUserTenant::getSubTenantId).collect(Collectors.toList());
            templateInfoTenantMapper.delTenantBy(userMapping.getSubUserId(),subTenantIdList, Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag());
        }
        return null;
    }

    @Override
    @Transactional
    public Integer delUserTenant(List<Long> idList) {
        //查询账号下租户
        List<TemplateUserTenant> userTenantList = templateUserTenantMapper.selectBatchIds(idList);
        if (CollectionUtils.isEmpty(userTenantList)) {
            return null;
        }
        //需要删除的租户id
        List<String> subTenantIdList = userTenantList.stream().map(TemplateUserTenant::getSubTenantId).collect(Collectors.toList());
        //查询账号
        TemplateUserMapping userMapping = templateUserMappingMapper.selectById(userTenantList.get(0).getMappingId());
        if (null == userMapping) {
            return null;
        }
        //删除账号下租户
        templateUserTenantMapper.deleteBatchIds(idList);
        //删除分组中涉及的租户
        List<TemplateTenantGroup> tenantGroupList = templateTenantGroupMapper.selectTenantGroup(userMapping.getSubUserId());
        if (CollectionUtils.isNotEmpty(tenantGroupList)) {
            List<Long> groupIdList = tenantGroupList.stream().map(TemplateTenantGroup::getId).collect(Collectors.toList());
            templateTenantGroupItemMapper.batDelGroupItem(groupIdList,subTenantIdList);
        }
        //删除工作台和门户中涉及的部分租户
         templateInfoTenantMapper.delTenantBy(userMapping.getSubUserId(),subTenantIdList, Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag());
        return null;
    }
}