package com.digiwin.athena.semc.service.tenant.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.annotate.AttributeExtraService;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.entity.tenant.TenantAttributeDef;
import com.digiwin.athena.semc.entity.tenant.TenantAttributeValue;
import com.digiwin.athena.semc.service.tenant.TenantAttributeExtraService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;


/**
 * @author guijf
 */
@Slf4j
@Service
public class TenantAttributeExtraServiceImpl implements TenantAttributeExtraService {

    @Resource
    protected MessageUtils messageUtils;

    public static final List<String> NANA_SHOW_WAY = Lists.newArrayList("suspension","embedded");

    @Override
    @AttributeExtraService(code = "nanaDisplayMode")
    public BaseResultDTO<Object> nanaShowWayCheck(TenantAttributeDef tenantAttributeDef, TenantAttributeValue tenantAttributeValue) {
        BaseResultDTO<Object> result = new BaseResultDTO<>();
        String nanaShowWay = tenantAttributeValue.getVarcharValue();
        if(!NANA_SHOW_WAY.contains(nanaShowWay)){
            log.info("TenantAttributeExtraService.nanaShowWayCheck param is illegal");
            result.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.setStatusDescription(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
            result.setErrorCode(String.valueOf(ErrorCodeConstant.PARAM_ILLEGAL_ERROR));
            result.setErrorMessage(messageUtils.getMessage(I18NKey.COMMON_PARAM_ILLEGAL));
            result.setResponse(false);
        }
        result.setStatus(HttpStatus.OK.value());
        result.setStatusDescription(HttpStatus.OK.getReasonPhrase());
        return result;
    }

}
