package com.digiwin.athena.semc.service.utils;


import com.digiwin.athena.semc.configuration.AppConfiguration;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class DynamicTenantLineHandlerUtil {
    private DynamicTenantLineHandlerUtil() {
    }

    public static <S> void ignoreTenantConsume(Consumer<S> consumer, S parameter) {
        try {
            AppConfiguration.DynamicTenantLineHandler.ignoreTenant();
            consumer.accept(parameter);
        } finally {
            AppConfiguration.DynamicTenantLineHandler.clear();
        }
    }

    public static <S, R> R ignoreTenantFunc(Function<S, R> function, S parameter) {
        try {
            AppConfiguration.DynamicTenantLineHandler.ignoreTenant();
            return function.apply(parameter);
        } finally {
            AppConfiguration.DynamicTenantLineHandler.clear();
        }
    }

    public static <R> R ignoreTenantSupplier(Supplier<R> supplier) {
        try {
            AppConfiguration.DynamicTenantLineHandler.ignoreTenant();
            return supplier.get();
        } finally {
            AppConfiguration.DynamicTenantLineHandler.clear();
        }
    }
}
