package com.digiwin.athena.semc.service.workbench.constant;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * workbench相关常量
 *
 * @author IPmas
 * @date 2025/8/26
 */
public abstract class WorkBenchConstant {
    private WorkBenchConstant() {
    }

    /**
     * PC端组件分类
     */
    public final static List<Integer> PC_CUSTOM_COMPONENT_IDS = Arrays.asList(3, 4, 6, 7, 8, 9, 10);

    /**
     * PC端标识
     */
    public final static String PC = "PC";
    public final static String MOBILE = "MOBILE";

    /**
     * 降序标识
     */
    public final static String DESC = "desc";

    /**
     * 升序标识
     */
    public final static String ASC = "asc";

    public static final String IDS = "ids";

    //以下为mongodb中的集合名称
    public static final String WB_APP_CUSTOM_SETTING = "wb_appCustomSetting";
    public static final String WB_COMPONENT = "wb_component";
    public static final String WB_MENU = "wb_menu";
    public static final String WB_MENU_ITEM = "wb_menuItem";
    public static final String WB_PORTAL = "wb_portal";
    public static final String WB_PORTAL_CONTENT = "wb_portalContent";
    public static final String WB_RELATED_APP = "wb_relatedApp";
    public static final String WB_THUMBNAIL = "wb_thumbnail";
    public static final String CAROUSEL_FOLDER = "carousel_download_folder";

    public static final List<String> WB_COLLECTION_LIST =
            Collections.unmodifiableList(Arrays.asList(WB_APP_CUSTOM_SETTING, WB_COMPONENT, WB_MENU, WB_MENU_ITEM, WB_PORTAL, WB_PORTAL_CONTENT
                    , WB_RELATED_APP, WB_THUMBNAIL));

    public static final String THUMBNAIL_FOLDER = "thumbnail_download_folder";

    public static final Integer LOOP_FILE_MAX_DEPTH = 8;

    public static final String TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";

    public static final String SYSTEM_TENANT = "SYSTEM_TENANT";
}
