package com.digiwin.athena.semc.service.workbench.designer.mongo;

import lombok.experimental.Accessors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Accessors(chain = true)
public class MultiLanguageDTO<T> {
    protected T zh_CN;
    protected T zh_TW;
    protected T en_US;

    private String label;

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public T getZh_CN() {
        return zh_CN;
    }

    public MultiLanguageDTO setZh_CN(T zh_CN) {
        if (null == zh_CN) {
            return this;
        }

        if (zh_CN instanceof String) {
            if (((String)zh_CN).contains("\"")) {
                zh_CN = (T) ((String)zh_CN).replaceAll("\"", "");
            }
            if (((String)zh_CN).contains("\n")) {
                zh_CN = (T) ((String)zh_CN).replaceAll("\n", " ");
            }
        } else if (zh_CN instanceof List) {
            for (String cnStr : ((List<String>)zh_CN)) {
                if (cnStr.contains("\"")) {
                    cnStr = cnStr.replaceAll("\"", "");
                }
                if (cnStr.contains("\n")) {
                    cnStr = cnStr.replaceAll("\n", " ");
                }
            }
        }

        this.zh_CN = zh_CN;
        return this;
    }

    public T getZh_TW() {
        return zh_TW;
    }

    public MultiLanguageDTO setZh_TW(T zh_TW) {
        if (null == zh_TW) {
            return this;
        }

        if (zh_TW instanceof String) {
            if (((String)zh_TW).contains("\"")) {
                zh_TW = (T) ((String) zh_TW).replaceAll("\"", "");
            }
            if (((String)zh_TW).contains("\n")) {
                zh_TW = (T) ((String)zh_TW).replaceAll("\n", " ");
            }
        } else if (zh_TW instanceof List) {
            for (String twStr : ((List<String>)zh_TW)) {
                if (twStr.contains("\"")) {
                    twStr = twStr.replaceAll("\"", "");
                }
                if (twStr.contains("\n")) {
                    twStr = twStr.replaceAll("\n", " ");
                }
            }
        }

        this.zh_TW = zh_TW;
        return this;
    }

    public T getEn_US() {
        return en_US;
    }

    public MultiLanguageDTO setEn_US(T en) {
        if (null == en) {
            return this;
        }

        if (en instanceof String) {
            if (((String)en).contains("\"")) {
                en = (T) ((String)en).replaceAll("\"", "");
            }
            if (((String)en).contains("\n")) {
                en = (T) ((String)en).replaceAll("\n", " ");
            }
        } else if (en instanceof List) {
            for (String enStr : ((List<String>)en)) {
                if (enStr.contains("\"")) {
                    enStr = enStr.replaceAll("\"", "");
                }
                if (enStr.contains("\n")) {
                    enStr = enStr.replaceAll("\n", " ");
                }
            }
        }

        this.en_US = en;
        return this;
    }

    public Map<String, T> toMap(MultiLanguageDTO multiLanguageDTO) {
        Map<String, T> re = new HashMap<>();
        re.put("zh_CN", (T) multiLanguageDTO.getZh_CN());
        re.put("zh_TW", (T) multiLanguageDTO.getZh_TW());
        re.put("en_US", (T) multiLanguageDTO.getEn_US());
        return re;
    }

    public Map<String, T> toMap() {
        Map<String, T> re = new HashMap<>();
        re.put("zh_CN", this.zh_CN);
        re.put("zh_TW", this.zh_TW);
        re.put("en_US", this.en_US);
        return re;
    }

    public MultiLanguageDTO<T> fromMap(Map<String, T> langMap) {
        if (langMap != null) {
            this.setZh_CN(langMap.get("zh_CN"));
            this.setZh_TW(langMap.get("zh_TW"));
            this.setEn_US(langMap.get("en_US"));
        }
        return this;
    }
}
