package com.digiwin.athena.semc.service.workbench.designer.mongo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;


/**
 * 应用客制配置实体类
 *
 * @author IPmas
 * @date 2025/8/21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
public class WorkBenchAppCustomSetting extends WorkBenchBaseObject {

    /**
     * 主键
     */
    private Long id;

    /**
     * 工作台应用code
     */
    private String application;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 定制包名称
     */
    private String packageName;

    /**
     * 定制包打包后的入口文件名称
     */
    private String remoteEntry;

    /**
     * 微前端中被导入的模块名称
     */
    private String remoteName;

    /**
     * 微前端中被导出的模块路径
     */
    private String exposedModule;

    /**
     * 微前端中被导出的模块名称
     */
    private String moduleName;
}
