package com.digiwin.athena.semc.service.workbench.designer.mongo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 * 部件管理表
 *
 * @author IPmas
 * @date 2025/8/25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class WorkBenchComponent extends WorkBenchBaseObject {
    /**
     * id(对应objectId)
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 应用编码 预设部件为固定值 SYSTEM
     */
    private String application;

    /**
     * 租户id  预设部件为固定值 SYSTEM
     */
    private String tenantId;

    /**
     * 图标
     */
    private String icon;

    /**
     * 备注
     */
    private String remark;

    /**
     * 组件分类 移动端: MOBILE  PC端: PC
     */
    private String clientType;

    /**
     * 组件分类
     * PC端:
     * 预设部件: 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、5-预设组件-固定组件:
     * 自定义部件:3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办、8-自定义组件-内嵌网页、9-自定义组件-报表)、10-ISV-低代码部件
     * <p>
     * 移动端:
     * 预设部件:0-预设组件-金刚区、1-预设组件-任务组件、2-预设组件-项目追踪组件、4:轮播图、5:公告、6:标题、7:分割线、8:三方待办、9:图片、10:业务入口
     */
    private Integer category;

    /**
     * 内容
     */
    private Map<String, Object> contentConfig;

    /**
     * 展示方式 0-文本列表  1-应用  2-应用作业
     */
    private Integer showType;

    /**
     * 发布标记 0(default):未发布  1:已发布
     */
    private Boolean publishFlag;

    /**
     * key只有两个name和remark
     */
    private Map<String, MultiLanguageDTO> lang;
}
