package com.digiwin.athena.semc.service.workbench.designer.mongo;

import com.digiwin.athena.semc.service.workbench.constant.WorkBenchConstant;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

/**
 * 菜单表
 *
 * @author IPmas
 * @date 2025/9/9
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Document(collection = WorkBenchConstant.WB_MENU)
public class WorkBenchMenu extends WorkBenchBaseObject {
    /**
     * 菜单ID
     */
    @Id
    private Long id;

    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 模板描述
     */
    private String templateDesc;

    /**
     * 客户端类型：
     * 移动端：MOBILE，PC端：PC
     */
    private String clientType;

    /**
     * 系统菜单标识（0：否，1：是）
     */
    private Integer systemMenuFlag;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * key只有两个name和remark
     */
    private Map<String, MultiLanguageDTO> lang;
}
