package com.digiwin.athena.semc.service.workbench.designer.mongo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * 菜单项表
 *
 * @author IPmas
 * @date 2025/8/26
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class WorkBenchMenuItem extends WorkBenchBaseObject {

    /**
     * id(对应objectId)
     */
    private String id;

    /**
     * 工作台应用code
     */
    private String application;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 菜单id
     */
    private Long menuId;

    /**
     * 菜单图标
     */
    private String menuItemIcon;

    /**
     * 菜单/作业/组件名称
     */
    private String menuItemName;

    /**
     * 菜单类型 1:菜单  2:作业  3:组件
     */
    private Integer menuItemType;

    /**
     * 菜单项子id
     * 当menuItemType=3  & menuItemSubType=0时，subId的值就是自定义部件的Id
     */
    private Long menuItemSubId;

    /**
     * 菜单项是作业是，作业所属的应用code
     */
    private String menuItemWorkAppCode;

    /**
     * 菜单项-作业配置，
     */
    private String menuItemWorkConfig;

    /**
     * 菜单项子分类
     * 当menuItemType=3时，subType的值为组件的类型，
     * 如：0:自定义组件 1:预设组件
     */
    private Integer menuItemSubType;

    /**
     * 菜单项所处层级
     */
    private Integer menuItemLevel;

    /**
     * 菜单项排序
     */
    private Integer menuItemOrder;

    /**
     * 父级菜单项id
     */
    private String menuItemParentId;

    /**
     * 父级菜单项名称
     */
    private String menuItemParentName;

    /**
     * 部件分类
     * PC端：
     *    预设部件：
     *        0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、5-预设组件-固定组件；
     *
     *    自定义部件：
     *        3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办、8-自定义组件-内嵌网页、9-自定义组件-报表）、10-ISV-低代码部件
     */
    private Integer category;

    /**
     * 预设部件分类
     */
    private Integer subCategory;

    /**
     * key只有两个name和remark
     */
    private Map<String, MultiLanguageDTO> lang;

    /**
     * 孩子节点
     */
    private List<WorkBenchMenuItem> children;
}
