package com.digiwin.athena.semc.service.workbench.designer.mongo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * 门户表
 *
 * @author IPmas
 * @date 2025/8/25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class WorkBenchPortal extends WorkBenchBaseObject {

    /**
     * id(对应objectId)
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 备注
     */
    private String remark;

    /**
     * 应用编码
     */
    private String application;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 组件分类 移动端: MOBILE  PC端: PC
     */
    private String clientType;

    /**
     * 菜单id
     */
    private Long menuId;

    /**
     * 发布状态
     */
    private Boolean publishFlag;

    /**
     * 是否为草稿
     */
    private Boolean draftFlag;

    /**
     * 缩略图文件id
     */
    private String thumbnail;

    /**
     * 门户类型
     * 移动端 0-门户布局  1-自定义页面布局
     */
    private Integer category;

    /**
     * 布局内容
     * 移动端  bgColor: 背景色
     */
    private List<Map<String, Object>> content;

    /**
     * 展示方式  0-文本列表  1-应用  2-应用作业
     */
    private Integer showType;

    /**
     * key只有两个name和remark
     */
    private Map<String, MultiLanguageDTO> lang;

    /**
     * 是否展示系统菜单 0:否 1:是
     */
    private Integer systemMenuFlag;
}
