package com.digiwin.athena.semc.service.workbench.designer.mongo;

import com.digiwin.athena.semc.entity.portal.PortalContentCarousel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 * 门户内容表
 *
 * @author IPmas
 * @date 2025/8/26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class WorkBenchPortalContent extends WorkBenchBaseObject {

    /**
     * id(对应objectId)
     */
    private Long id;

    /**
     * 工作台应用code
     */
    private String application;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 父级id
     */
    private String parentId;

    /**
     * 门户id
     */
    private Long portalId;

    /**
     * 组件id/菜单id
     */
    private Long contentId;

    /**
     * 分类
     * PC端: 0：自定义组件、1：预设组件、2：自定义菜单、3：容器
     * 移动端: 0-预设组件-金刚区  1-预设组件-任务组件  2-预设组件-项目追踪组件  4:轮播图  5:公告  6:标题  7:分割线  8:三方待办  9:图片  10:业务入口
     */
    private Integer contentType;

    /**
     * 系统菜单标识
     */
    private Integer systemMenuFlag;

    /**
     * 组件子类型
     */
    private Integer contentSubType;

    /**
     * 内容组件名称
     */
    private String contentName;

    /**
     * 内容uuid
     */
    private String contentUuid;

    /**
     * 轮播图信息
     */
    private PortalContentCarousel carouselInfo;

    /**
     * 门户项内容
     */
    private Map<String, Object> contentConfig;

    /**
     * key只有两个name和remark
     */
    private Map<String, MultiLanguageDTO> lang;

    /**
     * 是否显示名称
     */
    private Integer isNameShow;

}
