package com.digiwin.athena.semc.service.workbench.designer.mongo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * 关联应用表
 *
 * @author IPmas
 * @date 2025/8/26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WorkBenchRelatedApp extends WorkBenchBaseObject {

    /**
     * id
     */
    private String id;

    /**
     * 工作台应用code
     */
    private String application;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 关联的应用code
     */
    private String relatedApplication;

    /**
     * 关联的应用名称
     */
    private String relatedApplicationName;

    /**
     * 元素id
     */
    private String eleId;

    /**
     * 元素类型  1:门户
     */
    private Integer eleType;

    /**
     * key只有两个name和remark
     */
    private Map<String, MultiLanguageDTO> lang;
}
