package com.digiwin.athena.semc.service.workbench.designer.po;

import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchAppCustomSetting;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchComponent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenu;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenuItem;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortal;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortalContent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchRelatedApp;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchThumbnail;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.collections.CollectionUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

@Data
@ToString
public class WorkbenchDesignerData {
    private List<WorkBenchAppCustomSetting> customSettings;

    private List<WorkBenchRelatedApp> relatedApps;

    private List<WorkBenchPortal> portals;

    private List<WorkBenchPortalContent> portalContents;

    private List<WorkBenchMenu> menus;

    private List<WorkBenchMenuItem> menuItems;

    private List<WorkBenchComponent> components;

    private List<WorkBenchThumbnail> thumbnails;

    private File[] thumbnailFiles;

    private File[] carouselFiles;

    public WorkbenchDesignerData() {
        customSettings = new ArrayList<>();
        relatedApps = new ArrayList<>();
        portals = new ArrayList<>();
        portalContents = new ArrayList<>();
        menus = new ArrayList<>();
        menuItems = new ArrayList<>();
        components = new ArrayList<>();
        thumbnails = new ArrayList<>();
    }
}
