package com.digiwin.athena.semc.service.workbench.designer.service;

import com.digiwin.athena.semc.dto.workbench.req.WorkbenchDeployAppReqDto;
import com.digiwin.athena.semc.proxy.dmc.service.DmcService;
import com.digiwin.athena.semc.proxy.dmc.service.FileInfo;
import com.digiwin.athena.semc.service.workbench.designer.po.WorkbenchDesignerData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.File;
import java.net.URLConnection;

@Slf4j
public abstract class AbstractWorkbenchDeployHandler {
    @Autowired
    private DmcService dmcService;

    public abstract void deploy(WorkbenchDeployAppReqDto deployAppReq, WorkbenchDesignerData designerData);

    protected void uploadThumbnail(File thumbnailFile,String fileId) {
        String fullFileName = thumbnailFile.getName();
        // 解析出 剔除 后缀名的文件名
        FileInfo jsonObject = new FileInfo();
        jsonObject.setId(fileId);
        String contentType = URLConnection.guessContentTypeFromName(fullFileName);
        String id = dmcService.upload(thumbnailFile, contentType, jsonObject);
        System.out.println( id);
    }
}
