package com.digiwin.athena.semc.service.workbench.designer.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.portal.AppCustomSetting;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.RelatedApp;
import com.digiwin.athena.semc.service.menu.CustomizedMenuTemplateService;
import com.digiwin.athena.semc.service.menu.CustomizedMenuWorkService;
import com.digiwin.athena.semc.service.portal.AppCustomSettingService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.PortalInfoContentService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.portal.RelatedAppService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
@Slf4j
public class WorkbenchDeleteHandler {
    @Autowired
    private AppCustomSettingService appCustomSettingService;

    @Autowired
    private RelatedAppService relatedAppService;

    @Autowired
    private LabelSystemCustomService customComponentService;

    @Autowired
    private PortalInfoService portalService;

    @Autowired
    private PortalInfoContentService portalContentService;

    @Autowired
    private CustomizedMenuTemplateService menuService;

    @Autowired
    private CustomizedMenuWorkService menuItemService;

    public void delete (String application) {
        // 删除客制包
        appCustomSettingService.remove(
                new LambdaQueryWrapper<AppCustomSetting>().eq(AppCustomSetting::getApplication, application));

        // 删除关联应用
        relatedAppService.remove(new LambdaQueryWrapper<RelatedApp>().eq(RelatedApp::getApplication, application));

        // 删除自定义组件
        customComponentService.remove(
                new LambdaQueryWrapper<LabelSystemCustom>().eq(LabelSystemCustom::getWorkbenchAppCode, application));

        // 删除门户
        portalService.remove(new LambdaQueryWrapper<PortalInfo>().eq(PortalInfo::getWorkbenchAppCode, application));

        // 删除门户内容
        portalContentService.remove(
                new LambdaQueryWrapper<PortalInfoContent>().eq(PortalInfoContent::getWorkbenchAppCode, application));

        // 删除菜单模板
        menuService.remove(
                new LambdaQueryWrapper<CustomizedMenuTemplate>().eq(CustomizedMenuTemplate::getWorkbenchAppCode,
                        application));

        // 删除菜单项
        menuItemService.remove(
                new LambdaQueryWrapper<CustomizedMenuWork>().eq(CustomizedMenuWork::getWorkbenchAppCode, application));
    }

    public void deletePortal (String application, Long portalId) {
        // 删除关联应用
        relatedAppService.remove(new LambdaQueryWrapper<RelatedApp>().eq(RelatedApp::getApplication, application).eq(
                RelatedApp::getEleId, portalId));

        // 查询门户
        PortalInfo portal = portalService.getOne(
                new LambdaQueryWrapper<PortalInfo>().eq(PortalInfo::getWorkbenchAppCode, application).eq(
                        PortalInfo::getPortalDesignerId, portalId));

        // 查询门户内容
        if (portal != null) {
            // 查询门户内容
            List<PortalInfoContent> portalInfoContentList = portalContentService.list(
                    new LambdaQueryWrapper<PortalInfoContent>().eq(PortalInfoContent::getPortalId, portal.getId()));

            // 查询菜单
            List<CustomizedMenuTemplate> menuTemplateList = menuService.list(
                    new LambdaQueryWrapper<CustomizedMenuTemplate>().eq(CustomizedMenuTemplate::getMenuDesignerId,
                            portal.getMenuTemplateId()));

            if (!CollectionUtils.isEmpty(menuTemplateList)) {
                List<Long> menuTemplateIdList = menuTemplateList.stream().map(
                        menuTemplate -> menuTemplate.getId()).collect(Collectors.toList());

                // 删除菜单项
                menuItemService.removeBatchByIds(menuTemplateIdList);
                // 删除菜单模板
                menuService.removeBatchByIds(menuTemplateIdList);
            }

            if (!CollectionUtils.isEmpty(portalInfoContentList)) {
                List<Long> portalInfoContentIdList = portalInfoContentList.stream().map(
                        portalInfoContent -> portalInfoContent.getId()).collect(Collectors.toList());

                // 删除门户内容
                portalContentService.removeBatchByIds(portalInfoContentIdList);
            }

            portalService.removeById(portal.getId());
        }
    }
}