package com.digiwin.athena.semc.service.workbench.util;

import com.digiwin.athena.semc.service.workbench.designer.mongo.MultiLanguageDTO;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

public abstract class LanguageUtils {
    public static final String zh_CN = "zh_CN";

    public static final String zh_TW = "zh_TW";

    public static final String en_US = "en_US";

    private LanguageUtils() {
    }

    /**
     * 特殊处理value为MultiLanguageDTO类型的多语言
     */
    public static String processLocaleLanguage(Map<String, MultiLanguageDTO> lang, String locale, String fieldName, String defaultValue) {
        if (lang == null) {
            return defaultValue;
        }

        if (StringUtils.isBlank(locale)) {
            return defaultValue;
        }
        Map name = lang.get(fieldName).toMap();

        return name != null ? name.get(locale).toString() : defaultValue;
    }
}
