package com.digiwin.athena.semc.service.workbench.util;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.portal.AppCustomSetting;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.RelatedApp;
import com.digiwin.athena.semc.service.workbench.constant.EnvOperateEnum;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.service.workbench.constant.WorkBenchConstant;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchAppCustomSetting;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchComponent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenu;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenuItem;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortal;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortalContent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchRelatedApp;
import org.springframework.beans.BeanUtils;

import java.time.LocalDateTime;

public interface WorkbenchSyncDataConverter {
    static LabelSystemCustom toUpdateCustomComponent(String compileVersion, LabelSystemCustom component,
            WorkBenchComponent designerComponent) {
        // 自定义组件名称-中文
        component.setNameZh(LanguageUtils.processLocaleLanguage(designerComponent.getLang(), LanguageUtils.zh_CN, "name", designerComponent.getName()));
        // 自定义组件名称-英文
        component.setNameUs(LanguageUtils.processLocaleLanguage(designerComponent.getLang(), LanguageUtils.en_US, "name", designerComponent.getName()));
        // 极简门户图标
        // component.setIcon();
        // 经典门户图标
        component.setClassicsIcon(designerComponent.getIcon());
        // 组件分类 pc端（ 3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办、8-自定义组件-内嵌网页、9-自定义组件-报表 10-自定义组件-低代码）；移动端：（ 1-自定义组件-H5外链）
        component.setDataCategory(designerComponent.getCategory());
        // 内容
        //component.setContent();
        if (null != designerComponent.getContentConfig()) {
            // 内嵌网页组件_链接地址
            component.setLinkUrl(MapUtil.getStr(designerComponent.getContentConfig(), "linkUrl"));
            // 内嵌网页组件_链接参数
            component.setLinkParam(MapUtil.getStr(designerComponent.getContentConfig(), "linkParam"));
        }
        // 展示方式（ 0：文本列表、1：应用、2：应用作业）
        component.setShowType(designerComponent.getShowType());
        // 备注
        component.setRemark(designerComponent.getRemark());
        // 多语言
        // component.setLang();
        // 编译版本
        component.setCompileVersion(compileVersion);
        // ISV客制部件的脚本
        component.setContentConfig(designerComponent.getContentConfig());

        component.setModifyUserId(designerComponent.getModifyUserId());
        component.setModifyUserName(designerComponent.getModifyUserName());
        component.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));
        return component;
    }

    /**
     * @description: 发版时创建自定义部件
     * @param
     * @return 
     * @author: sunyfa
     */
    static LabelSystemCustom toNewCustomComponent(String compileVersion, String version, WorkBenchComponent designerComponent) {
        LabelSystemCustom component = new LabelSystemCustom();

        // 部件设计时id
        component.setComponentDesignerId(designerComponent.getId());
        // 工作台应用code
        component.setWorkbenchAppCode(designerComponent.getApplication());
        // 自定义组件名称-中文
        component.setNameZh(LanguageUtils.processLocaleLanguage(designerComponent.getLang(), LanguageUtils.zh_CN, "name", designerComponent.getName()));
        // 自定义组件名称-英文
        component.setNameUs(LanguageUtils.processLocaleLanguage(designerComponent.getLang(), LanguageUtils.en_US, "name", designerComponent.getName()));
        // 极简门户图标
        // component.setIcon();
        // 经典门户图标
        component.setClassicsIcon(designerComponent.getIcon());
        // 组件分类 pc端（ 3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办、8-自定义组件-内嵌网页、9-自定义组件-报表 10-自定义组件-低代码）；移动端：（ 1-自定义组件-H5外链）
        component.setDataCategory(designerComponent.getCategory());
        // 内容
        //component.setContent();
        // 组件端 0：PC端，1：移动端
        if (WorkBenchConstant.PC.equals(designerComponent.getClientType())) {
            component.setClientType(Constants.ClientTypeTypeEnum.PC.getFlag());
        }
        else if (WorkBenchConstant.MOBILE.equals(designerComponent.getClientType())) {
            component.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        }
        if (null != designerComponent.getContentConfig()) {
            // 内嵌网页组件_链接地址
            component.setLinkUrl(MapUtil.getStr(designerComponent.getContentConfig(), "linkUrl"));
            // 内嵌网页组件_链接参数
            component.setLinkParam(MapUtil.getStr(designerComponent.getContentConfig(), "linkParam"));
        }
        // 展示方式（ 0：文本列表、1：应用、2：应用作业）
        component.setShowType(designerComponent.getShowType());
        // 有效状态 0:无效 1:有效
        component.setValidStatus(Constants.ValidStatusEnum.VALID_STATUS_OFF.getVal());
        // 备注
        component.setRemark(designerComponent.getRemark());
        // 租户id
        component.setTenantId(WorkBenchConstant.SYSTEM_TENANT);
        // 数据版本
        component.setVersion(version);
        // 多语言
        // component.setLang();
        // 编译版本
        component.setCompileVersion(compileVersion);
        // ISV客制部件的脚本
        component.setContentConfig(designerComponent.getContentConfig());
        // 来源，0：租户，1：ISV
        component.setSource(Constants.SourceEnum.ISV.getFlag());

        component.setCreateUserId(designerComponent.getCreateUserId());
        component.setCreateUserName(designerComponent.getCreateUserName());
        component.setCreateTime(WorkbenchUtils.formatTime(designerComponent.getCreateTime()));

        component.setModifyUserId(designerComponent.getModifyUserId());
        component.setModifyUserName(designerComponent.getModifyUserName());
        component.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));
        return component;
    }

    static AppCustomSetting toCustomSetting(WorkBenchAppCustomSetting designerCustomSetting, String version) {
        AppCustomSetting customSetting = new AppCustomSetting();
        customSetting.setApplication(designerCustomSetting.getApplication());
        customSetting.setPackageName(designerCustomSetting.getPackageName());
        customSetting.setRemoteEntry(designerCustomSetting.getRemoteEntry());
        customSetting.setRemoteName(designerCustomSetting.getRemoteName());
        customSetting.setExposedModule(designerCustomSetting.getExposedModule());
        customSetting.setModuleName(designerCustomSetting.getModuleName());
        customSetting.setCreateUserId(designerCustomSetting.getCreateUserId());
        customSetting.setCreateTime(WorkbenchUtils.formatTime(designerCustomSetting.getCreateTime()));
        customSetting.setModifyUserId(designerCustomSetting.getModifyUserId());
        customSetting.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));
        // 设计id
        customSetting.setDesignerId(designerCustomSetting.getId());
        // 来源
        customSetting.setSource(Constants.SourceEnum.ISV.getFlag());
        customSetting.setVersion(version);
        return customSetting;
    }

    static RelatedApp toRelatedApp(WorkBenchRelatedApp designerRelatedApp, String version) {
        RelatedApp relatedApp = new RelatedApp();
        relatedApp.setApplication(designerRelatedApp.getApplication());
        relatedApp.setRelatedApplication(designerRelatedApp.getRelatedApplication());
        relatedApp.setRelatedApplicationName(designerRelatedApp.getRelatedApplicationName());
        // 从lang中解析出 name，todo 待确认
        if (null != designerRelatedApp.getLang() && null != designerRelatedApp.getLang().get("name")) {
            relatedApp.setRelatedApplicationDefName(JSONObject.toJSONString(designerRelatedApp.getLang().get("name")));
        }
        relatedApp.setEleId(designerRelatedApp.getEleId());
        relatedApp.setEleType(designerRelatedApp.getEleType());
        // 来源
        relatedApp.setSource(Constants.SourceEnum.ISV.getFlag());
        // 设计id
        relatedApp.setDesignerId(Long.parseLong(designerRelatedApp.getId()));
        relatedApp.setVersion(version);

        relatedApp.setCreateUserId(designerRelatedApp.getCreateUserId());
        relatedApp.setCreateTime(WorkbenchUtils.formatTime(designerRelatedApp.getCreateTime()));
        relatedApp.setModifyUserId(designerRelatedApp.getModifyUserId());
        relatedApp.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));
        return relatedApp;
    }

    static CustomizedMenuTemplate toNewMenu(WorkBenchMenu desMenu, String version, String application, String compileVersion) {
        CustomizedMenuTemplate menu = new CustomizedMenuTemplate();

        // 设置id
        menu.setId(SnowflakeIdWorker.getInstance().newId());
        // 模板名称
        menu.setTemplateName(LanguageUtils.processLocaleLanguage(desMenu.getLang(), LanguageUtils.zh_CN,
                "templateName", JSONObject.toJSONString(desMenu.getLang())));
        // 模板名称_繁体
        menu.setTemplateNameTw(LanguageUtils.processLocaleLanguage(desMenu.getLang(), LanguageUtils.zh_TW, "templateName",
                JSONObject.toJSONString(desMenu.getLang())));
        // 包含各种语言别remark值
        menu.setTemplateDesc(LanguageUtils.processLocaleLanguage(desMenu.getLang(), LanguageUtils.zh_TW, "templateDesc",
                JSONObject.toJSONString(desMenu.getLang())));
        // 模板状态 0:未发布 1:已发布
        menu.setTemplateStatus(Constants.ReleaseEnum.RELEASED.getVal());
        // 是否是通用菜单模板 0:否 1:是
        menu.setGeneralFlag(Constants.GENERAL_MENU_FLAG_NO);
        // 是否展示系统菜单 0:否 1:是
        menu.setSystemMenuFlag(desMenu.getSystemMenuFlag());
        // 租户id
        menu.setTenantId(WorkBenchConstant.SYSTEM_TENANT);
        // 菜单设计时id
        menu.setMenuDesignerId(desMenu.getId());
        // 数据版本
        menu.setVersion(version);
        // 编译版本
        menu.setCompileVersion(compileVersion);
        // 发布来源，开发设计时：ISV，租户设计时：TENANT
        menu.setPublishSource(PublishSourceEnum.ISV.name());
        // 工作台应用code
        menu.setWorkbenchAppCode(application);
        // 菜单来源
        menu.setSource(Constants.SourceEnum.ISV.getFlag());

        menu.setCreateUserId(desMenu.getCreateUserId());
        menu.setCreateUserName(desMenu.getCreateUserName());
        menu.setCreateTime(WorkbenchUtils.formatTime(desMenu.getCreateTime()));

        menu.setModifyUserId(desMenu.getModifyUserId());
        menu.setModifyUserName(desMenu.getModifyUserName());
        menu.setModifyTime(WorkbenchUtils.formatTime(desMenu.getModifyTime()));

        return menu;
    }

    static CustomizedMenuTemplate toUpdatePublishMenu(CustomizedMenuTemplate menu, WorkBenchMenu desMenu, String compileVersion) {
        // 模板名称
        menu.setTemplateName(LanguageUtils.processLocaleLanguage(desMenu.getLang(), LanguageUtils.zh_CN,
                "templateName", JSONObject.toJSONString(desMenu.getLang())));
        // 模板名称_繁体
        menu.setTemplateNameTw(LanguageUtils.processLocaleLanguage(desMenu.getLang(), LanguageUtils.zh_TW, "templateName",
                JSONObject.toJSONString(desMenu.getLang())));
        // 包含各种语言别remark值
        menu.setTemplateDesc(LanguageUtils.processLocaleLanguage(desMenu.getLang(), LanguageUtils.zh_TW, "templateDesc",
                JSONObject.toJSONString(desMenu.getLang())));
        // 是否展示系统菜单 0:否 1:是
        menu.setSystemMenuFlag(desMenu.getSystemMenuFlag());
        // 编译版本
        menu.setCompileVersion(compileVersion);

        menu.setModifyUserId(desMenu.getModifyUserId());
        menu.setModifyUserName(desMenu.getModifyUserName());
        menu.setModifyTime(WorkbenchUtils.formatTime(desMenu.getModifyTime()));
        return menu;
    }

    static PortalInfo toNewPortal(WorkBenchPortal designerPortal, String version, String compileVersion, Long menuTemplateId) {
        PortalInfo portal = new PortalInfo();

        portal.setId(SnowflakeIdWorker.getInstance().newId());
        // portal类型 PC 移动
        if (WorkBenchConstant.PC.equals(designerPortal.getClientType())) {
            portal.setClientType(Constants.ClientTypeTypeEnum.PC.getFlag());
        }
        else if (WorkBenchConstant.MOBILE.equals(designerPortal.getClientType())) {
            portal.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        }
        // 上级门户id
        portal.setParentId(0L);
        // 废弃字段
        portal.setTemplateId(0L);
        // 默认门户 （ 0：否 1：是）
        portal.setDefaultFlag(0);
        // 门户名称
        if (null != designerPortal.getLang() && null != designerPortal.getLang().get("name")) {
            portal.setName(String.valueOf(designerPortal.getLang().get("name").getZh_CN()));
        }
        // 自定义页面标题
        portal.setTitle("");
        // 自定义页面背景色
        portal.setBgColor("");
        // 门户描述
        if (null != designerPortal.getLang() && null != designerPortal.getLang().get("portalDesc")) {
            portal.setPortalDesc(String.valueOf(designerPortal.getLang().get("portalDesc").getZh_CN()));
        }
        // 自定义菜单模板id
        portal.setMenuTemplateId(menuTemplateId);
        // 菜单来源，0：租户菜单，1：ISV菜单
        portal.setMenuTypeSource(Constants.SourceEnum.ISV.getFlag());
        // 布局状态（0：未发布；1：已发布）
        portal.setStatus(Constants.ValidStatusEnum.VALID_STATUS_OFF.getVal());
        // 布局内容
        portal.setPortalContent(JSONObject.toJSONString(designerPortal.getContent()));
        // 缩略图文件id
        portal.setPortalImgId(designerPortal.getThumbnail());
        // 移动门户类型（0：门户布局；1：自定义页面布局）
        if (WorkBenchConstant.MOBILE.equals(designerPortal.getClientType())){
            portal.setPortalType(designerPortal.getCategory());
        }
        // 多语言
        //portal.setLang(designerPortal.getLang());
        // 租户
        portal.setTenantId(WorkBenchConstant.SYSTEM_TENANT);
        // 数据版本
        portal.setVersion(version);
        // 编译版本
        portal.setCompileVersion(compileVersion);
        // 发布来源
        portal.setPublishSource(PublishSourceEnum.ISV.name());
        // 工作台应用code
        portal.setWorkbenchAppCode(designerPortal.getApplication());
        // 设计id
        portal.setPortalDesignerId(designerPortal.getId());
        // 来源
        portal.setSource(Constants.SourceEnum.ISV.getFlag());

        portal.setCreateUserId(designerPortal.getCreateUserId());
        portal.setCreateUserName(designerPortal.getCreateUserName());
        portal.setCreateTime(WorkbenchUtils.formatTime(LocalDateTime.now()));

        portal.setModifyUserId(designerPortal.getModifyUserId());
        portal.setModifyUserName(designerPortal.getModifyUserName());
        portal.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));

        return portal;
    }

    static PortalInfo toUpdatePortal(PortalInfo portal, WorkBenchPortal designerPortal, String compileVersion) {
        // 门户名称
        if (null != designerPortal.getLang() && null != designerPortal.getLang().get("name")) {
            portal.setName(String.valueOf(designerPortal.getLang().get("name").getZh_CN()));
        }
        // 门户描述
        if (null != designerPortal.getLang() && null != designerPortal.getLang().get("portalDesc")) {
            portal.setPortalDesc(String.valueOf(designerPortal.getLang().get("portalDesc").getZh_CN()));
        }
        // 布局内容
        portal.setPortalContent(JSONObject.toJSONString(designerPortal.getContent()));
        // 缩略图文件id
        portal.setPortalImgId(designerPortal.getThumbnail());
        // 多语言
        //portal.setLang(designerPortal.getLang());
        // 编译版本
        portal.setCompileVersion(compileVersion);
        // 设计id
        portal.setPortalDesignerId(designerPortal.getId());
        // 菜单模板id
        portal.setMenuTemplateId(designerPortal.getMenuId());

        portal.setModifyUserId(designerPortal.getModifyUserId());
        portal.setModifyUserName(designerPortal.getModifyUserName());
        portal.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));

        return portal;
    }

    static PortalInfoContent toNewPortalContent(String application, WorkBenchPortalContent designerPortalContent,
            Long portalId, String version) {
        PortalInfoContent portalContent = new PortalInfoContent();
        portalContent.setId(SnowflakeIdWorker.getInstance().newId());
        // 上级ID
        portalContent.setParentId(0L);
        // 门户ID
        portalContent.setPortalId(portalId);
        // 组件/菜单模版ID
        //portalContent.setContentId();
        // 部件类型来源，0：租户部件，1：ISV部件
        portalContent.setLabelTypeSource(Constants.SourceEnum.ISV.getFlag());
        // 组件类型pc端（0：自定义组件、1：预设组件、2：自定义菜单、3：容器）；移动端：（0-预设组件-金刚区、1-预设组件-任务组件、2-预设组件-项目追踪组件、3-金刚球、4：轮播图、5：公告、6：标题、7
        // ：分割线、8：三方待办、9：图片、10：业务入口）
        portalContent.setContentType(designerPortalContent.getContentType());
        // 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局咨询、7：绩效、8：作业工作台、9：行事历、10：三方待办、11：轮播图）
        portalContent.setDataType(designerPortalContent.getContentSubType());
        // 内容组件名称
        portalContent.setContentName(designerPortalContent.getContentName());
        // 内容uuid
        portalContent.setContentUuid(designerPortalContent.getContentUuid());
        // 是否显示标题（0：否，1：是）
        portalContent.setIsNameShow(0);
        // 组件内容属性值json
        if (null != designerPortalContent.getCarouselInfo()) {
            portalContent.setContentAttr(JSONObject.toJSONString(designerPortalContent.getCarouselInfo()));
        }
        else {
            portalContent.setContentAttr(JSONObject.toJSONString(designerPortalContent.getContentConfig()));
        }
        // 多语言
        //portalContent.setLang(designerPortalContent.getLang());
        // 租户id
        portalContent.setTenantId(WorkBenchConstant.SYSTEM_TENANT);
        // 设计时id
        portalContent.setDesignerId(designerPortalContent.getId());
        // 数据版本
        portalContent.setVersion(version);
        // 应用code
        portalContent.setWorkbenchAppCode(application);
        // 是否显示
        portalContent.setIsNameShow(designerPortalContent.getIsNameShow());
        return portalContent;
    }

    static LabelSystemCustom toUpdateReleaseCustomComponent(LabelSystemCustom releaseCustomComp,
            LabelSystemCustom publishCustomComp) {
        LabelSystemCustom existReleaseCustomComp = new LabelSystemCustom();
        BeanUtils.copyProperties(publishCustomComp, existReleaseCustomComp);
        existReleaseCustomComp.setId(releaseCustomComp.getId());
        existReleaseCustomComp.setVersion(EnvOperateEnum.SWITCH.getVersion());

        existReleaseCustomComp.setCreateUserId(releaseCustomComp.getCreateUserId());
        existReleaseCustomComp.setCreateUserName(releaseCustomComp.getCreateUserName());
        existReleaseCustomComp.setCreateTime(releaseCustomComp.getCreateTime());

        existReleaseCustomComp.setModifyUserId(publishCustomComp.getModifyUserId());
        existReleaseCustomComp.setModifyUserName(publishCustomComp.getModifyUserName());
        existReleaseCustomComp.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));

        return existReleaseCustomComp;
    }

    static LabelSystemCustom toNewReleaseCustomComponent (LabelSystemCustom publishCustomComp) {
        LabelSystemCustom releaseCustomComp = new LabelSystemCustom();
        BeanUtils.copyProperties(publishCustomComp, releaseCustomComp);
        releaseCustomComp.setId(null);
        releaseCustomComp.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));
        releaseCustomComp.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return releaseCustomComp;
    }

    static RelatedApp toNewReleaseRelatedApp(RelatedApp relatedApp) {
        RelatedApp newRelatedApp = new RelatedApp();
        BeanUtils.copyProperties(relatedApp, newRelatedApp);
        newRelatedApp.setId(null);
        newRelatedApp.setModifyTime(WorkbenchUtils.formatTime(LocalDateTime.now()));
        newRelatedApp.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return newRelatedApp;
    }

    static PortalInfo toUpdateReleasePortal(PortalInfo oldReleasePortal, PortalInfo publishPortal) {
        PortalInfo newRelPortal = new PortalInfo();
        BeanUtils.copyProperties(publishPortal, newRelPortal);

        newRelPortal.setId(oldReleasePortal.getId());
        // 默认门户 （ 0：否 1：是）
        newRelPortal.setDefaultFlag(publishPortal.getDefaultFlag());
        // 菜单id不变
        // 数据版本
        newRelPortal.setVersion(EnvOperateEnum.SWITCH.getVersion());

        newRelPortal.setModifyUserId(publishPortal.getModifyUserId());
        newRelPortal.setModifyUserName(publishPortal.getModifyUserName());
        newRelPortal.setModifyUserId(WorkbenchUtils.formatTime(LocalDateTime.now()));

        return newRelPortal;
    }

    static PortalInfo toNewReleasePortal(PortalInfo portalInfo) {
        PortalInfo relPortal = new PortalInfo();
        BeanUtils.copyProperties(portalInfo, relPortal);
        relPortal.setId(SnowflakeIdWorker.getInstance().newId());
        relPortal.setVersion(EnvOperateEnum.SWITCH.getVersion());

        return relPortal;
    }

    static PortalInfoContent toNewReleasePortalContent(PortalInfoContent portalContent, PortalInfo portal) {
        PortalInfoContent newRelPortalContent = new PortalInfoContent();
        BeanUtils.copyProperties(portalContent, newRelPortalContent);
        newRelPortalContent.setPortalId(portal.getId());
        newRelPortalContent.setId(null);
        newRelPortalContent.setVersion(EnvOperateEnum.SWITCH.getVersion());

        return newRelPortalContent;
    }

    static CustomizedMenuTemplate toNewReleaseMenu(CustomizedMenuTemplate publishMenu) {
        CustomizedMenuTemplate releaseMenu = new CustomizedMenuTemplate();
        BeanUtils.copyProperties(publishMenu, releaseMenu);
        releaseMenu.setId(SnowflakeIdWorker.getInstance().newId());
        releaseMenu.setVersion(EnvOperateEnum.SWITCH.getVersion());

        return releaseMenu;
    }

    static CustomizedMenuTemplate toUpdateReleaseMenu(CustomizedMenuTemplate publishMenu,
            Long releaseMenuId) {
        CustomizedMenuTemplate releaseMenu = new CustomizedMenuTemplate();
        BeanUtils.copyProperties(publishMenu, releaseMenu);
        releaseMenu.setId(releaseMenuId);
        releaseMenu.setVersion(EnvOperateEnum.SWITCH.getVersion());

        return releaseMenu;
    }

    static CustomizedMenuWork toNewReleaseMenuItem(CustomizedMenuWork menuItem, Long id) {
        CustomizedMenuWork newRelMenuItem = new CustomizedMenuWork();
        BeanUtils.copyProperties(menuItem, newRelMenuItem);
        newRelMenuItem.setTemplateId(null);
        newRelMenuItem.setId(id);
        newRelMenuItem.setVersion(EnvOperateEnum.SWITCH.getVersion());

        return newRelMenuItem;
    }

    static AppCustomSetting toReleaseAppCustomSetting(AppCustomSetting publishCustomSetting) {
        AppCustomSetting releaseCustomSetting = new AppCustomSetting();
        BeanUtils.copyProperties(publishCustomSetting, releaseCustomSetting);
        releaseCustomSetting.setId(null);
        releaseCustomSetting.setVersion(EnvOperateEnum.SWITCH.getVersion());

        return releaseCustomSetting;
    }

    static CustomizedMenuWork toMenuItem (String application, WorkBenchMenuItem menuItem, Long menuItemId,
            Long templateId, Long parentId, String version) {
        CustomizedMenuWork menuWork = new CustomizedMenuWork();

        // 主键
        menuWork.setId(menuItemId);
        // 模板id
        menuWork.setTemplateId(templateId);
        // 菜单图标
        menuWork.setMenuIcon(menuItem.getMenuItemIcon());
        // 菜单/作业/组件名称
        menuWork.setMenuName(menuItem.getMenuItemName());
        // 菜单/作业/组件初始名称
        menuWork.setOriginalName(menuItem.getMenuItemName());
        // 菜单/作业/组件繁体名称
        if (null != menuItem.getLang() && null != menuItem.getLang().get("name")) {
            menuWork.setMenuNameTw(String.valueOf(menuItem.getLang().get("name").getZh_TW()));
        }
        // 类型 1:菜单 2:作业 3:组件
        menuWork.setMenuType(menuItem.getMenuItemType());
        // 组件id
        //menuWork.setMenuLabelId();
        // 组件类型 0:自定义组件 1:预设组件
        // menuWork.setMenuLabelType();
        // 应用编码
        menuWork.setAppCode(menuItem.getApplication());
        // 应用作业配置
        menuWork.setWorkConfig(menuItem.getMenuItemWorkConfig());
        // 层级 1:一级 2:二级 3:三级
        menuWork.setLevel(menuItem.getMenuItemLevel());
        // 顺序
        menuWork.setMenuOrder(menuItem.getMenuItemOrder());
        // 父级id
        menuWork.setParentId(parentId);
        // 父级名称
        menuWork.setParentName(menuItem.getMenuItemParentName());
        // 部件来源，0：租户部件，1：ISV部件
        menuWork.setLabelTypeSource(Constants.SourceEnum.ISV.getFlag());
        // 租户id
        menuWork.setTenantId(WorkBenchConstant.SYSTEM_TENANT);
        // 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局咨询、7：绩效、8：作业工作台、9：行事历、10：三方待办、11：轮播图）
        //menuWork.setDataType();
        // 应用code
        menuWork.setWorkbenchAppCode(application);
        // 数据版本
        menuWork.setVersion(version);
        // 菜单模板id
        menuWork.setDesTemplateId(menuItem.getMenuId());

        return menuWork;
    }
}