package com.digiwin.athena.semc.service.workbenchappcustomsetting.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoAuth;
import com.digiwin.athena.semc.entity.portal.WorkbenchAppCustomSetting;
import com.digiwin.athena.semc.mapper.portal.PortalInfoAuthMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoMapper;
import com.digiwin.athena.semc.mapper.portal.WorkbenchAppCustomSettingMapper;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.service.portal.RelatedAppServiceWrapper;
import com.digiwin.athena.semc.service.workbenchappcustomsetting.WorkbenchAppCustomSettingService;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by changcong 21064
 * Date 2025/9/26 14:50
 * Description
 */
@Service
public class WorkbenchAppCustomSettingServiceImpl extends ServiceImpl<WorkbenchAppCustomSettingMapper, WorkbenchAppCustomSetting> implements WorkbenchAppCustomSettingService {

    @Autowired
    private KmService kmService;

    @Autowired
    private RelatedAppServiceWrapper relatedAppServiceWrapper;

    @Resource
    private PortalInfoMapper portalInfoMapper;

    @Autowired
    private LabelSystemAuthService labelSystemAuthService;

    @Resource
    private PortalInfoAuthMapper portalInfoAuthMapper;

    @Override
    public List<WorkbenchAppCustomSetting> listTenant() {
        String tenantVersion = kmService.queryTenantVersionWithDefault();
        List<Long> isddds = relatedAppServiceWrapper.queryCurrTenantPortalList(tenantVersion);
        if (CollectionUtils.isEmpty(isddds)){
            return Collections.emptyList();
        }
        LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalInfo::getVersion,tenantVersion).in(CollectionUtils.isNotEmpty(isddds),PortalInfo::getPortalDesignerId,isddds);
        List<PortalInfo> portalInfoList = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectList(queryWrapper));
        if (CollectionUtils.isEmpty(portalInfoList)){
            return Collections.emptyList();
        }
        Set<String> collect = portalInfoList.stream().map(e -> e.getWorkbenchAppCode()).collect(Collectors.toSet());
        LambdaQueryWrapper<WorkbenchAppCustomSetting> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(WorkbenchAppCustomSetting::getApplication,collect).eq(WorkbenchAppCustomSetting::getVersion,tenantVersion);
        List<WorkbenchAppCustomSetting> workbenchAppCustomSettings = this.getBaseMapper().selectList(lambdaQueryWrapper);
        return workbenchAppCustomSettings;
    }

    @Override
    public List<WorkbenchAppCustomSetting> listUser() {
        String tenantVersion = kmService.queryTenantVersionWithDefault();
        QueryWrapper<PortalInfoAuth> condition = new QueryWrapper<>();
        QueryWrapper wrapper = labelSystemAuthService.getUserAuthCon(condition);
        //获取登录用户权限内门户
        List<PortalInfoAuth> portalInfoAuthList = portalInfoAuthMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(portalInfoAuthList)){
            return Collections.emptyList();
        }
        //過濾出isv
        List<PortalInfoAuth> isvportalInfoAuths = portalInfoAuthList.stream().filter(e -> Objects.equals(1, e.getPortalTypeSource())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(isvportalInfoAuths)){
            return Collections.emptyList();
        }
        Set<Long> portals = isvportalInfoAuths.stream().map(e -> e.getPortalId()).collect(Collectors.toSet());
        LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalInfo::getVersion,tenantVersion).in(PortalInfo::getPortalDesignerId,portals);
        List<PortalInfo> portalInfoList = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectList(queryWrapper));
        if (CollectionUtils.isEmpty(portalInfoList)){
            return Collections.emptyList();
        }
        Set<String> workbenchAppCodes = portalInfoList.stream().map(e -> e.getWorkbenchAppCode()).collect(Collectors.toSet());
        LambdaQueryWrapper<WorkbenchAppCustomSetting> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(WorkbenchAppCustomSetting::getApplication,workbenchAppCodes).eq(WorkbenchAppCustomSetting::getVersion,tenantVersion);
        List<WorkbenchAppCustomSetting> workbenchAppCustomSettings = this.getBaseMapper().selectList(lambdaQueryWrapper);
        return workbenchAppCustomSettings;
    }
}
