package com.digiwin.athena.semc.util;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.dto.homepage.HomeSearchDTO;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Hex;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

/**
 * Created by changcong 0027012250
 * Date 2024/2/22 10:35
 * Description
 */
@Slf4j
public class AESUtils {
    public static final String CAS_AES_KEY = "niwigid@~cas.key";

    // AES加密
    public static String aesEncrypt(String src, String aesKey) {
        try {
            SecretKeySpec key = gener(aesKey);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, key);

            byte[] cleartext = src.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            return Hex.encodeHexString(ciphertextBytes).toUpperCase();
        } catch (Exception ex) {
            log.error("AES加密失败[{}]", src);
            return src;
        }
    }

    // AES解密
    public static String aesDecrypt(String content, String aesKey) {
        try {
            SecretKey key = gener(aesKey, "ASCII");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, key);
            byte[] cleartext = Hex.decodeHex(content.toCharArray());
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            return new String(ciphertextBytes, StandardCharsets.UTF_8);
        } catch (Exception ex) {
            log.error(ex.getMessage());
            return null;
        }
    }

    public static SecretKeySpec gener(String key) {
        byte[] finalKey = new byte[16];
        int i = 0;
        for (byte b : key.getBytes(StandardCharsets.UTF_8)) {
            finalKey[i++ % 16] ^= b;
        }
        return new SecretKeySpec(finalKey, "AES");
    }

    public static SecretKeySpec gener(final String key, final String encoding) {
        try {
            final byte[] finalKey = new byte[16];
            int i = 0;
            for (byte b : key.getBytes(encoding))
                finalKey[i++ % 16] ^= b;
            return new SecretKeySpec(finalKey, "AES");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        //AES秘钥
     /*   String secret = "Wr3t3568aXaH91T30000fMK3ZpOyv4";
        //需要加密的json字符串
        String bodyJsonStr = "{\"appId\":\"92dcf358ba164588915f844e6a61d595\",\"syncType\":\"0\",\"jobList\":[{\"jobCode\":\"todoCode\",\"jobName\":\"待办事项\",\"jobUrl\":\"portletName=performRequesterActivityById&ProcessPkgID=PKG17062504774711\",\"remark\":\"备注\"}]}";
        String aesEncrypt=aesEncrypt(bodyJsonStr,secret);
        System.out.println("加密后："+aesEncrypt);*/

      /*  String bodyJsonStr ="{\"appId\":\"309942ccdd3a4cbca0ce684dddfddf50\",\"syncType\":0,\"jobList\":[{\"jobCode\":\"AttendanceLeave_Browse\",\"jobName\":\"請銷假申請\",\"jobUrl\":\"{'address':'AttendanceLeave_Browse'}\"},{\"jobCode\":\"AttendanceOverTimePlan_Browse\",\"jobName\":\"請銷假申請\",\"jobUrl\":\"{'address':'AttendanceOverTimePlan_Browse'}\"}]}";
        String aesEncrypt=aesEncrypt(bodyJsonStr,secret);
        System.out.println("加密后："+aesEncrypt);
        //String aesEncrypt="63087C20F4252F5B0150081A222E6FC0ED396A93595A0878135E660B1130099E52ACDA9A8E88692D60F8E13F708300AAEEF4C78761B37F11E65A24A0465CE77A259F689D3EB0A3F5DA25059FB05859DC3DE1F4198CAA07484371070DAA2EE75134E39EC8E08DBF75ADB47C1F960EF6833D6B35BCF2B81A1ED0F2BFCDE7685493BD1DF44893CAD0B9964F25DF040F1AA43CA5E8033873A4EF0177667C2F5EC78B913BF57448823C56B8C675001B866493F304B4DF29047DADB8CDCEA3834DB15656F199CB09043C5040E83B1A2343FDE94FA662E680803281469D93412BA970E3581FD440D7A4E3AC45987337D4368D88F4985616513897E458DA2460EB8968992B0EDF71665022338D89DCFB608BE0AD8A14C7F13F89DF9137D916FE4D866F99A1B57533D0910BCC022B3458B379B99E";
        String aesDecrypt= aesDecrypt(aesEncrypt,secret);
        System.out.println("解密后："+aesDecrypt);

        JobSyncReq earchResult = JSON.parseObject(aesDecrypt, JobSyncReq.class);
        System.out.println(earchResult);

       //待办
        String  toDobodyJsonStr="{\"bizId\":\"8e8837c4f3541004847c4b8c475bb942\",\"appName\":\"\",\"appId\":\"eae46510fabb4259a5bb35e82fd5ed0e\"}";
        String aesEncrypt=aesEncrypt(toDobodyJsonStr,secret);
        System.out.println("加密后："+aesEncrypt);*/
    }
}
