package com.digiwin.athena.semc.util;

import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * AES加密解密
 *
 * @author: sungq
 * @date: 2024-03-06
 */
public class AesUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(AesUtil.class);

    /**
     * 密钥算法
     */
    private static final String ALGORITHM = "AES";

    /**
     * 加解密算法/工作模式/填充方式
     */
    private static final String ALGORITHM_STR = "AES/ECB/PKCS5Padding";

    /**
     * 注册密码加密秘钥
     */
    private static final String loginKey = "T2tUTHI3K1p0anlvR3lFTQ==";

    /**
     * unionid加密秘钥
     */
    private static final String hexKey = "OkTLr7+ZtjyoGyEM";

    private static final Map<String, SecretKeySpec> keyMap = new HashMap<>();

    /**
     * SecretKeySpec类是KeySpec接口的实现类,用于构建秘密密钥规范
     */
    private static final SecretKeySpec key = new SecretKeySpec(hexKey.getBytes(), ALGORITHM);


    private static final Cipher cipher;

    static {
        try {
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");

            keyMap.put(loginKey, gener(loginKey));
            keyMap.put(hexKey, gener(hexKey));
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        } catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * AES解密
     *
     * @param base64Data
     * @return
     * @throws Exception
     */
    public static String decrypt(String base64Data) throws Exception {
        try {
            // 创建密码器
            Cipher cipher = Cipher.getInstance(ALGORITHM_STR); // NOSONAR
            cipher.init(Cipher.DECRYPT_MODE, key);// 初始化
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] decode = decoder.decode(base64Data);
           return new String(cipher.doFinal(decode));
//         return new String(cipher.doFinal(new BASE64Decoder().decodeBuffer(base64Data)));
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            throw new Exception("appCode (" + base64Data + ") decrypt error");
        }
    }


    /**
     * AES加密
     *
     * @param data
     * @return
     * @throws Exception
     */
    public static String encryptData(String data) {
        try {
            // 创建密码器
            Cipher cipher = Cipher.getInstance(ALGORITHM_STR); // NOSONAR
            cipher.init(Cipher.ENCRYPT_MODE, key);// 初始化
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(cipher.doFinal(data.getBytes()));
  //        return new BASE64Encoder().encode(cipher.doFinal(data.getBytes()));
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return null;
        }
    }

    /**
     * @param src
     * @param type "0"是密码加密  “1”是unionid加密
     * @return
     */
    public static synchronized String aesEncrypt(String src, String type) {
        try {
            switch (type) {
                case "0":
                    cipher.init(Cipher.ENCRYPT_MODE, keyMap.get(loginKey));
                    break;
                default:
                    cipher.init(Cipher.ENCRYPT_MODE, keyMap.get(hexKey));
                    break;
            }

            return Hex.encodeHexString(cipher.doFinal(src.getBytes("UTF-8"))).toUpperCase();
        } catch (Exception ex) {
            LOGGER.error("AES加密失败[{}]", src);
            return src;
        }
    }

    public static SecretKeySpec gener(String key) {
        try {
            byte[] finalKey = new byte[16];
            int i = 0;
            for (byte b : key.getBytes("utf-8")) {
                finalKey[i++ % 16] ^= b;
            }
            return new SecretKeySpec(finalKey, "AES");
        } catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return null;
    }
}
