package com.digiwin.athena.semc.util;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.vo.maycur.MaycurCalloutParamsReq;
import com.digiwin.athena.semc.vo.maycur.MaycurTodoNoticeReq;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DesUtil {

    private final static String DES = "DES";
    private final static String ENCODE = "UTF-8";
    //每刻报销入参加密key
    public final static String MAYCUR_APPROVALS_KEY = "wM22y9z5yy7pdXx5bwWj";

    public static void main(String[] args) throws Exception {
        MaycurTodoNoticeReq req=new MaycurTodoNoticeReq();
        MaycurCalloutParamsReq calloutParams=new MaycurCalloutParamsReq();
        calloutParams.setFormCode("wwewewe");
        calloutParams.setFormSubType("32323");
        req.setCalloutParams(calloutParams);
        String  encryptStr=encrypt(JSON.toJSONString(req),MAYCUR_APPROVALS_KEY);
        System.out.println("加密后："+encryptStr);

        String  decryptStr=decrypt(encryptStr,MAYCUR_APPROVALS_KEY);
        System.out.println("解密后："+decryptStr);
    }
    /**
     * 使用 默认key 加密
     */
    public static String encrypt(String data, String key) throws Exception {
        byte[] bt = encrypt(data.getBytes(ENCODE), key.getBytes(ENCODE));
        String strs = Base64.getEncoder().encodeToString(bt);
        return strs;
    }

    /**
     * 使用 默认key 解密
     */
    public static String decrypt(String data, String key) throws IOException, Exception {
        if (data == null)
            return null;
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] buf = decoder.decode(data);
        byte[] bt = decrypt(buf, key.getBytes(ENCODE));
        return new String(bt, ENCODE);
    }

    /**
     * Description 根据键值进行加密
     *
     * @param data
     * @param key
     *            加密键byte数组
     * @return
     * @throws Exception
     */
    private static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        // 生成一个可信任的随机数源
        SecureRandom sr = new SecureRandom();

        // 从原始密钥数据创建DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(key);

        // 创建一个密钥工厂，然后用它把DESKeySpec转换成SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey securekey = keyFactory.generateSecret(dks);

        // Cipher对象实际完成加密操作
        Cipher cipher = Cipher.getInstance(DES);

        // 用密钥初始化Cipher对象
        cipher.init(Cipher.ENCRYPT_MODE, securekey, sr);

        return cipher.doFinal(data);
    }

    /**
     * Description 根据键值进行解密
     *
     * @param data
     * @param key
     *            加密键byte数组
     * @return
     * @throws Exception
     */
    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        // 生成一个可信任的随机数源
        SecureRandom sr = new SecureRandom();

        // 从原始密钥数据创建DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(key);

        // 创建一个密钥工厂，然后用它把DESKeySpec转换成SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey securekey = keyFactory.generateSecret(dks);

        // Cipher对象实际完成解密操作
        Cipher cipher = Cipher.getInstance(DES);

        // 用密钥初始化Cipher对象
        cipher.init(Cipher.DECRYPT_MODE, securekey, sr);

        return cipher.doFinal(data);
    }
}
