package com.digiwin.athena.semc.util;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.proxy.dmc.service.DmcService;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * dmc文件处理
 *
 * @author sunqgz
 * @since 2024-05-21
 */
@Slf4j
@Component
public class DmcFileUtil {

    @Resource
    private DmcService dmcService;

    @Resource
    private ICacheService cacheService;

    /**
     * 调用dmc查询版更详情文件的信息
     * 除登录接口外所有接口都必传登录接口返回的userToken
     *
     * @param fileIdList 文件id列表
     * @return
     */
    public Map<String, Object> queryFileInfoList(List<String> fileIdList) {
        if (CollectionUtils.isEmpty(fileIdList)) {
            return Maps.newHashMap();
        }
        // 获取登录dmc的userToken，查询userToken的缓存key
       /* String key = Constants.DMC_USER_TOKEN + Constants.DMC_USER_NAME + ":" + Constants.DMC_PWD_ENCRYPTION;
        Object dmcUserToken = cacheService.get(key);
        if (ObjectUtils.isNull(dmcUserToken)) {
            dmcUserToken = dmcService.loginDmc();
            cacheService.cache(key, String.valueOf(dmcUserToken), Duration.ofHours(24));
        }*/

        String dmcUserToken = dmcService.loginDmc();
        JSONArray fileInfoArray = dmcService.queryFileInfoList(fileIdList, String.valueOf(dmcUserToken));
        Map<String, Object> fileMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(fileInfoArray)) {
            fileMap = fileInfoArray.stream().collect(Collectors.toMap(x -> {
                LinkedHashMap map = (LinkedHashMap) x;
                return String.valueOf(map.get("id"));
            }, y -> y, (a, b) -> a));
        }
        return fileMap;
    }
}
