package com.digiwin.athena.semc.util;

import com.google.common.collect.Maps;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.util.PropertyPlaceholderHelper;

import java.util.Map;

public class FormatUtil {

    /**
     * 替换String.format()方法
     *
     * @param format 字符串
     * @param args 变量值
     * @return 返回
     */
    public static String format(String format, Object... args) {
        return MessageFormatter.arrayFormat(format, args).getMessage();
    }

    /**
     * 变量替换
     * 例：
     * Map<String, String> map = Maps.newHashMap();
     * map.put("aa", "sss");
     * map.put("bb", "ddd");
     * String res = helper.replacePlaceholders("${aa}--${bb}", map::get);
     * --- 结果：sss--ddd
     *
     * @param format 字符串
     * @param map    变量
     * @return 返回
     */
    public static String replace(String format, Map<String, String> map) {
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", true);
        return helper.replacePlaceholders(format, map::get);
    }
}
