package com.digiwin.athena.semc.util;


import com.baomidou.mybatisplus.core.plugins.IgnoreStrategy;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;

import java.util.function.Supplier;

public class InterceptorIgnoreUtil {

    public static <T> T handler(Supplier<T> supplier) {
        InterceptorIgnoreHelper.handle(IgnoreStrategy.builder().tenantLine(true).build());
        T t = supplier.get();
        InterceptorIgnoreHelper.clearIgnoreStrategy();
        return t;
    }

    public static void handler(Runnable runnable) {
        InterceptorIgnoreHelper.handle(IgnoreStrategy.builder().tenantLine(true).build());
        runnable.run();
        InterceptorIgnoreHelper.clearIgnoreStrategy();
    }


}
