package com.digiwin.athena.semc.util;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenu;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author guijf
 */
public class MenuUtils {


    private MenuUtils() {
    }

    public static List<ManageMenu> resetNanaMenu(List<ManageMenu> menuList, String nanaMenuArrayStr) {
        List<ManageMenu> nanaMenus = StringUtils.isBlank(nanaMenuArrayStr)?null:JsonUtils.jsonToListObject(nanaMenuArrayStr, ManageMenu.class);
        if (CollectionUtils.isEmpty(nanaMenus) || CollectionUtils.isEmpty(nanaMenus)) {
            return menuList;
        }
        Map<String, ManageMenu> nanaFirstLevelMenuMap = nanaMenus.stream().collect(Collectors.toMap(ManageMenu::getMenuKey, Function.identity(), (key1, key2) -> key2));
        List<ManageMenu> firstLevelMenu = menuList.stream().filter(menu -> nanaFirstLevelMenuMap.containsKey(menu.getMenuKey())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(firstLevelMenu)) {
            for (ManageMenu menu : firstLevelMenu) {
                ManageMenu manageMenu = nanaFirstLevelMenuMap.get(menu.getMenuKey());
                if (CollectionUtils.isNotEmpty(menu.getChildrenList()) && CollectionUtils.isNotEmpty(manageMenu.getChildrenList())) {
                    Map<String, ManageMenu> secondaryMenuMap = manageMenu.getChildrenList().stream().collect(Collectors.toMap(ManageMenu::getMenuKey, Function.identity(), (key1, key2) -> key2));
                    List<ManageMenu> secondaryMenus = menu.getChildrenList().stream().filter(children -> secondaryMenuMap.containsKey(children.getMenuKey())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(secondaryMenus)) {
                        for (ManageMenu secondaryMenu : secondaryMenus) {
                            ManageMenu nanaSecondaryMenu = secondaryMenuMap.get(secondaryMenu.getMenuKey());
                            if (CollectionUtils.isNotEmpty(secondaryMenu.getChildrenList()) && CollectionUtils.isNotEmpty(nanaSecondaryMenu.getChildrenList())) {
                                Map<String, ManageMenu> thirdLevelMenuMap = nanaSecondaryMenu.getChildrenList().stream().collect(Collectors.toMap(ManageMenu::getMenuKey, Function.identity(), (key1, key2) -> key2));
                                List<ManageMenu> thirdLevelMenus = secondaryMenu.getChildrenList().stream().filter(children -> thirdLevelMenuMap.containsKey(children.getMenuKey())).collect(Collectors.toList());
                                secondaryMenu.setChildrenList(thirdLevelMenus);
                            }

                        }
                    }
                    menu.setChildrenList(secondaryMenus);
                }
            }
        }
        return firstLevelMenu;
    }
}