package com.digiwin.athena.semc.util;


import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.domain.BaseResultDTO;

import org.slf4j.MDC;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import java.util.Map;

/**
 * 统一响应工具类，用于替换
 * @see com.digiwin.athena.appcore.util.ResponseEntityWrapper
 *
 */
public class ResponseEntityWrapperUtil {
    public static <T> ResponseEntity<BaseResultDTO<T>> wrapperOk(T data) {
        BaseResultDTO<T> result = new BaseResultDTO<>();
        result.setStatus(HttpStatus.OK.value());
        result.setStatusDescription(HttpStatus.OK.getReasonPhrase());
        if (data != null) {
            result.setResponse(data);
        }
        try {
            result.setDebugInfo(MDC.get("filter1"));
        }
        catch (Exception e) {

        }
        return ResponseEntity.ok(result);
    }

    public static <T> ResponseEntity<BaseResultDTO<T>> wrapperOk() {
        BaseResultDTO result = new BaseResultDTO();
        result.setStatus(HttpStatus.OK.value());
        result.setStatusDescription(HttpStatus.OK.getReasonPhrase());
        try {
            result.setDebugInfo(MDC.get("filter1"));
        } catch (Exception e) {

        }
        return ResponseEntity.ok(result);
    }

    public static <T> ResponseEntity<BaseResultDTO<T>> wrapperFail(int errorCode, String errorMessage) {
        return wrapperFail(errorCode,errorMessage,null,null);
    }

    public static <T> ResponseEntity<BaseResultDTO<T>> wrapperFail(int errorCode, String errorMessage, Object debugInfo, Map<String, Object> errorInstructors) {
        BaseResultDTO result = new BaseResultDTO();
        result.setErrorType(ErrorTypeEnum.BUSINESS.getValue());

        result.setErrorCode(String.valueOf(errorCode));
        result.setErrorMessage(errorMessage);

        result.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        result.setStatusDescription(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        result.setDebugInfo(debugInfo);
        if (debugInfo==null) {
            result.setDebugInfo(MDC.get("filter1"));
        }
        else {
            try {
                result.setDescription(MDC.get("filter1"));
            } catch (Exception e) {

            }
        }
//        result.setErrorInstructors(errorInstructors);
        return ResponseEntity.ok(result);
    }
}
