package com.digiwin.athena.semc.util;

import java.util.regex.Pattern;

public class SqlUtils {
    // 匹配连续的空格、制表符、换行符等空白字符
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    // 匹配SQL语句末尾的分号（可选）
    private static final Pattern TRAILING_SEMICOLON_PATTERN = Pattern.compile(";\\s*$");
    
    /**
     * 预处理SQL，移除多余的空行和连续空白符
     * @param originalSql 原始SQL字符串
     * @return 处理后的、紧凑的SQL字符串
     */
    public static String preprocessSql(String originalSql) {
        if (originalSql == null) {
            return null;
        }
        
        // 1. 将连续空白字符替换为单个空格
        String processedSql = WHITESPACE_PATTERN.matcher(originalSql).replaceAll(" ");
        
        // 2. 移除语句末尾可能存在的分号（JSqlParser通常不需要）
        processedSql = TRAILING_SEMICOLON_PATTERN.matcher(processedSql).replaceAll("");
        
        // 3. 确保关键字前后有适当的空格（可选，根据需要实现）
        // processedSql = formatSqlKeywords(processedSql);
        
        return processedSql.trim();
    }
    
    /**
     * 更高级的SQL格式化（可选）
     * 确保SQL关键字前后有适当的空格，提高可读性
     */
    private static String formatSqlKeywords(String sql) {
        // 这里可以添加更复杂的SQL格式化逻辑
        // 例如：确保SELECT、FROM、WHERE等关键字前后有空格
        
        // 简单示例：确保逗号后有空格
        return sql.replaceAll(",\\s*", ", ");
    }
}