package com.digiwin.athena.semc.util;

import com.alibaba.fastjson.JSONArray;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.dto.portal.LabelSystemLinkParamDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Base64Utils;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Slf4j
public class Utils {

    /**
     * URL ???????
     */
    private static final String URL_REGEX = "^(https?|ftp|file)://.*$";

    /*public static void writeJsonObject(HttpServletResponse response, Object obj) {

        if (response.isCommitted()) {
            return;
        }
        try {
            if (obj != null) {
                if (obj instanceof String || isPrimitive(obj.getClass())) {
                    response.getWriter().write(obj.toString());
                } else {
                    response.getWriter().write(JSON.toJSONString(obj));
                }
            }
        } catch (IOException e) {
            log.error("writeJsonObject exception", e);
        }

    }*/

    public static boolean isPrimitive(Class<?> c) {
        if (c != null) {
            if (c.isPrimitive() || c.equals(String.class) || Number.class.isAssignableFrom(c) || Boolean.class.equals(c)
                    || Character.class.isAssignableFrom(c) || Date.class.equals(c) || java.sql.Date.class.equals(c)) {
                return true;
            }
        }
        return false;
    }

    public static String randomNum(int count) {
        return RandomStringUtils.randomNumeric(count);
    }

    public static String generateToken(String username) {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    /**
     * У?? url?????
     * ?? http??https??ftp ?? file ???????????? ://???????????????????
     * ???????????β??
     *
     * @param url
     * @return ??? URL ???????????????????? true??????? false??
     */
    public static boolean isValidURL(String url) {
        Pattern pattern = Pattern.compile(URL_REGEX);
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }


    /**
     * У????????????????
     *
     * @param obj
     * @return
     * @throws IllegalAccessException
     */
    public static boolean isAllFieldsNull(Object obj) throws IllegalAccessException {
        // ?????????????
        Class<?> clazz = obj.getClass();
        // ???????????????
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            // ???÷??????η???????
            field.setAccessible(true);
            // ???????@Deprecated?????????
            if (!field.isAnnotationPresent(Deprecated.class)) {
                if (field.get(obj) != null) {
                    // ???????????β??null?????false
                    return false;
                }
            }
        }
        // ??????ζ??null?????????????????????????ζ????
        return true;
    }


    /**
     * ???????У??
     *
     * @param jsonStr ??????
     * @return
     */
    public static boolean jsonParamValid(String jsonStr) {
        if (StringUtils.isNotBlank(jsonStr)) {
            try {
                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                if (jsonObject.isEmpty()) {
                    return true;
                }
            } catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public static String getInfo(String url, String userToken, String locale, String userId, String tenantId) {
        Map<String, String> map = new HashMap<>();
        Pattern regex = Pattern.compile("\\$\\{([^}]*)\\}");
        Matcher matcher = regex.matcher(url);
        StringBuilder s = new StringBuilder();
        while (matcher.find()) {
            s.append(matcher.group(1) + ",");
        }
        if (s.length() > 0) {
            s.deleteCharAt(s.length() - 1);
        }
        String str = s.toString();
        String[] split = str.split(",");
        String template = "${%s}";
        for (String x : split) {
            if ("mobile_user_token".equals(x))
                map.put(String.format(template, x), userToken);
            if ("locale".equals(x))
                map.put(String.format(template, x), locale);
            if ("tenantId_userId".equals(x))
                map.put(String.format(template, x), tenantId + "_" + userId);
        }
        String pattern = "\\$\\{(.*?)}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(url);
        StringBuffer sr = new StringBuffer();
        while (m.find()) {
            String group = m.group();
            m.appendReplacement(sr, map.get(group));
        }
        m.appendTail(sr);
        return sr.toString();
    }

    public static String getTenantName() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getTenantName();
    }

    public static String getTenantId() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
    }

    public static String getUserToken() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
    }

    public static Long getUserSid() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getSid();
    }

    public static String getUserId() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
    }

    public static String getUserName() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getUserName();
    }

    /**
     * ??????????
     *
     * @param list1
     * @param list2
     * @return
     */
    public static List<String> union(List<String> list1, List<String> list2) {
        list1.addAll(list2);
        return list1.stream().distinct().collect(Collectors.toList());
    }

    /**
     * ????
     *
     * @param list1
     * @param list2
     * @return
     */
    public static List<String> intersect(List<String> list1, List<String> list2) {
        List<String> intersect = list1.stream().filter(item -> list2.contains(item)).collect(Collectors.toList());
        return intersect;
    }

    /**
     * Saml请求Dap加签入参编码
     *
     * @param paramMap 入参的对象，转为JSON String后加密赋值公共参数
     * @return 编码值
     */
    public static String encodeSignArg(Map<String, Object> paramMap) {
        // 1.填充签名字段
        Map<String, String> signMap = new HashMap<>();
        // 时间 yyyyMMddHHmmss
        signMap.put("timestamp", LocalDateTimeUtil.format(LocalDateTime.now(), DatePattern.PURE_DATETIME_FORMATTER));
        // 随机字符串
        signMap.put("nonce", RandomUtil.randomString(32));
        // 排序后拼接,过滤null值
        String signHeaderParams = MapUtil.sortJoin(signMap, "&", "=", true);
        // 获取appSecret
        @SuppressWarnings("all")
        String appSecret = "YynG+rekaI3spXtHwIxbbtJel21bJR7V8KSGPXReMdPKtaRNe0onimEUu3bzTCjj";
        // 3.整理入参 排序后拼接,过滤null值
        String beanParams = MapUtil.sortJoin(BeanUtil.beanToMap(paramMap), "&", "=", true);
        // 4.拼接参数 按照signHeaderParams&beanParams，空值不拼接
        List<String> linkedList = ListUtil.toLinkedList(signHeaderParams, beanParams);
        CollUtil.removeEmpty(linkedList);
        String signString = CollUtil.join(linkedList, "&");
        // 5.计算签名sign，赋值header signInfo.sign字段
        String sign = SecureUtil.hmacSha256(appSecret).digestBase64(signString, CharsetUtil.CHARSET_UTF_8, true);
        signMap.put("sign", sign);
        String signInfoString = JSONUtil.toJsonStr(signMap);
        return URLEncodeUtil.encode(signInfoString);
    }

    /**
     * 获取tokenKey
     *
     * @param systemCode       平台系统编号
     * @param outerLoginUserId 外部系统账号
     * @return
     */
    public static String encryptionTokenKey(String systemCode, String outerLoginUserId) {
        String encode;
        final String base64String = "28682266";
        try {
            JSONObject info = new JSONObject();
            info.put("System", systemCode);    // 平台系统编號 ex:ATHENA
            info.put("Account", outerLoginUserId); // 外部系统帳號 ex:tiptop
            info.put("Date", DateUtils.getNowTime(null));     // 時間搓記
            String token = info.toString();

            // 加密演算法BlowFish
            byte[] keyData = Base64Utils.encode(base64String.getBytes());
            SecretKeySpec spec = new SecretKeySpec(keyData, "BlowFish");
            Cipher cipher = Cipher.getInstance("BlowFish");
            cipher.init(Cipher.ENCRYPT_MODE, spec);

            // 開始加密
            byte[] hasil = cipher.doFinal(token.getBytes());
            encode = new String(Base64Utils.encode(hasil));
            encode = encode.replaceAll("\\+", "_plus_");
        } catch (Exception e) {
            log.error("encrypt token key occur error", e);
            return null;
        }
        return encode;
    }


    /**
     * 将逗号分隔的字符串转List
     *
     * @return
     */
    public static List<String> strToList(String userIds) {
        List<String> strList = new ArrayList<>();
        if (StringUtils.isNotEmpty(userIds)) {
            strList = Arrays.asList(userIds.split(","));
        }
        return strList;
    }

    /**
     * 将名称拼接时间戳，超长按length长度截图
     *
     * @return
     */
    public static String subToName(String name, int length) {
        try {
            length = Math.abs(length - 11);
            if (length > name.length()) {
                length = name.length();
            }
            //需要截图的长度
            String nameApp = name.substring(0, length);
            //13位时间戳
            long time = System.currentTimeMillis();
            //防止时间戳重复，睡眠800毫秒
            //Thread.sleep(300);
            String timeStr = time + "";
            timeStr = timeStr.substring(3, timeStr.length());
            name = nameApp + "_" + timeStr;
        } catch (Exception e) {
            log.error("subToName occur error.", e);
            return name;
        }
        return name;
    }


    /**
     * @param pageSize 每页显示的数量
     * @param pageNum  当前页码
     * @Description: Java8 Stream 分页
     * <br> 1. 起始位置边界值处理： 同 subList 方法
     * <br> 2. 终止位置：无需处理，会自动处理边界问题
     */
    public static List<AppJobDTO.Job> subList(List<AppJobDTO.Job> list, int pageSize, int pageNum) {
        return list.stream().skip((pageNum - 1) * pageSize).limit(pageSize).
                collect(Collectors.toList());
    }


    /**
     * 获取极简图标
     *
     * @return
     */
    public static String getPortCard(int index) {
        String[] portlCardStrs = Constants.PORTAL_CARD.split(",");
        List<String> portlCardList = Arrays.asList(portlCardStrs);
        return portlCardList.get(index);
    }


    /**
     * 初始化excel中表头和表内容的格式
     *
     * @return
     */
    public static HorizontalCellStyleStrategy initHorizontalCell() {
        // 创建一个写出的单元格样式对象
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        // 设置表头字体
        WriteFont headWriteFont = new WriteFont();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        // 设置字体大小为11
        headWriteFont.setFontHeightInPoints((short) 11);
        headWriteFont.setFontName("宋体");
        // 把字体对象设置到单元格样式对象中
        headWriteCellStyle.setWriteFont(headWriteFont);
        // 创建一个写出的单元格样式对象
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        // 设置内容字体
        WriteFont contentWriteFont = new WriteFont();
        // 设置内容字体大小为11
        contentWriteFont.setFontHeightInPoints((short) 11);
        contentWriteFont.setFontName("宋体");
        // 把字体对象设置到单元格样式对象中
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new com.alibaba.excel.write.style.HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        return horizontalCellStyleStrategy;
    }

    /**
     * 判断两个集合之间是否存在交集
     *
     * @param lf
     * @param ng
     * @return
     */
    public static Boolean isIntersection(List<Long> lf, List<Long> ng) {
        lf.retainAll(ng);
        //存在交集
        if (lf.size() > 0) {
            return true;
        }
        return false;
    }

    /**
     * 按长度不足补0
     *
     * @param str    目标字符串
     * @param length 长度
     * @return
     */
    public static String padZeros(String str, int length) {
        StringBuilder sb = new StringBuilder();
        int padding = length - str.length();
        for (int i = 0; i < padding; i++) {
            sb.append("0");
        }
        sb.append(str);
        return sb.toString();
    }

    /**
     * 构建"帆软"应用，作为数据源的源应用
     *
     * @return 返回
     */
    public static AppLinkDTO initFineReportApp() {
        AppLinkDTO athenaAppLinkDTO = new AppLinkDTO();
        athenaAppLinkDTO.setPrimaryId(VirtualApplicationEnum.FINE_REPORT_APP.getPrimaryId());
        athenaAppLinkDTO.setName(VirtualApplicationEnum.FINE_REPORT_APP.getName());
        athenaAppLinkDTO.setCode(VirtualApplicationEnum.FINE_REPORT_APP.getCode());
        athenaAppLinkDTO.setType(String.valueOf(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()));
        athenaAppLinkDTO.setDataSource(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType());
        return athenaAppLinkDTO;
    }

    /**
     * 初始化鼎捷雅典娜APP
     *
     * @return
     */
    public static AppLinkDTO initAthenaApp() {
        // 构建"鼎捷雅典娜APP"，作为数据源的源应用
        AppLinkDTO athenaAppLinkDTO = new AppLinkDTO();
        athenaAppLinkDTO.setPrimaryId(VirtualApplicationEnum.ATHENA_APP.getPrimaryId());
        athenaAppLinkDTO.setName(VirtualApplicationEnum.ATHENA_APP.getName());
        athenaAppLinkDTO.setCode(VirtualApplicationEnum.ATHENA_APP.getCode());
        athenaAppLinkDTO.setIsNeedSsoUrl(1);
        athenaAppLinkDTO.setType(String.valueOf(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()));
        athenaAppLinkDTO.setDataSource(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType());
        return athenaAppLinkDTO;
    }

    /**
     * 初始化雅典娜智驱平台
     *
     * @return
     */
    public static AppLinkDTO initAppInteraction() {
        // 构建"雅典娜智驱平台"，作为数据源"业务待办"类型的源应用
        AppLinkDTO appLinkDTO = new AppLinkDTO();
        appLinkDTO.setPrimaryId(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getPrimaryId());
        appLinkDTO.setName(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getName());
        appLinkDTO.setCode(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getCode());
        appLinkDTO.setType(String.valueOf(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()));
        appLinkDTO.setDataSource(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType());
        return appLinkDTO;
    }

    /**
     * 构建未替换参数的链接
     *
     * @param linkParam 链接参数
     * @return 返回
     */
    public static StringBuilder buildWebLinkDisplayUrl(String linkParam) {
        List<LabelSystemLinkParamDTO> linkParamList = JSONArray.parseArray(linkParam, LabelSystemLinkParamDTO.class);

        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < linkParamList.size(); i++) {
            LabelSystemLinkParamDTO paramDTO = linkParamList.get(i);
            if (Constants.WebLabelLinkEnum.COMMON_PARAM.getType().equals(paramDTO.getType())) {
                if(StringUtils.isNotBlank(paramDTO.getValue())){
                    stringBuilder.append(paramDTO.getKey()).append("=${").append(paramDTO.getValue()).append("}");
                }else {
                    stringBuilder.append(paramDTO.getKey()).append("=");
                }
            } else {
                stringBuilder.append(paramDTO.getKey()).append("=").append(paramDTO.getValue());
            }
            if (i != linkParamList.size() - 1) {
                stringBuilder.append("&");
            }
        }
        return stringBuilder;
    }

    /**
     * 构建链接
     *
     * @param linkParam 链接参数
     * @return 返回
     */
    public static StringBuilder buildWebLinkUrl(String linkParam) {
        List<LabelSystemLinkParamDTO> linkParamList = JSONArray.parseArray(linkParam, LabelSystemLinkParamDTO.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < linkParamList.size(); i++) {
            LabelSystemLinkParamDTO paramDTO = linkParamList.get(i);
            // 常用链接参数需要动态替换
            if (Constants.WebLabelLinkEnum.COMMON_PARAM.getType().equals(paramDTO.getType())) {
                String value = StringUtils.EMPTY;
                if (Constants.WebLabelCommonParamEnum.USER_ID.getKey().equals(paramDTO.getValue())) {
                    value = Utils.getUserId();
                } else if (Constants.WebLabelCommonParamEnum.USER_TOKEN.getKey().equals(paramDTO.getValue())) {
                    value = Utils.getUserToken();
                } else if (Constants.WebLabelCommonParamEnum.TIMESTAMP.getKey().equals(paramDTO.getValue())) {
                    value = String.valueOf(new Date().getTime());
                } else if (Constants.WebLabelCommonParamEnum.LANGUAGE.getKey().equals(paramDTO.getValue())) {
                    value = LocaleContextHolder.getLocale().toString();
                }
                stringBuilder.append(paramDTO.getKey()).append("=").append(value);
            } else {
                stringBuilder.append(paramDTO.getKey()).append("=").append(paramDTO.getValue());
            }
            if (i != linkParamList.size() - 1) {
                stringBuilder.append("&");
            }
        }
        return stringBuilder;
    }

    public static Integer toInt(String str,Integer defaultValue) {
        try {
            return Integer.parseInt(str);
        } catch (NumberFormatException e) {
            return defaultValue; // 或抛出自定义异常
        }
    }

}
