package com.digiwin.athena.semc.util.thread;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.semc.common.enums.BizObjectTypeEnum;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.proxy.iam.service.model.UserDTO;
import com.digiwin.athena.semc.service.common.IBizObjAuthRelService;
import com.digiwin.athena.semc.service.common.impl.BizObjAuthRelServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 金雨刷数据
 *
 * @author: sungq
 * @date: 2023-09-22
 */
@Slf4j
@Service
@Component
public class BrushDataThread implements Runnable {

    private IBizObjAuthRelService bizObjAuthRelService = new BizObjAuthRelServiceImpl();

    /**
     * 用户列表分段
     */
    private List<List<UserDTO>> newUserList;

    /**
     * 应用列表
     */
    private List<JSONObject> appList;

    public BrushDataThread(List<List<UserDTO>> newUserList, List<JSONObject> appList) {
        this.newUserList = newUserList;
        this.appList = appList;
    }

    @Override
    public void run() {
        // 每个应用分次绑定所有用户
        for (JSONObject app : appList) {
            int userCount = 0;
            for (List<UserDTO> partUserList : newUserList) {
                try {
                    List<BizObjAuthRel> bizObjAuthRelList = new ArrayList<>();
                    for (UserDTO auth : partUserList) {
                        BizObjAuthRel bizObjAuthRel = new BizObjAuthRel();
                        bizObjAuthRel.setBizObjId(app.getString("id"));
                        bizObjAuthRel.setBizObjType(BizObjectTypeEnum.APPlICATION_MANAGEMENT.getValue());
                        bizObjAuthRel.setBizObjSubType(app.getInteger("type"));
                        bizObjAuthRel.setAuthId(auth.getSid());
                        bizObjAuthRel.setAuthName(auth.getName());
                        bizObjAuthRel.setAuthType(3);
                        bizObjAuthRelList.add(bizObjAuthRel);
                    }
                    userCount = userCount + bizObjAuthRelList.size();
                    bizObjAuthRelService.saveBatch(bizObjAuthRelList);
                } catch (Exception e) {
                    log.info("insert app-user-rel error, appId:{}", app.getString("id"), e);
                }
            }
            log.info("insert app-user-rel success, appId:{}, userCount:{}", app.getString("id"), userCount);
        }
        log.info("insert app-user-rel final success, appCount:{}", appList.size());
    }
}