package com.digiwin.athena.semc.util.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @description: thread factory
 * @author: sunyfa
 */
public class NamedThreadFactory implements ThreadFactory {
    private static final AtomicLong COUNTER = new AtomicLong();

    private static final String DEFAULT_FACTORY_NAME = "default-pool";

    private final String factoryName;

    NamedThreadFactory() {
        this.factoryName = DEFAULT_FACTORY_NAME;
    }

    public NamedThreadFactory(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getFactoryName() {
        return factoryName;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName(factoryName + "-t-" + COUNTER.getAndIncrement());
        return thread;
    }
}
