package com.digiwin.athena.semc.vo.auth;

import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;

import java.io.Serializable;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 权限对象
 *
 * @author sunqgz
 * @since 2024-05-14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = NewsAnnouncementAut.class)
public class AuthVO implements Serializable {

    private static final long serialVersionUID = 1535138712123139940L;

    /**
     * 权限id
     */
    private Long authId;

    /**
     * 权限业务id，即组织id，角色id，用户id等
     */
    private String authBizId;

    /**
     * 权限类型：1.组织 2.角色 3.用户 4.外部用户 5.部门
     */
    private Integer authType;

    /**
     * 权限名称
     */
    private String authName;
}

