package com.digiwin.athena.semc.vo.bench;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 泳道下组件顺序调整
 */
@Data
public class OrderLaneJobVO implements Serializable {

    /**
     * 调整前泳道ID
     */
    private Long oldBenchId;

    /**
     * 调整前泳道下面的组件ID
     */
    private Long oldSystemId;

    /**
     * 调整后前泳道id
     */
    @NotNull(message = "nowBenchId cannot be empty")
    private Long nowBenchId;

    /**
     * 调整后自定义组件ID集合
     */
    @NotEmpty(message = "benchLaneList cannot be empty")
    private List<Long> nowSystemIdList;

}
