package com.digiwin.athena.semc.vo.common;

import com.baomidou.mybatisplus.annotation.TableField;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;


/**
 *  @date 2022/12/23
 */
@Data
public class AuthSystemLabelReq {


    /**
     * 权限ID
     */
    private  Long authId;


    /**
     * 权限类型：1.组织 2.角色 3.用户 4.外部用户
     */
    private Integer authType;

    /**
     * 权限名称
     */
    private String authName;

    /**
     * 客户端类型 PC端：0，移动端：1
     * ClientTypeTypeEnum
     */
    @NotNull(message = "clientType cannot be empty")
    @Range(min = 0, max = 1, message = "clientType is illegal")
    private Integer clientType;

    /**
     * 搜索关键词分组名称
     */
    private  String name;

    /**
     * 是否关联，true：关联， false：未关联
     */
    private Boolean isRelated;

    /**
     * 源应用
     */
    private List<AppLinkDTO> appCodeList;

    /**
     *  页码
     */
    private Integer pageNum;

    /**
     * 每页数量
     */
    private Integer pageSize;
}
