package com.digiwin.athena.semc.vo.common;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 业务授权关系 友情链接
 * @createDate: 2023/9/11
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class BizObjAuthRelBatchForLinkReq implements Serializable {

    private static final long serialVersionUID = 6497000399827941640L;

    /**
     * 权限对象列表
     */
    @Valid
    @NotEmpty(message = "authList cannot be empty")
    private List<AuthVO> authList;

    /**
     * 应用列表
     */
    @Valid
    private List<AppVO> appList;

    /**
     * 权限
     */
    @Data
    public static class AuthVO {
        /**
         * 权限对象id
         */
        @NotNull(message = "{NotNull.BizObjAuthRelVo.authId}")
        private Long authId;

        /**
         * 权限类型：1.组织 2.角色 3.用户 5.部门
         */
        @NotNull(message = "{NotNull.BizObjAuthRelVo.authType}")
        private Integer authType;

        /**
         * 权限对象名称
         */
        @NotBlank(message = "{NotBlank.BizObjAuthRelVo.authName}")
        private String authName;
    }

    /**
     * 应用
     */
    @Data
    public static class AppVO {
        /**
         * 应用主键id
         */
        @NotNull(message = "{NotNull.Folder.id}")
        private String primaryId;

        /**
         * 应用类型：1:b/s应用 2:c/s应用 3:特殊应用 4:雅典娜应用
         */
        @NotNull(message = "{NotNull.LinkAppVO.type}")
        @Range(min = 1, max = 4, message = "{Range.LinkAppVO.type}")
        private Integer bizObjSubType;
    }
}